/*
 * Decompiled with CFR 0.152.
 */
package demos.particles.engine;

import demos.particles.engine.Engine;
import demos.particles.engine.GLComponent;
import demos.particles.engine.RGBA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlWindow
extends JFrame
implements ActionListener,
ChangeListener {
    private Engine engine;
    private GLComponent glComponent;
    private Integer numParticles;
    private JSlider greenSlider;
    private JSlider redSlider;
    private JSlider blueSlider;
    private JButton resetButton;
    private JButton closeButton;
    private JSpinner particleSpinner;

    public ControlWindow() {
        super("Particle Engine");
        Dimension dimension = this.getToolkit().getScreenSize();
        this.buildFrame(dimension);
        this.initComponents();
        this.setVisible(true);
    }

    private void buildFrame(Dimension dimension) {
        int n = 800;
        int n2 = (int)(dimension.getWidth() / 2.0) - n / 2;
        int n3 = 800;
        int n4 = (int)(dimension.getHeight() / 2.0) - n3 / 2;
        this.setBounds(n2, n4, n, n3);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        this.numParticles = new Integer(1000);
        this.engine = new Engine(this.numParticles, "demos/particles/engine/images/particle.jpg");
        this.glComponent = new GLComponent(60, new RGBA(0.0f, 0.0f, 0.0f, 1.0f), new RGBA(0.0f, 0.0f, 0.0f, 1.0f), this.engine);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.redSlider = new JSlider(0, 100, (int)this.engine.tendToColor.r * 100);
        this.redSlider.addChangeListener(this);
        this.greenSlider = new JSlider(0, 100, (int)this.engine.tendToColor.g * 100);
        this.greenSlider.addChangeListener(this);
        this.blueSlider = new JSlider(0, 100, (int)this.engine.tendToColor.b * 100);
        this.blueSlider.addChangeListener(this);
        this.particleSpinner = new JSpinner(new SpinnerNumberModel(this.numParticles, new Integer(0), null, new Integer(1)));
        this.particleSpinner.addChangeListener(this);
        this.particleSpinner.setPreferredSize(new Dimension((int)((double)this.getBounds().width / 3.5), 25));
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f)), "Color Tendency");
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("Red"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.redSlider, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Green"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.greenSlider, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel("Blue"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.blueSlider, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f)), "Number of Particles");
        jPanel2.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        jPanel2.add((Component)this.particleSpinner, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f)), "Options");
        jPanel3.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel3.add((Component)this.resetButton, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        jPanel3.add((Component)this.closeButton, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setPreferredSize(new Dimension(this.getBounds().width - 10, this.getBounds().height * 3 / 4));
        jPanel4.add((Component)((Object)this.glComponent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel4.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 3, 3, 3));
        jPanel5.add(jPanel);
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        this.getContentPane().add((Component)jPanel5, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        new ControlWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.closeButton)) {
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
        if (actionEvent.getSource().equals(this.resetButton)) {
            this.engine.reset();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.particleSpinner)) {
            Integer n = (Integer)this.particleSpinner.getValue();
            int n2 = n - this.numParticles;
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    this.engine.addParticle();
                }
            } else {
                for (int i = 0; i > n2; --i) {
                    this.engine.removeParticle();
                }
            }
            this.numParticles = n;
        }
        if (changeEvent.getSource().equals(this.redSlider)) {
            float f = this.redSlider.getValue();
            this.engine.tendToColor.r = f /= 100.0f;
        }
        if (changeEvent.getSource().equals(this.greenSlider)) {
            float f = this.greenSlider.getValue();
            this.engine.tendToColor.g = f /= 100.0f;
        }
        if (changeEvent.getSource().equals(this.blueSlider)) {
            float f = this.blueSlider.getValue();
            this.engine.tendToColor.b = f /= 100.0f;
        }
    }
}

