/*
 * Decompiled with CFR 0.152.
 */
package demos.particles.engine;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import demos.particles.engine.Particle;
import demos.particles.engine.RGBA;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public class Engine {
    private Texture texture;
    private List particles;
    private String path;
    public RGBA tendToColor;

    public Engine(int n, String string) {
        this.path = string;
        this.tendToColor = new RGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.particles = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.particles.add(new Particle());
        }
    }

    public void addParticle() {
        this.particles.add(new Particle());
    }

    public void removeParticle() {
        if (this.particles.size() - 1 >= 0) {
            this.particles.remove(this.particles.size() - 1);
        }
    }

    public void draw(GL gL) {
        gL.glClear(16640);
        gL.glLoadIdentity();
        for (int i = 0; i < this.particles.size(); ++i) {
            ((Particle)this.particles.get(i)).draw(gL, this.texture, this.tendToColor);
        }
    }

    public void init() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource(this.path);
            this.texture = TextureIO.newTexture((URL)uRL, (boolean)false, null);
            this.texture.enable();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
        }
    }

    public void reset() {
        int n = this.particles.size();
        this.particles = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.particles.add(new Particle());
        }
    }
}

