/*
 * Decompiled with CFR 0.152.
 */
package demos.particles.engine;

import com.sun.opengl.util.FPSAnimator;
import demos.particles.engine.Engine;
import demos.particles.engine.RGBA;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public class GLComponent
extends GLCanvas
implements GLEventListener {
    private GLU glu;
    private FPSAnimator animator;
    private RGBA background;
    private RGBA ambient;
    private Engine engine;

    public GLComponent(int n, RGBA rGBA, RGBA rGBA2, Engine engine) {
        super(GLComponent.getCapabilities());
        this.addGLEventListener(this);
        this.glu = new GLU();
        this.background = rGBA2;
        this.ambient = rGBA;
        this.engine = engine;
        this.animator = new FPSAnimator((GLAutoDrawable)this, n);
    }

    private static GLCapabilities getCapabilities() {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        return gLCapabilities;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        this.engine.draw(gL);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glShadeModel(7425);
        gL.glClearColor(this.background.r, this.background.g, this.background.b, this.background.a);
        gL.glClearDepth(1.0);
        gL.glDisable(2929);
        gL.glEnable(3042);
        gL.glBlendFunc(770, 1);
        gL.glHint(3152, 4354);
        gL.glHint(3153, 4354);
        gL.glEnable(3553);
        this.animator.start();
        this.engine.init();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        gL.glViewport(0, 0, n3, n4);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        double d = (double)n3 / (double)n4;
        this.glu.gluPerspective(45.0, d, 0.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
    }

    public void setFPS(int n) {
        this.animator.stop();
        this.animator = new FPSAnimator((GLAutoDrawable)this, n);
        this.animator.start();
    }

    public void kill() {
        this.animator.stop();
    }
}

