/*
 * Decompiled with CFR 0.152.
 */
package demos.proceduralTexturePhysics;

import com.sun.opengl.util.Animator;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.proceduralTexturePhysics.Water;
import demos.util.DurationTimer;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.ManipManager;
import gleem.MouseButtonHelper;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.swing.JOptionPane;

public class ProceduralTexturePhysics
extends Demo {
    private volatile boolean drawing;
    private volatile int mousePosX;
    private volatile int mousePosY;
    private GLAutoDrawable drawable;
    private Water water = new Water();
    private volatile ExaminerViewer viewer;
    private boolean[] b = new boolean[256];
    private boolean doViewAll = true;
    private float zNear = 0.1f;
    private float zFar = 10.0f;
    private DurationTimer timer = new DurationTimer();
    private boolean firstRender = true;
    private int frameCount;
    private float blurIncrement = 0.01f;
    private float bumpIncrement = 0.01f;
    private float frequencyIncrement = 0.1f;

    public static void main(String[] stringArray) {
        GLCanvas gLCanvas = new GLCanvas();
        ProceduralTexturePhysics proceduralTexturePhysics = new ProceduralTexturePhysics();
        gLCanvas.addGLEventListener((GLEventListener)proceduralTexturePhysics);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        proceduralTexturePhysics.setDemoListener(new DemoListener(){

            public void shutdownDemo() {
                ProceduralTexturePhysics.runExit(animator);
            }

            public void repaint() {
            }
        });
        Frame frame = new Frame("Procedural Texture Waves");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.show();
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProceduralTexturePhysics.runExit(animator);
            }
        });
        animator.start();
    }

    public void shutdownDemo() {
        this.viewer.detach();
        ManipManager.getManipManager().unregisterWindow(this.drawable);
        this.drawable.removeGLEventListener((GLEventListener)this);
        super.shutdownDemo();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.water.destroy();
        this.water.initialize("demos/data/images/nvfixed.tga", "demos/data/images/nvspin.tga", "demos/data/images/droplet.tga", "demos/data/cubemaps/CloudyHills_", "tga", gLAutoDrawable);
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(1);
        try {
            this.checkExtension(gL, "GL_VERSION_1_3");
            this.checkExtension(gL, "GL_ARB_vertex_program");
            this.checkExtension(gL, "GL_ARB_fragment_program");
            this.checkExtension(gL, "GL_ARB_pbuffer");
            this.checkExtension(gL, "GL_ARB_pixel_format");
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
            throw gLException;
        }
        gL.glClearColor(0.0f, 0.2f, 0.5f, 0.0f);
        gL.glDisable(2896);
        gL.glDisable(2929);
        gL.glDisable(2884);
        this.doViewAll = true;
        if (this.firstRender) {
            this.firstRender = false;
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow(gLAutoDrawable);
            this.drawable = gLAutoDrawable;
            this.viewer = new ExaminerViewer(MouseButtonHelper.numMouseButtons());
            this.viewer.setAutoRedrawMode(false);
            this.viewer.attach(gLAutoDrawable, new BSphereProvider(){

                public BSphere getBoundingSphere() {
                    return new BSphere(new Vec3f(0.0f, 0.0f, 0.0f), 1.2f);
                }
            });
            this.viewer.setVertFOV(1.4726216f);
            this.viewer.setZNear(this.zNear);
            this.viewer.setZFar(this.zFar);
            gLAutoDrawable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    ProceduralTexturePhysics.this.dispatchKey(keyEvent.getKeyChar());
                }
            });
            gLAutoDrawable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                        ProceduralTexturePhysics.this.drawing = true;
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        ProceduralTexturePhysics.this.drawing = false;
                    }
                }
            });
            gLAutoDrawable.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    ProceduralTexturePhysics.this.mousePosX = mouseEvent.getX();
                    ProceduralTexturePhysics.this.mousePosY = mouseEvent.getY();
                }
            });
            this.timer.start();
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (++this.frameCount == 30) {
            this.timer.stop();
            System.err.println("Frames per second: " + 30.0f / this.timer.getDurationAsSeconds());
            this.timer.reset();
            this.timer.start();
            this.frameCount = 0;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16640);
        if (this.doViewAll) {
            this.viewer.viewAll(gL);
            this.doViewAll = false;
        }
        this.viewer.update(gL);
        ManipManager.getManipManager().updateCameraParameters(gLAutoDrawable, this.viewer.getCameraParameters());
        ManipManager.getManipManager().render(gLAutoDrawable, gL);
        if (this.drawing) {
            int n = gLAutoDrawable.getWidth();
            int n2 = gLAutoDrawable.getHeight();
            this.water.addDroplet(new Water.Droplet(2.0f * ((float)this.mousePosX / (float)n - 0.5f), -2.0f * ((float)this.mousePosY / (float)n2 - 0.5f), 0.08f));
        }
        this.water.tick();
        CameraParameters cameraParameters = this.viewer.getCameraParameters();
        this.water.draw(gL, cameraParameters.getOrientation().inverse());
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void setFlag(char c, boolean bl) {
        this.b[c & 0xFF] = bl;
    }

    private boolean getFlag(char c) {
        return this.b[c & 0xFF];
    }

    private void checkExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            String string2 = "Unable to initialize " + string + " OpenGL extension";
            JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
            this.shutdownDemo();
        }
    }

    private void dispatchKey(char c) {
        this.setFlag(c, !this.getFlag(c));
        switch (c) {
            case '\u001b': 
            case 'q': {
                this.shutdownDemo();
                break;
            }
            case 'w': {
                this.water.enableWireframe(this.getFlag('w'));
                break;
            }
            case 'd': {
                break;
            }
            case ' ': {
                this.water.enableAnimation(this.getFlag(' '));
                break;
            }
            case 'b': {
                this.water.enableBorderWrapping(this.getFlag('b'));
                break;
            }
            case 'n': {
                this.water.singleStep();
                break;
            }
            case 's': {
                this.water.enableSlowAnimation(this.getFlag('s'));
                break;
            }
            case '1': {
                this.water.setRenderMode(0);
                break;
            }
            case '2': {
                this.water.setRenderMode(2);
                break;
            }
            case '3': {
                this.water.setRenderMode(1);
                break;
            }
            case '4': {
                this.water.setRenderMode(3);
                break;
            }
            case '5': {
                this.water.setRenderMode(4);
                break;
            }
            case 'r': {
                this.water.reset();
                break;
            }
            case 'i': {
                this.doViewAll = true;
                break;
            }
            case 'c': {
                float f = this.water.getBlurDistance();
                if (!(f > this.blurIncrement)) break;
                this.water.setBlurDistance(f - this.blurIncrement);
                break;
            }
            case 'v': {
                float f = this.water.getBlurDistance();
                if (!(f < 1.0f)) break;
                this.water.setBlurDistance(f + this.blurIncrement);
                break;
            }
            case '-': {
                float f = this.water.getBumpScale();
                if (!(f > -1.0f)) break;
                this.water.setBumpScale(f - this.bumpIncrement);
                break;
            }
            case '=': {
                float f = this.water.getBumpScale();
                if (!(f < 1.0f)) break;
                this.water.setBumpScale(f + this.bumpIncrement);
                break;
            }
            case 'l': {
                this.water.enableBoundaryApplication(this.getFlag('l'));
                break;
            }
            case 'o': {
                this.water.enableSpinningLogo(this.getFlag('o'));
                break;
            }
            case '.': {
                float f = this.water.getBumpScale();
                if (!(f < 1.0f)) break;
                this.water.setDropFrequency(f + this.frequencyIncrement);
                break;
            }
            case ',': {
                float f = this.water.getBumpScale();
                if (!(f > 0.0f)) break;
                this.water.setDropFrequency(f - this.frequencyIncrement);
                break;
            }
        }
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }
}

