/*
 * Decompiled with CFR 0.152.
 */
package demos.proceduralTexturePhysics;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import demos.util.Cubemap;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.glu.GLU;

public class Water {
    private GLU glu = new GLU();
    public static final int CA_FULLSCREEN_REFLECT = 0;
    public static final int CA_FULLSCREEN_FORCE = 1;
    public static final int CA_FULLSCREEN_HEIGHT = 2;
    public static final int CA_FULLSCREEN_NORMALMAP = 3;
    public static final int CA_TILED_THREE_WINDOWS = 4;
    public static final int CA_DO_NOT_RENDER = 5;
    private int[] initialMapDimensions = new int[2];
    private TextureData initialMapData;
    private String tmpSpinFilename;
    private String tmpDropletFilename;
    private String tmpCubeMapFilenamePrefix;
    private String tmpCubeMapFilenameSuffix;
    private GLPbuffer pbuffer;
    private Rotf cameraOrientation = new Rotf();
    private static final int CA_TEXTURE_FORCE_INTERMEDIATE = 0;
    private static final int CA_TEXTURE_FORCE_TARGET = 1;
    private static final int CA_TEXTURE_VELOCITY_SOURCE = 2;
    private static final int CA_TEXTURE_VELOCITY_TARGET = 3;
    private static final int CA_TEXTURE_HEIGHT_SOURCE = 4;
    private static final int CA_TEXTURE_HEIGHT_TARGET = 5;
    private static final int CA_TEXTURE_NORMAL_MAP = 6;
    private static final int CA_NUM_DYNAMIC_TEXTURES = 7;
    private static final int CA_FRAGMENT_PROGRAM_EQ_WEIGHT_COMBINE = 0;
    private static final int CA_FRAGMENT_PROGRAM_NEIGHBOR_FORCE_CALC_1 = 1;
    private static final int CA_FRAGMENT_PROGRAM_NEIGHBOR_FORCE_CALC_2 = 2;
    private static final int CA_FRAGMENT_PROGRAM_APPLY_FORCE = 3;
    private static final int CA_FRAGMENT_PROGRAM_APPLY_VELOCITY = 4;
    private static final int CA_FRAGMENT_PROGRAM_CREATE_NORMAL_MAP = 5;
    private static final int CA_FRAGMENT_PROGRAM_REFLECT = 6;
    private static final int CA_DRAW_SCREEN_QUAD = 7;
    private static final int CA_NUM_LISTS = 8;
    private Texture initialMapTex;
    private Texture spinTex;
    private Texture dropletTex;
    private Texture cubemap;
    private Texture[] dynamicTextures = new Texture[7];
    private int texHeightInput;
    private int texHeightOutput;
    private int texVelocityInput;
    private int texVelocityOutput;
    private int texForceStepOne;
    private int texForceOutput;
    private int[] displayListIDs = new int[8];
    private int vertexProgramID;
    private int flipState;
    private boolean wrap;
    private boolean reset = true;
    private boolean singleStep;
    private boolean animate = true;
    private boolean slow = true;
    private boolean wireframe;
    private boolean applyInteriorBoundaries = true;
    private boolean spinLogo = true;
    private boolean createNormalMap = true;
    private float perTexelWidth;
    private float perTexelHeight;
    private float blurDist = 0.5f;
    private boolean mustUpdateBlurOffsets;
    private float normalSTScale = 0.8f;
    private float bumpScale = 0.25f;
    private float dropletFrequency = 0.175f;
    private int slowDelay = 1;
    private int skipInterval;
    private int skipCount;
    private int angle;
    private List droplets = new ArrayList();
    private int renderMode;
    private static final int CV_UV_OFFSET_TO_USE = 0;
    private static final int CV_UV_T0_NO_OFFSET = 1;
    private static final int CV_UV_T0_TYPE1 = 2;
    private static final int CV_UV_T0_TYPE2 = 3;
    private static final int CV_UV_T0_TYPE3 = 4;
    private static final int CV_UV_T0_TYPE4 = 5;
    private static final int CV_UV_T1_NO_OFFSET = 6;
    private static final int CV_UV_T1_TYPE1 = 7;
    private static final int CV_UV_T1_TYPE2 = 8;
    private static final int CV_UV_T1_TYPE3 = 9;
    private static final int CV_UV_T1_TYPE4 = 10;
    private static final int CV_UV_T2_NO_OFFSET = 11;
    private static final int CV_UV_T2_TYPE1 = 12;
    private static final int CV_UV_T2_TYPE2 = 13;
    private static final int CV_UV_T2_TYPE3 = 14;
    private static final int CV_UV_T2_TYPE4 = 15;
    private static final int CV_UV_T3_NO_OFFSET = 16;
    private static final int CV_UV_T3_TYPE1 = 17;
    private static final int CV_UV_T3_TYPE2 = 18;
    private static final int CV_UV_T3_TYPE3 = 19;
    private static final int CV_UV_T3_TYPE4 = 20;
    private static final int CV_CONSTS_1 = 21;

    public void initialize(String string, String string2, String string3, String string4, String string5, GLAutoDrawable gLAutoDrawable) {
        this.loadInitialTexture(string);
        this.tmpSpinFilename = string2;
        this.tmpDropletFilename = string3;
        this.tmpCubeMapFilenamePrefix = string4;
        this.tmpCubeMapFilenameSuffix = string5;
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(false);
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            throw new GLException("Pbuffers not supported with this graphics card");
        }
        this.pbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, this.initialMapDimensions[0], this.initialMapDimensions[1], gLAutoDrawable.getContext());
        this.pbuffer.addGLEventListener((GLEventListener)new Listener());
    }

    public void destroy() {
        if (this.pbuffer != null) {
            this.pbuffer.destroy();
            this.pbuffer = null;
        }
        this.reset = true;
    }

    public void tick() {
        this.pbuffer.display();
    }

    public void draw(GL gL, Rotf rotf) {
        this.cameraOrientation.set(rotf);
        if (this.skipCount >= this.skipInterval && this.renderMode != 5) {
            this.skipCount = 0;
            if (this.wireframe) {
                gL.glPolygonMode(1032, 6913);
                gL.glDisable(3553);
            } else {
                gL.glPolygonMode(1032, 6914);
                gL.glActiveTexture(33984);
                gL.glEnable(3553);
            }
            switch (this.renderMode) {
                case 0: {
                    Mat4f mat4f = new Mat4f();
                    mat4f.makeIdent();
                    mat4f.set(0, 0, this.bumpScale);
                    mat4f.set(1, 1, this.bumpScale);
                    Mat4f mat4f2 = new Mat4f();
                    mat4f2.makeIdent();
                    mat4f2.setRotation(rotf);
                    Mat4f mat4f3 = mat4f2.mul(mat4f);
                    gL.glCallList(this.displayListIDs[6]);
                    gL.glActiveTexture(33984);
                    this.dynamicTextures[6].bind();
                    this.dynamicTextures[6].disable();
                    gL.glActiveTexture(33987);
                    this.cubemap.bind();
                    this.cubemap.enable();
                    gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    gL.glBegin(7);
                    gL.glMultiTexCoord2f(33984, 0.0f, 0.0f);
                    gL.glMultiTexCoord4f(33985, mat4f3.get(0, 0), mat4f3.get(0, 1), mat4f3.get(0, 2), 1.0f);
                    gL.glMultiTexCoord4f(33986, mat4f3.get(1, 0), mat4f3.get(1, 1), mat4f3.get(1, 2), 1.0f);
                    gL.glMultiTexCoord4f(33987, mat4f3.get(2, 0), mat4f3.get(2, 1), mat4f3.get(2, 2), 1.0f);
                    gL.glVertex2f(-1.0f, -1.0f);
                    gL.glMultiTexCoord2f(33984, 1.0f, 0.0f);
                    gL.glMultiTexCoord4f(33985, mat4f3.get(0, 0), mat4f3.get(0, 1), mat4f3.get(0, 2), -1.0f);
                    gL.glMultiTexCoord4f(33986, mat4f3.get(1, 0), mat4f3.get(1, 1), mat4f3.get(1, 2), 1.0f);
                    gL.glMultiTexCoord4f(33987, mat4f3.get(2, 0), mat4f3.get(2, 1), mat4f3.get(2, 2), 1.0f);
                    gL.glVertex2f(1.0f, -1.0f);
                    gL.glMultiTexCoord2f(33984, 1.0f, 1.0f);
                    gL.glMultiTexCoord4f(33985, mat4f3.get(0, 0), mat4f3.get(0, 1), mat4f3.get(0, 2), -1.0f);
                    gL.glMultiTexCoord4f(33986, mat4f3.get(1, 0), mat4f3.get(1, 1), mat4f3.get(1, 2), -1.0f);
                    gL.glMultiTexCoord4f(33987, mat4f3.get(2, 0), mat4f3.get(2, 1), mat4f3.get(2, 2), 1.0f);
                    gL.glVertex2f(1.0f, 1.0f);
                    gL.glMultiTexCoord2f(33984, 0.0f, 1.0f);
                    gL.glMultiTexCoord4f(33985, mat4f3.get(0, 0), mat4f3.get(0, 1), mat4f3.get(0, 2), 1.0f);
                    gL.glMultiTexCoord4f(33986, mat4f3.get(1, 0), mat4f3.get(1, 1), mat4f3.get(1, 2), -1.0f);
                    gL.glMultiTexCoord4f(33987, mat4f3.get(2, 0), mat4f3.get(2, 1), mat4f3.get(2, 2), 1.0f);
                    gL.glVertex2f(-1.0f, 1.0f);
                    gL.glEnd();
                    this.cubemap.disable();
                    gL.glDisable(34820);
                    break;
                }
                case 3: {
                    gL.glActiveTexture(33984);
                    this.dynamicTextures[6].bind();
                    gL.glCallList(this.displayListIDs[7]);
                    break;
                }
                case 2: {
                    gL.glActiveTexture(33984);
                    gL.glBindTexture(3553, this.texHeightOutput);
                    gL.glCallList(this.displayListIDs[7]);
                    break;
                }
                case 1: {
                    gL.glActiveTexture(33984);
                    this.dynamicTextures[1].bind();
                    gL.glCallList(this.displayListIDs[7]);
                    break;
                }
                case 4: {
                    gL.glActiveTexture(33984);
                    this.dynamicTextures[1].bind();
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    gL.glTranslatef(-0.5f, -0.5f, 0.0f);
                    gL.glScalef(0.5f, 0.5f, 1.0f);
                    gL.glCallList(this.displayListIDs[7]);
                    gL.glPopMatrix();
                    gL.glBindTexture(3553, this.texVelocityOutput);
                    gL.glPushMatrix();
                    gL.glTranslatef(0.5f, -0.5f, 0.0f);
                    gL.glScalef(0.5f, 0.5f, 1.0f);
                    gL.glCallList(this.displayListIDs[7]);
                    gL.glPopMatrix();
                    this.dynamicTextures[6].bind();
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    gL.glTranslatef(-0.5f, 0.5f, 0.0f);
                    gL.glScalef(0.5f, 0.5f, 1.0f);
                    gL.glCallList(this.displayListIDs[7]);
                    gL.glPopMatrix();
                    gL.glBindTexture(3553, this.texHeightOutput);
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    gL.glTranslatef(0.5f, 0.5f, 0.0f);
                    gL.glScalef(0.5f, 0.5f, 1.0f);
                    gL.glCallList(this.displayListIDs[7]);
                    gL.glPopMatrix();
                }
            }
        } else {
            ++this.skipCount;
        }
    }

    public void singleStep() {
        this.singleStep = true;
    }

    public void enableAnimation(boolean bl) {
        this.animate = bl;
    }

    public void enableSlowAnimation(boolean bl) {
        this.slow = bl;
    }

    public void reset() {
        this.reset = true;
    }

    public void setRenderMode(int n) {
        this.renderMode = n;
    }

    public void enableWireframe(boolean bl) {
        this.wireframe = bl;
    }

    public void enableBorderWrapping(boolean bl) {
        this.wrap = bl;
    }

    public void enableBoundaryApplication(boolean bl) {
        this.applyInteriorBoundaries = bl;
    }

    public void enableSpinningLogo(boolean bl) {
        this.spinLogo = bl;
    }

    public void setBlurDistance(float f) {
        this.blurDist = f;
        this.mustUpdateBlurOffsets = true;
    }

    public float getBlurDistance() {
        return this.blurDist;
    }

    public void setBumpScale(float f) {
        this.bumpScale = f;
    }

    public float getBumpScale() {
        return this.bumpScale;
    }

    public void setDropFrequency(float f) {
        this.dropletFrequency = f;
    }

    public float getDropFrequency() {
        return this.dropletFrequency;
    }

    public synchronized void addDroplet(Droplet droplet) {
        this.droplets.add(droplet);
    }

    private void loadInitialTexture(String string) {
        try {
            this.initialMapData = TextureIO.newTextureData((InputStream)this.getClass().getClassLoader().getResourceAsStream(string), (boolean)false, (String)FileUtil.getFileSuffix((String)string));
        }
        catch (IOException iOException) {
            throw new GLException((Throwable)iOException);
        }
        this.initialMapDimensions[0] = this.initialMapData.getWidth();
        this.initialMapDimensions[1] = this.initialMapData.getHeight();
    }

    private void initOpenGL(GL gL) {
        try {
            this.loadTextures(gL, this.tmpSpinFilename, this.tmpDropletFilename, this.tmpCubeMapFilenamePrefix, this.tmpCubeMapFilenameSuffix);
        }
        catch (IOException iOException) {
            throw new GLException((Throwable)iOException);
        }
        this.tmpSpinFilename = null;
        this.tmpDropletFilename = null;
        this.tmpCubeMapFilenamePrefix = null;
        this.tmpCubeMapFilenameSuffix = null;
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(-1.0, 1.0, -1.0, 1.0);
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glDisable(2896);
        gL.glDisable(2929);
        this.createAndWriteUVOffsets(gL, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        this.checkExtension(gL, "GL_ARB_vertex_program");
        this.checkExtension(gL, "GL_ARB_fragment_program");
        this.checkExtension(gL, "GL_ARB_multitexture");
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        this.vertexProgramID = nArray[0];
        gL.glBindProgramARB(34336, this.vertexProgramID);
        String string = "!!ARBvp1.0\n# Constant memory location declarations (must match those in Java sources)\n# CV_UV_OFFSET_TO_USE = 0\n\n# CV_UV_T0_NO_OFFSET  = 1\n# CV_UV_T0_TYPE1      = 2\n# CV_UV_T0_TYPE2      = 3\n# CV_UV_T0_TYPE3      = 4\n# CV_UV_T0_TYPE4      = 5\n\n# CV_UV_T1_NO_OFFSET  = 6\n# CV_UV_T1_TYPE1      = 7\n# CV_UV_T1_TYPE2      = 8\n# CV_UV_T1_TYPE3      = 9\n# CV_UV_T1_TYPE4      = 10\n\n# CV_UV_T2_NO_OFFSET  = 11\n# CV_UV_T2_TYPE1      = 12\n# CV_UV_T2_TYPE2      = 13\n# CV_UV_T2_TYPE3      = 14\n# CV_UV_T2_TYPE4      = 15\n\n# CV_UV_T3_NO_OFFSET  = 16\n# CV_UV_T3_TYPE1      = 17\n# CV_UV_T3_TYPE2      = 18\n# CV_UV_T3_TYPE3      = 19\n# CV_UV_T3_TYPE4      = 20\n\n# CV_CONSTS_1         = 21\n\n# Parameters\nPARAM mvp [4]       = { state.matrix.mvp };     # modelview projection matrix\nPARAM uvOffsetToUse = program.env[0];\nPARAM uvOffsets[20] = { program.env[1..20] };\n\n# Addresses\nADDRESS addr;\n\n# Per vertex inputs\nATTRIB iPos         = vertex.position;          #position\n\n# Outputs\nOUTPUT oPos         = result.position;          #position\n\n# Transform vertex-position to clip-space\nDP4 oPos.x, iPos, mvp[0];\nDP4 oPos.y, iPos, mvp[1];\nDP4 oPos.z, iPos, mvp[2];\nDP4 oPos.w, iPos, mvp[3];\n\n# Read which set of offsets to use\nARL addr.x, uvOffsetToUse.x;\n\n#    c[CV_CONSTS_1] = c[28]\n#    x = 0\n#    y = 0.5\n#    z = 1\n#    w = 2.0f\n\n#    Put a scale factor into r0 so the sample points\n#    can be moved farther from the texel being written\n#    MOV R0, c[28].z;\n\n# Add the offsets to the input texture\n# coordinate, creating 4 sets of independent\n# texture coordinates.\nADD result.texcoord[0], uvOffsets[addr.x     ], vertex.texcoord[0];\nADD result.texcoord[1], uvOffsets[addr.x + 5 ], vertex.texcoord[0];\nADD result.texcoord[2], uvOffsets[addr.x + 10], vertex.texcoord[0];\nADD result.texcoord[3], uvOffsets[addr.x + 15], vertex.texcoord[0];\n\nEND\n";
        float[] fArray = new float[]{0.0f, 0.5f, 1.0f, 2.0f};
        gL.glProgramEnvParameter4fvARB(34336, 21, fArray, 0);
        this.loadProgram(gL, 34336, string);
        this.displayListIDs[0] = gL.glGenLists(1);
        this.initEqWeightCombine_PostMult(gL, this.displayListIDs[0]);
        this.displayListIDs[1] = gL.glGenLists(1);
        this.initNeighborForceCalcStep1(gL, this.displayListIDs[1]);
        this.displayListIDs[2] = gL.glGenLists(1);
        this.initNeighborForceCalcStep2(gL, this.displayListIDs[2]);
        this.displayListIDs[3] = gL.glGenLists(1);
        this.initApplyForce(gL, this.displayListIDs[3]);
        this.displayListIDs[4] = gL.glGenLists(1);
        this.initApplyVelocity(gL, this.displayListIDs[4]);
        this.displayListIDs[5] = gL.glGenLists(1);
        this.initCreateNormalMap(gL, this.displayListIDs[5]);
        this.displayListIDs[6] = gL.glGenLists(1);
        this.initDotProductReflect(gL, this.displayListIDs[6]);
        this.displayListIDs[7] = gL.glGenLists(1);
        gL.glNewList(this.displayListIDs[7], 4864);
        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL.glBegin(5);
        gL.glTexCoord2f(0.0f, 1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glTexCoord2f(0.0f, 0.0f);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glTexCoord2f(1.0f, 1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glTexCoord2f(1.0f, 0.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glEnd();
        gL.glEndList();
    }

    private void checkExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            throw new GLException("Unable to initialize " + string + " OpenGL extension");
        }
    }

    private void doSingleTimeStep(GL gL) {
        int n;
        switch (this.flipState) {
            case 0: {
                this.texHeightInput = this.dynamicTextures[4].getTextureObject();
                this.texHeightOutput = this.dynamicTextures[5].getTextureObject();
                this.texVelocityInput = this.dynamicTextures[2].getTextureObject();
                this.texVelocityOutput = this.dynamicTextures[3].getTextureObject();
                gL.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
                gL.glClear(16384);
                gL.glActiveTexture(33984);
                gL.glBindTexture(3553, this.texVelocityInput);
                gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
                break;
            }
            case 1: {
                int n2 = this.texHeightInput;
                this.texHeightInput = this.texHeightOutput;
                this.texHeightOutput = n2;
                n2 = this.texVelocityInput;
                this.texVelocityInput = this.texVelocityOutput;
                this.texVelocityOutput = n2;
                break;
            }
            case 2: {
                int n2 = this.texHeightInput;
                this.texHeightInput = this.texHeightOutput;
                this.texHeightOutput = n2;
                n2 = this.texVelocityInput;
                this.texVelocityInput = this.texVelocityOutput;
                this.texVelocityOutput = n2;
            }
        }
        gL.glPolygonMode(1032, 6914);
        gL.glCallList(this.displayListIDs[1]);
        for (n = 0; n < 4; ++n) {
            gL.glActiveTexture(33984 + n);
            gL.glBindTexture(3553, this.texHeightInput);
            gL.glEnable(3553);
        }
        n = this.wrap ? 10497 : 33071;
        gL.glTexParameteri(3553, 10242, n);
        gL.glTexParameteri(3553, 10243, n);
        gL.glDisable(3042);
        gL.glProgramEnvParameter4fARB(34336, 0, 1.0f, 0.0f, 0.0f, 0.0f);
        gL.glBindProgramARB(34336, this.vertexProgramID);
        gL.glEnable(34336);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        gL.glActiveTexture(33986);
        this.dynamicTextures[0].bind();
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        gL.glCallList(this.displayListIDs[2]);
        gL.glTexParameterf(3553, 10242, (float)n);
        gL.glTexParameterf(3553, 10243, (float)n);
        gL.glActiveTexture(33987);
        gL.glDisable(3553);
        gL.glProgramEnvParameter4fARB(34336, 0, 2.0f, 0.0f, 0.0f, 0.0f);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        gL.glActiveTexture(33985);
        this.dynamicTextures[1].bind();
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        gL.glCallList(this.displayListIDs[3]);
        gL.glProgramEnvParameter4fARB(34336, 0, 0.0f, 0.0f, 0.0f, 0.0f);
        gL.glActiveTexture(33984);
        gL.glBindTexture(3553, this.texVelocityInput);
        gL.glActiveTexture(33985);
        this.dynamicTextures[1].bind();
        gL.glActiveTexture(33986);
        gL.glDisable(3553);
        gL.glActiveTexture(33987);
        gL.glDisable(3553);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        float f = (float)Math.random();
        if (this.dropletFrequency > f) {
            Droplet droplet = new Droplet(2.0f * ((float)Math.random() - 0.5f), 2.0f * ((float)Math.random() - 0.5f), 0.02f + 0.1f * (float)Math.random());
            this.addDroplet(droplet);
        }
        if (!this.droplets.isEmpty()) {
            this.drawDroplets(gL);
            this.droplets.clear();
        }
        gL.glActiveTexture(33985);
        gL.glBindTexture(3553, this.texVelocityOutput);
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        gL.glCallList(this.displayListIDs[4]);
        gL.glEnable(34336);
        gL.glActiveTexture(33984);
        gL.glBindTexture(3553, this.texHeightInput);
        gL.glActiveTexture(33985);
        gL.glEnable(3553);
        gL.glProgramEnvParameter4fARB(34336, 0, 0.0f, 0.0f, 0.0f, 0.0f);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        gL.glActiveTexture(33984);
        gL.glBindTexture(3553, this.texHeightInput);
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        for (int i = 1; i < 4; ++i) {
            gL.glActiveTexture(33984 + i);
            gL.glBindTexture(3553, this.texHeightInput);
            gL.glEnable(3553);
        }
        gL.glProgramEnvParameter4fARB(34336, 0, 3.0f, 0.0f, 0.0f, 0.0f);
        gL.glCallList(this.displayListIDs[0]);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        if (this.applyInteriorBoundaries) {
            gL.glDisable(34336);
            this.drawInteriorBoundaryObjects(gL);
        }
        gL.glActiveTexture(33984);
        gL.glBindTexture(3553, this.texHeightOutput);
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
        if (this.createNormalMap) {
            this.createNormalMap(gL);
        }
        switch (this.flipState) {
            case 0: {
                this.flipState = 1;
                break;
            }
            case 1: {
                this.flipState = 2;
                break;
            }
            case 2: {
                this.flipState = 1;
            }
        }
    }

    private void createNormalMap(GL gL) {
        for (int i = 0; i < 4; ++i) {
            gL.glActiveTexture(33984 + i);
            gL.glBindTexture(3553, this.texHeightOutput);
            gL.glEnable(3553);
        }
        float[] fArray = new float[]{this.normalSTScale, 0.0f, 0.0f, 0.0f};
        gL.glProgramEnvParameter4fvARB(34820, 0, fArray, 0);
        fArray[0] = 0.0f;
        fArray[1] = this.normalSTScale;
        gL.glProgramEnvParameter4fvARB(34820, 1, fArray, 0);
        gL.glCallList(this.displayListIDs[5]);
        gL.glProgramEnvParameter4fARB(34336, 0, 4.0f, 0.0f, 0.0f, 0.0f);
        gL.glEnable(34336);
        gL.glCallList(this.displayListIDs[7]);
        gL.glDisable(34820);
        gL.glActiveTexture(33984);
        this.dynamicTextures[6].bind();
        gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.initialMapDimensions[0], this.initialMapDimensions[1]);
    }

    private void drawInteriorBoundaryObjects(GL gL) {
        gL.glDisable(34082);
        gL.glActiveTexture(33984);
        this.initialMapTex.bind();
        this.initialMapTex.enable();
        gL.glEnable(3008);
        for (int i = 1; i < 4; ++i) {
            gL.glActiveTexture(33984 + i);
            gL.glDisable(3553);
        }
        gL.glBlendFunc(770, 771);
        gL.glEnable(3042);
        gL.glCallList(this.displayListIDs[7]);
        if (this.spinLogo) {
            gL.glActiveTexture(33984);
            this.spinTex.bind();
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glRotatef((float)this.angle, 0.0f, 0.0f, 1.0f);
            ++this.angle;
            gL.glCallList(this.displayListIDs[7]);
            gL.glPopMatrix();
        }
        gL.glDisable(3008);
        gL.glDisable(3042);
    }

    private void loadTextures(GL gL, String string, String string2, String string3, String string4) throws IOException {
        if (this.initialMapData == null) {
            throw new GLException("Must call loadInitialTexture ahead of time");
        }
        this.initialMapTex = TextureIO.newTexture((TextureData)this.initialMapData);
        this.spinTex = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream(string), (boolean)false, (String)FileUtil.getFileSuffix((String)string));
        this.dropletTex = TextureIO.newTexture((InputStream)this.getClass().getClassLoader().getResourceAsStream(string2), (boolean)false, (String)FileUtil.getFileSuffix((String)string2));
        this.cubemap = Cubemap.loadFromStreams((ClassLoader)this.getClass().getClassLoader(), (String)string3, (String)string4, (boolean)true);
        for (int i = 0; i < 7; ++i) {
            this.dynamicTextures[i] = TextureIO.newTexture((TextureData)this.initialMapData);
        }
        this.initialMapData = null;
        this.texHeightInput = this.initialMapTex.getTextureObject();
        this.texHeightOutput = this.dynamicTextures[5].getTextureObject();
        this.texVelocityInput = this.dynamicTextures[2].getTextureObject();
        this.texVelocityOutput = this.dynamicTextures[3].getTextureObject();
    }

    private void createAndWriteUVOffsets(GL gL, int n, int n2) {
        this.perTexelWidth = 1.0f / (float)n;
        this.perTexelHeight = 1.0f / (float)n2;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float f = 1.5f;
        float[] fArray3 = new float[]{0.0f, -f * this.perTexelWidth, f * this.perTexelWidth, f * this.perTexelWidth};
        float[] fArray4 = new float[]{0.0f, f * this.perTexelHeight, f * this.perTexelHeight, -f * this.perTexelHeight};
        float[] fArray5 = new float[]{0.0f, -f * this.perTexelWidth, 0.0f, 0.0f};
        float[] fArray6 = new float[]{0.0f, -f * this.perTexelHeight, 0.0f, 0.0f};
        this.updateBlurVertOffset(gL);
        float[] fArray7 = new float[]{-this.perTexelWidth, this.perTexelWidth, 0.0f, 0.0f};
        float[] fArray8 = new float[]{0.0f, 0.0f, -this.perTexelHeight, this.perTexelHeight};
        for (int i = 0; i < 4; ++i) {
            float[] fArray9 = new float[]{fArray[i], fArray2[i], 0.0f, 0.0f};
            float[] fArray10 = new float[]{fArray3[i], fArray4[i], 0.0f, 0.0f};
            float[] fArray11 = new float[]{fArray5[i], fArray6[i], 0.0f, 0.0f};
            float[] fArray12 = new float[]{fArray7[i], fArray8[i], 0.0f, 0.0f};
            gL.glProgramEnvParameter4fvARB(34336, 1 + 5 * i, fArray9, 0);
            gL.glProgramEnvParameter4fvARB(34336, 2 + 5 * i, fArray10, 0);
            gL.glProgramEnvParameter4fvARB(34336, 3 + 5 * i, fArray11, 0);
            gL.glProgramEnvParameter4fvARB(34336, 5 + 5 * i, fArray12, 0);
        }
    }

    private void updateBlurVertOffset(GL gL) {
        float[] fArray = new float[]{-this.perTexelWidth * 0.5f, this.perTexelWidth, this.perTexelWidth * 0.5f, -this.perTexelWidth};
        float[] fArray2 = new float[]{this.perTexelHeight, this.perTexelHeight * 0.5f, -this.perTexelHeight, -this.perTexelHeight * 0.5f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        for (int i = 0; i < 4; ++i) {
            fArray3[0] = this.blurDist * fArray[i];
            fArray3[1] = this.blurDist * fArray2[i];
            gL.glProgramEnvParameter4fvARB(34336, 4 + 5 * i, fArray3, 0);
        }
    }

    private synchronized void drawDroplets(GL gL) {
        gL.glDisable(34820);
        gL.glDisable(34336);
        gL.glActiveTexture(33984);
        this.dropletTex.bind();
        this.dropletTex.enable();
        gL.glActiveTexture(33985);
        gL.glDisable(3553);
        gL.glBlendFunc(1, 1);
        gL.glEnable(3042);
        gL.glBegin(7);
        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        Iterator iterator = this.droplets.iterator();
        while (iterator.hasNext()) {
            Droplet droplet = (Droplet)iterator.next();
            gL.glTexCoord2f(0.0f, 0.0f);
            gL.glVertex2f(droplet.rX() - droplet.rScale(), droplet.rY() - droplet.rScale());
            gL.glTexCoord2f(1.0f, 0.0f);
            gL.glVertex2f(droplet.rX() + droplet.rScale(), droplet.rY() - droplet.rScale());
            gL.glTexCoord2f(1.0f, 1.0f);
            gL.glVertex2f(droplet.rX() + droplet.rScale(), droplet.rY() + droplet.rScale());
            gL.glTexCoord2f(0.0f, 1.0f);
            gL.glVertex2f(droplet.rX() - droplet.rScale(), droplet.rY() + droplet.rScale());
        }
        gL.glEnd();
        gL.glDisable(3042);
    }

    private void initEqWeightCombine_PostMult(GL gL, int n) {
        float[] fArray = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM const0  = program.env[0];\nPARAM oneQtr  = { 0.25, 0.25, 0.25, 0.25 };\nPARAM two     = { 2.0, 2.0, 2.0, 2.0 };\nTEMP texSamp0, texSamp1, texSamp2, texSamp3;\nTEMP spare0, spare1;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nTEX texSamp2, fragment.texcoord[2], texture[2], 2D;\nTEX texSamp3, fragment.texcoord[3], texture[3], 2D;\nADD spare0, texSamp0, texSamp1;\nADD spare1, texSamp2, texSamp3;\nADD spare0, spare0, spare1;\nSUB spare0, spare0, two;\nMAD result.color, oneQtr, spare0, const0;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glProgramEnvParameter4fvARB(34820, 0, fArray, 0);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initNeighborForceCalcStep1(GL gL, int n) {
        float[] fArray = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM const0 = program.env[0];\nPARAM three                 = {  3,     3,     3,    1.0 };\nTEMP texSamp0, texSamp1, texSamp2, texSamp3;\nTEMP spare0, spare1;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nTEX texSamp2, fragment.texcoord[2], texture[2], 2D;\nTEX texSamp3, fragment.texcoord[3], texture[3], 2D;\nADD spare0, texSamp1, texSamp2;\nMAD spare1, const0, const0, const0;\nADD spare0, texSamp3, spare0;\nADD spare0, spare1, spare0;\nADD spare1, three, const0;\nMAD result.color, -spare1, texSamp0, spare0;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glProgramEnvParameter4fvARB(34820, 0, fArray, 0);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initNeighborForceCalcStep2(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM const0 = program.env[0];\nTEMP texSamp0, texSamp1, texSamp2;\nTEMP spare0;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nTEX texSamp2, fragment.texcoord[2], texture[2], 2D;\nSUB spare0, texSamp1, texSamp0;\nADD result.color, spare0, texSamp2;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initApplyForce(GL gL, int n) {
        float[] fArray = new float[]{0.25f, 0.25f, 0.25f, 1.0f};
        float[] fArray2 = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM const0 = program.env[0];\nPARAM const1 = program.env[1];\nPARAM one     = { 1.0, 1.0, 1.0, 0.0 };\nPARAM oneHalf = { 0.5, 0.5, 0.5, 1.0 };\nPARAM two     = { 2.0, 2.0, 2.0, 1.0 };\nTEMP texSamp0, texSamp1;\nTEMP spare0, spare1;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nMAD spare0, two, texSamp1, -one;\nMAD spare1, two, texSamp0, -one;\nMAD spare0, spare0, const0, spare1;\nMAD result.color, oneHalf, spare0, const1;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glProgramEnvParameter4fvARB(34820, 0, fArray, 0);
        gL.glProgramEnvParameter4fvARB(34820, 1, fArray2, 0);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initApplyVelocity(GL gL, int n) {
        float[] fArray = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM const0 = program.env[0];\nPARAM one     = { 1.0, 1.0, 1.0, 0.0 };\nPARAM oneHalf = { 0.5, 0.5, 0.5, 1.0 };\nPARAM two     = { 2.0, 2.0, 2.0, 1.0 };\nTEMP texSamp0, texSamp1;\nTEMP spare0, spare1;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nMAD spare0, two, texSamp1, -one;\nMAD spare1, two, texSamp0, -one;\nMAD spare0, spare0, const0, spare1;\nMAD result.color, oneHalf, spare0, const0;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glProgramEnvParameter4fvARB(34820, 0, fArray, 0);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initCreateNormalMap(GL gL, int n) {
        float[] fArray = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM redMask   = program.env[0];\nPARAM greenMask = program.env[1];\nPARAM const0    = { 1.0, 1.0, 0.0, 0.0 };\nPARAM const1    = { 0.5, 0.5, 0.0, 0.0 };\nPARAM const2    = { 0.0, 0.0, 1.0, 1.0 };\nPARAM one     = { 1.0, 1.0, 1.0, 0.0 };\nPARAM oneHalf = { 0.5, 0.5, 0.5, 1.0 };\nPARAM two     = { 2.0, 2.0, 2.0, 1.0 };\nPARAM four    = { 4.0, 4.0, 4.0, 1.0 };\nTEMP texSamp0, texSamp1, texSamp2, texSamp3;\nTEMP spare0, spare1, spare2;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nTEX texSamp1, fragment.texcoord[1], texture[1], 2D;\nTEX texSamp2, fragment.texcoord[2], texture[2], 2D;\nTEX texSamp3, fragment.texcoord[3], texture[3], 2D;\nSUB spare0, texSamp0, texSamp1;\nMUL spare0, spare0, four;\nSUB spare1, texSamp3, texSamp2;\nMUL spare1, spare1, four;\nMUL spare0, spare0, redMask;\nMAD spare0, greenMask, spare1, spare0;\nMUL_SAT spare2, spare0, spare0;\nSUB spare2, one, spare2;\nDP3 spare1, spare2, const0;\nADD spare0, spare0, const1;\nMAD result.color, const2, spare1, spare0;\n\nEND\n";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void initDotProductReflect(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindProgramARB(34820, n2);
        String string = "!!ARBfp1.0\nPARAM minusOne = { -1.0, -1.0, -1.0, 0.0 };\nPARAM two      = {  2.0,  2.0,  2.0, 0.0 };\nTEMP texSamp0, R, N, E;\n\nTEX texSamp0, fragment.texcoord[0], texture[0], 2D;\nMAD texSamp0, two, texSamp0, minusOne;\nDP3 N.x,   texSamp0, fragment.texcoord[1];\nDP3 N.y,   texSamp0, fragment.texcoord[2];\nDP3 N.z,   texSamp0, fragment.texcoord[3];\nMOV E.x, fragment.texcoord[1].w;\nMOV E.y, fragment.texcoord[2].w;\nMOV E.z, fragment.texcoord[3].w;\nMUL N, N, two;\nSUB R, N, E;\nTEX result.color, R, texture[3], CUBE;\n\nEND";
        this.loadProgram(gL, 34820, string);
        gL.glNewList(n, 4864);
        gL.glBindProgramARB(34820, n2);
        gL.glEnable(34820);
        gL.glEndList();
    }

    private void loadProgram(GL gL, int n, String string) {
        gL.glProgramStringARB(n, 34933, string.length(), string);
        int[] nArray = new int[1];
        gL.glGetIntegerv(34379, nArray, 0);
        if (nArray[0] >= 0) {
            int n2;
            String string2 = "Program";
            if (n == 34336) {
                string2 = "Vertex program";
            } else if (n == 34820) {
                string2 = "Fragment program";
            }
            System.out.println(string2 + " failed to load:");
            String string3 = gL.glGetString(34932);
            if (string3 == null) {
                System.out.println("[No error message available]");
            } else {
                System.out.println("Error message: \"" + string3 + "\"");
            }
            System.out.println("Error occurred at position " + nArray[0] + " in program:");
            for (n2 = nArray[0]; n2 < string.length() && string.charAt(n2) != '\n'; ++n2) {
            }
            System.out.println(string.substring(nArray[0], n2));
            throw new GLException("Error loading " + string2);
        }
        if (n == 34820) {
            int[] nArray2 = new int[1];
            gL.glGetProgramivARB(34820, 34998, nArray2, 0);
            if (nArray2[0] != 1) {
                System.out.println("WARNING: fragment program is over native resource limits");
                Thread.dumpStack();
            }
        }
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            Water.this.initOpenGL(gL);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            if (Water.this.mustUpdateBlurOffsets) {
                Water.this.updateBlurVertOffset(gL);
                Water.this.mustUpdateBlurOffsets = false;
            }
            gL.glDisable(2884);
            if (Water.this.reset) {
                Water.this.reset = false;
                Water.this.flipState = 0;
            }
            if (Water.this.animate) {
                Water.this.doSingleTimeStep(gL);
            } else if (Water.this.singleStep) {
                Water.this.doSingleTimeStep(gL);
                Water.this.singleStep = false;
            }
            gL.glFlush();
            if (Water.this.slow && Water.this.slowDelay > 0) {
                try {
                    Thread.sleep(Water.this.slowDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    public static class Droplet {
        private float rX;
        private float rY;
        private float rScale;

        Droplet(float f, float f2, float f3) {
            this.rX = f;
            this.rY = f2;
            this.rScale = f3;
        }

        float rX() {
            return this.rX;
        }

        float rY() {
            return this.rY;
        }

        float rScale() {
            return this.rScale;
        }
    }
}

