/*
 * Decompiled with CFR 0.152.
 */
package demos.tess;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

public class Tess {
    public static void main(String[] stringArray) {
        try {
            Frame frame = new Frame("Tess Demo");
            frame.setSize(500, 500);
            GLCanvas gLCanvas = new GLCanvas();
            frame.add((Component)gLCanvas);
            gLCanvas.addGLEventListener((GLEventListener)new TessRenderer());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            System.exit(0);
                        }
                    }).start();
                }
            });
            frame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class TessCallback
    extends GLUtessellatorCallbackAdapter {
        GL gl;
        GLU glu;

        public TessCallback(GL gL, GLU gLU) {
            this.gl = gL;
            this.glu = gLU;
        }

        public void begin(int n) {
            this.gl.glBegin(n);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object object) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                if (dArray.length == 6) {
                    this.gl.glColor3dv(dArray, 3);
                }
                this.gl.glVertex3dv(dArray, 0);
            }
        }

        public void error(int n) {
            String string = this.glu.gluErrorString(n);
            System.out.println("Tessellation Error: " + string);
            throw new RuntimeException();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[6];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            for (int i = 3; i < 6; ++i) {
                dArray2[i] = (double)fArray[0] * ((double[])objectArray[0])[i] + (double)fArray[1] * ((double[])objectArray[1])[i] + (double)fArray[2] * ((double[])objectArray[2])[i] + (double)fArray[3] * ((double[])objectArray[3])[i];
            }
            objectArray2[0] = dArray2;
        }
    }

    public static class TessRenderer
    implements GLEventListener {
        private GL gl;
        private GLU glu = new GLU();
        private int startList;

        public void init(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.setGL((GL)new DebugGL(gLAutoDrawable.getGL()));
            this.gl = gLAutoDrawable.getGL();
            double[][] dArrayArray = new double[][]{{50.0, 50.0, 0.0}, {200.0, 50.0, 0.0}, {200.0, 200.0, 0.0}, {50.0, 200.0, 0.0}};
            double[][] dArrayArray2 = new double[][]{{75.0, 75.0, 0.0}, {125.0, 175.0, 0.0}, {175.0, 75.0, 0.0}};
            double[][] dArrayArray3 = new double[][]{{250.0, 50.0, 0.0, 1.0, 0.0, 1.0}, {325.0, 200.0, 0.0, 1.0, 1.0, 0.0}, {400.0, 50.0, 0.0, 0.0, 1.0, 1.0}, {250.0, 150.0, 0.0, 1.0, 0.0, 0.0}, {400.0, 150.0, 0.0, 0.0, 1.0, 0.0}};
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.startList = this.gl.glGenLists(2);
            GLUtessellator gLUtessellator = this.glu.gluNewTess();
            TessCallback tessCallback = new TessCallback(this.gl, this.glu);
            this.glu.gluTessCallback(gLUtessellator, 100101, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100100, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100102, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100103, (GLUtessellatorCallback)tessCallback);
            this.gl.glNewList(this.startList, 4864);
            this.gl.glShadeModel(7424);
            this.glu.gluTessBeginPolygon(gLUtessellator, null);
            this.glu.gluTessBeginContour(gLUtessellator);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray[0], 0, (Object)dArrayArray[0]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray[1], 0, (Object)dArrayArray[1]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray[2], 0, (Object)dArrayArray[2]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray[3], 0, (Object)dArrayArray[3]);
            this.glu.gluTessEndContour(gLUtessellator);
            this.glu.gluTessBeginContour(gLUtessellator);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray2[0], 0, (Object)dArrayArray2[0]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray2[1], 0, (Object)dArrayArray2[1]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray2[2], 0, (Object)dArrayArray2[2]);
            this.glu.gluTessEndContour(gLUtessellator);
            this.glu.gluTessEndPolygon(gLUtessellator);
            this.gl.glEndList();
            this.glu.gluTessCallback(gLUtessellator, 100101, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100100, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100102, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100103, (GLUtessellatorCallback)tessCallback);
            this.glu.gluTessCallback(gLUtessellator, 100105, (GLUtessellatorCallback)tessCallback);
            this.gl.glNewList(this.startList + 1, 4864);
            this.gl.glShadeModel(7425);
            this.glu.gluTessProperty(gLUtessellator, 100140, 100132.0);
            this.glu.gluTessBeginPolygon(gLUtessellator, null);
            this.glu.gluTessBeginContour(gLUtessellator);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray3[0], 0, (Object)dArrayArray3[0]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray3[1], 0, (Object)dArrayArray3[1]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray3[2], 0, (Object)dArrayArray3[2]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray3[3], 0, (Object)dArrayArray3[3]);
            this.glu.gluTessVertex(gLUtessellator, dArrayArray3[4], 0, (Object)dArrayArray3[4]);
            this.glu.gluTessEndContour(gLUtessellator);
            this.glu.gluTessEndPolygon(gLUtessellator);
            this.gl.glEndList();
            this.glu.gluDeleteTess(gLUtessellator);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glOrtho(0.0, 450.0, 0.0, 250.0, -1.0, 1.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            this.gl.glClear(16384);
            this.gl.glColor3d(1.0, 1.0, 1.0);
            this.gl.glCallList(this.startList);
            this.gl.glCallList(this.startList + 1);
            this.gl.glFlush();
        }
    }
}

