/*
 * Decompiled with CFR 0.152.
 */
package demos.testContextSharing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Random;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

public class TestContextSharing {
    private int gearDisplayList;
    private Frame delayedFrame;

    public static void main(String[] stringArray) {
        new TestContextSharing().run(stringArray);
    }

    public void run(String[] stringArray) {
        Frame frame;
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)new Listener());
        gLCanvas.setSize(256, 256);
        Frame frame2 = new Frame("Canvas 1");
        frame2.setLayout(new BorderLayout());
        frame2.add((Component)gLCanvas, "Center");
        GLCanvas gLCanvas2 = new GLCanvas(null, null, gLCanvas.getContext(), null);
        gLCanvas2.addGLEventListener((GLEventListener)new Listener());
        gLCanvas2.setSize(256, 256);
        Frame frame3 = new Frame("Canvas 2");
        frame3.setLayout(new BorderLayout());
        frame3.add((Component)gLCanvas2, "Center");
        Random random = new Random(System.currentTimeMillis());
        if (random.nextBoolean()) {
            frame = frame2;
            this.delayedFrame = frame3;
        } else {
            frame = frame3;
            this.delayedFrame = frame2;
        }
        System.err.println("Showing first frame");
        frame.pack();
        frame.show();
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("Showing other frame");
                TestContextSharing.this.delayedFrame.pack();
                TestContextSharing.this.delayedFrame.show();
                TestContextSharing.this.delayedFrame.setLocation(256, 0);
            }
        }).start();
    }

    private synchronized void initializeDisplayList(GL gL) {
        if (this.gearDisplayList != 0) {
            return;
        }
        this.gearDisplayList = gL.glGenLists(1);
        gL.glNewList(this.gearDisplayList, 4864);
        float[] fArray = new float[]{0.8f, 0.1f, 0.0f, 1.0f};
        gL.glMaterialfv(1028, 5634, fArray, 0);
        this.gear(gL, 1.0f, 4.0f, 1.0f, 20, 0.7f);
        gL.glEndList();
    }

    private void gear(GL gL, float f, float f2, float f3, int n, float f4) {
        float f5;
        int n2;
        float f6 = f;
        float f7 = f2 - f4 / 2.0f;
        float f8 = f2 + f4 / 2.0f;
        float f9 = (float)Math.PI * 2 / (float)n / 4.0f;
        gL.glShadeModel(7424);
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            if (n2 >= n) continue;
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL.glEnd();
        gL.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL.glEnd();
        gL.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL.glEnd();
        gL.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL.glEnd();
        gL.glBegin(8);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            float f10 = f8 * (float)Math.cos(f5 + f9) - f7 * (float)Math.cos(f5);
            float f11 = f8 * (float)Math.sin(f5 + f9) - f7 * (float)Math.sin(f5);
            float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            gL.glNormal3f(f11 /= f12, -(f10 /= f12), 0.0f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            f10 = f7 * (float)Math.cos(f5 + 3.0f * f9) - f8 * (float)Math.cos(f5 + 2.0f * f9);
            f11 = f7 * (float)Math.sin(f5 + 3.0f * f9) - f8 * (float)Math.sin(f5 + 2.0f * f9);
            gL.glNormal3f(f11, -f10, 0.0f);
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
            gL.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
        }
        gL.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), f3 * 0.5f);
        gL.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), -f3 * 0.5f);
        gL.glEnd();
        gL.glShadeModel(7425);
        gL.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL.glNormal3f(-((float)Math.cos(f5)), -((float)Math.sin(f5)), 0.0f);
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
        }
        gL.glEnd();
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.setGL((GL)new DebugGL(gLAutoDrawable.getGL()));
            GL gL = gLAutoDrawable.getGL();
            float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
            gL.glLightfv(16384, 4611, fArray, 0);
            gL.glEnable(2884);
            gL.glEnable(2896);
            gL.glEnable(16384);
            gL.glEnable(2929);
            TestContextSharing.this.initializeDisplayList(gL);
            gL.glEnable(2977);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            System.err.println("Drawing display list " + TestContextSharing.this.gearDisplayList);
            gL.glCallList(TestContextSharing.this.gearDisplayList);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL gL = gLAutoDrawable.getGL();
            float f = (float)n4 / (float)n3;
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            gL.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 5.0, 60.0);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            gL.glTranslatef(0.0f, 0.0f, -40.0f);
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

