/*
 * Decompiled with CFR 0.152.
 */
package demos.texture;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class TestTexture
implements GLEventListener {
    private File curDir;
    private boolean newTexture;
    private boolean flushTexture;
    private File file;
    private Texture texture;
    private GLU glu = new GLU();

    public static void main(String[] stringArray) {
        new TestTexture().run(stringArray);
    }

    private void run(String[] stringArray) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame jFrame = new JFrame("Texture Loader Demo");
        jFrame.setDefaultCloseOperation(3);
        final GLCanvas gLCanvas = new GLCanvas();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open texture...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser(TestTexture.this.curDir);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    TestTexture.this.curDir = file.getParentFile();
                    TestTexture.this.setTextureFile(file);
                    gLCanvas.repaint();
                }
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Flush texture");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestTexture.this.flushTexture();
                gLCanvas.repaint();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        gLCanvas.addGLEventListener((GLEventListener)this);
        jFrame.getContentPane().add((Component)gLCanvas);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setSize(800, 600);
        jFrame.show();
    }

    public void setTextureFile(File file) {
        this.file = file;
        this.newTexture = true;
    }

    public void flushTexture() {
        this.flushTexture = true;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.setGL((GL)new DebugGL(gLAutoDrawable.getGL()));
        GL gL = gLAutoDrawable.getGL();
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glEnable(2929);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16640);
        if (this.flushTexture) {
            this.flushTexture = false;
            if (this.texture != null) {
                this.texture.dispose();
                this.texture = null;
            }
        }
        if (this.newTexture) {
            this.newTexture = false;
            if (this.texture != null) {
                this.texture.dispose();
                this.texture = null;
            }
            try {
                System.err.println("Loading texture...");
                this.texture = TextureIO.newTexture((File)this.file, (boolean)true);
                System.err.println("Texture estimated memory size = " + this.texture.getEstimatedMemorySize());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
                JOptionPane.showMessageDialog(null, byteArrayOutputStream.toString(), "Error loading texture", 0);
                return;
            }
        }
        if (this.texture != null) {
            this.texture.enable();
            this.texture.bind();
            gL.glTexEnvi(8960, 8704, 7681);
            TextureCoords textureCoords = this.texture.getImageTexCoords();
            gL.glBegin(7);
            gL.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL.glVertex3f(0.0f, 0.0f, 0.0f);
            gL.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL.glVertex3f(1.0f, 0.0f, 0.0f);
            gL.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL.glVertex3f(1.0f, 1.0f, 0.0f);
            gL.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL.glVertex3f(0.0f, 1.0f, 0.0f);
            gL.glEnd();
            this.texture.disable();
        }
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

