/*
 * Decompiled with CFR 0.152.
 */
package demos.texture;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLPbuffer;

public class TextureConvert {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.out.println("Usage: java demos.texture.TextureConvert [input file] [output file]");
            System.out.println("Converts texture from input file format to output file format.");
            System.out.println("If output file format is DDS, compresses texture with DXT3 compression");
            System.out.println("if available.");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            System.out.println("Pbuffer support not available (required to run this demo)");
            System.exit(1);
        }
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(false);
        GLPbuffer gLPbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, 2, 2, null);
        gLPbuffer.getContext().makeCurrent();
        GL gL = gLPbuffer.getGL();
        boolean bl = false;
        if ("dds".equals(FileUtil.getFileSuffix((String)string2)) && (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc"))) {
            bl = true;
        }
        TextureData textureData = TextureIO.newTextureData((File)new File(string), (boolean)false, null);
        if (bl && !textureData.isDataCompressed()) {
            textureData.setInternalFormat(33778);
        }
        Texture texture = TextureIO.newTexture((TextureData)textureData);
        TextureIO.write((Texture)texture, (File)new File(string2));
    }
}

