/*
 * Decompiled with CFR 0.152.
 */
package demos.vertexArrayRange;

import com.sun.opengl.util.Animator;
import demos.common.Demo;
import demos.common.DemoListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

public class VertexArrayRange
extends Demo {
    private GLU glu = new GLU();
    private boolean[] b = new boolean[256];
    private static final int SIZEOF_FLOAT = 4;
    private static final int STRIP_SIZE = 48;
    private int tileSize = 432;
    private int numBuffers = 4;
    private int bufferLength = 1000000;
    private int bufferSize = this.bufferLength * 4;
    private static final int SIN_ARRAY_SIZE = 1024;
    private FloatBuffer bigArrayVar;
    private FloatBuffer bigArraySystem;
    private FloatBuffer bigArray;
    private IntBuffer[] elements;
    private float[] xyArray;
    private VarBuffer[] buffers;
    private float[] sinArray;
    private float[] cosArray;
    private int primitive = 8;
    private float hicoef = 0.06f;
    private float locoef = 0.1f;
    private float hifreq = 6.1f;
    private float lofreq = 2.5f;
    private float phaseRate = 0.02f;
    private float phase2Rate = -0.12f;
    private float phase = 0.0f;
    private float phase2 = 0.0f;
    float[] ysinlo = new float[48];
    float[] ycoslo = new float[48];
    float[] ysinhi = new float[48];
    float[] ycoshi = new float[48];
    private volatile boolean toggleVAR = false;
    private volatile boolean toggleLighting = false;
    private volatile boolean toggleLightingModel = false;
    private volatile boolean recomputeElements = false;
    private boolean firstProfiledFrame;
    private int profiledFrameCount;
    private int numDrawElementsCalls;
    private long startTimeMillis;

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 1) {
            VertexArrayRange.usage();
        }
        if (stringArray.length == 1) {
            if (stringArray[0].equals("-slow")) {
                bl = true;
            } else {
                VertexArrayRange.usage();
            }
        }
        GLCanvas gLCanvas = new GLCanvas();
        VertexArrayRange vertexArrayRange = new VertexArrayRange();
        if (bl) {
            vertexArrayRange.setFlag('v', false);
        }
        gLCanvas.addGLEventListener((GLEventListener)vertexArrayRange);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setRunAsFastAsPossible(true);
        vertexArrayRange.setDemoListener(new DemoListener(){

            public void shutdownDemo() {
                VertexArrayRange.runExit(animator);
            }

            public void repaint() {
            }
        });
        Frame frame = new Frame("Very Simple NV_vertex_array_range demo");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VertexArrayRange.runExit(animator);
            }
        });
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(800, 800);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.show();
        gLCanvas.requestFocus();
        animator.start();
    }

    private static void usage() {
        System.out.println("usage: java VertexArrayRange [-slow]");
        System.out.println("-slow flag starts up using data in the Java heap");
        System.exit(0);
    }

    public VertexArrayRange() {
        this.setFlag(' ', true);
        this.setFlag('i', true);
        this.setFlag('v', true);
    }

    private void setFlag(char c, boolean bl) {
        this.b[c & 0xFF] = bl;
    }

    private boolean getFlag(char c) {
        return this.b[c & 0xFF];
    }

    private void ensurePresent(GL gL, String string) {
        if (!gL.isFunctionAvailable(string)) {
            final String string2 = "OpenGL routine \"" + string + "\" not available";
            new Thread(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
                    VertexArrayRange.this.shutdownDemo();
                }
            }).start();
            throw new RuntimeException(string2);
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(0);
        try {
            this.ensurePresent(gL, "glVertexArrayRangeNV");
            this.ensurePresent(gL, "glGenFencesNV");
            this.ensurePresent(gL, "glSetFenceNV");
            this.ensurePresent(gL, "glTestFenceNV");
            this.ensurePresent(gL, "glFinishFenceNV");
            this.ensurePresent(gL, "glAllocateMemoryNV");
        }
        catch (RuntimeException runtimeException) {
            this.shutdownDemo();
            throw runtimeException;
        }
        gL.glEnable(2929);
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glEnable(16384);
        gL.glEnable(2896);
        gL.glEnable(2977);
        gL.glMaterialfv(1032, 4608, new float[]{0.1f, 0.1f, 0.0f, 1.0f}, 0);
        gL.glMaterialfv(1032, 4609, new float[]{0.6f, 0.6f, 0.1f, 1.0f}, 0);
        gL.glMaterialfv(1032, 4610, new float[]{1.0f, 1.0f, 0.75f, 1.0f}, 0);
        gL.glMaterialf(1032, 5633, 128.0f);
        gL.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, 0.5f, 0.0f}, 0);
        gL.glLightModeli(2897, 0);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        this.glu.gluPerspective(60.0, 1.0, 0.1, 100.0);
        gL.glMatrixMode(5888);
        this.allocateBigArray(gL, true);
        this.allocateBuffersAndFences(gL);
        this.sinArray = new float[1024];
        this.cosArray = new float[1024];
        for (int i = 0; i < 1024; ++i) {
            double d = (double)(i * 2) * Math.PI / 1024.0;
            this.sinArray[i] = (float)Math.sin(d);
            this.cosArray[i] = (float)Math.cos(d);
        }
        if (this.getFlag('v')) {
            gL.glEnableClientState(34077);
            gL.glVertexArrayRangeNV(this.bufferSize, (Buffer)this.bigArrayVar);
            this.bigArray = this.bigArrayVar;
        } else {
            this.bigArray = this.bigArraySystem;
        }
        this.setupBuffers();
        gL.glEnableClientState(32884);
        gL.glEnableClientState(32885);
        this.computeElements();
        gLAutoDrawable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                VertexArrayRange.this.dispatchKey(keyEvent.getKeyChar());
            }
        });
    }

    private void allocateBuffersAndFences(GL gL) {
        this.buffers = new VarBuffer[this.numBuffers];
        int[] nArray = new int[1];
        for (int i = 0; i < this.numBuffers; ++i) {
            this.buffers[i] = new VarBuffer();
            gL.glGenFencesNV(1, nArray, 0);
            this.buffers[i].fence = nArray[0];
        }
    }

    private void setupBuffers() {
        int n = this.bufferLength / this.numBuffers;
        for (int i = 0; i < this.numBuffers; ++i) {
            int n2 = i * n;
            this.buffers[i].vertices = this.sliceBuffer(this.bigArray, n2, n);
            this.buffers[i].normals = this.sliceBuffer(this.buffers[i].vertices, 3, this.buffers[i].vertices.limit() - 3);
        }
    }

    private void dispatchKey(char c) {
        this.setFlag(c, !this.getFlag(c));
        if (c == '\u001b' || c == 'q') {
            this.shutdownDemo();
            return;
        }
        if (c == 'r' && this.getFlag(c)) {
            this.profiledFrameCount = 0;
            this.numDrawElementsCalls = 0;
            this.firstProfiledFrame = true;
        }
        if (c == 'w') {
            this.primitive = this.getFlag(c) ? 3 : 8;
        }
        if (c == 'p') {
            this.primitive = this.getFlag(c) ? 0 : 8;
        }
        if (c == 'v') {
            this.toggleVAR = true;
        }
        if (c == 'd') {
            this.toggleLighting = true;
        }
        if (c == 'i') {
            this.toggleLightingModel = true;
        }
        if ('h' == c) {
            this.hicoef = (float)((double)this.hicoef + 0.005);
        }
        if ('H' == c) {
            this.hicoef = (float)((double)this.hicoef - 0.005);
        }
        if ('l' == c) {
            this.locoef = (float)((double)this.locoef + 0.005);
        }
        if ('L' == c) {
            this.locoef = (float)((double)this.locoef - 0.005);
        }
        if ('1' == c) {
            this.lofreq += 0.1f;
        }
        if ('2' == c) {
            this.lofreq -= 0.1f;
        }
        if ('3' == c) {
            this.hifreq += 0.1f;
        }
        if ('4' == c) {
            this.hifreq -= 0.1f;
        }
        if ('5' == c) {
            this.phaseRate += 0.01f;
        }
        if ('6' == c) {
            this.phaseRate -= 0.01f;
        }
        if ('7' == c) {
            this.phase2Rate += 0.01f;
        }
        if ('8' == c) {
            this.phase2Rate -= 0.01f;
        }
        if ('t' == c && this.tileSize < 864) {
            this.tileSize += 48;
            this.recomputeElements = true;
            System.err.println("tileSize = " + this.tileSize);
        }
        if ('T' == c && this.tileSize > 48) {
            this.tileSize -= 48;
            this.recomputeElements = true;
            System.err.println("tileSize = " + this.tileSize);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        int n;
        GL gL = gLAutoDrawable.getGL();
        if (this.getFlag(' ')) {
            this.phase += this.phaseRate;
            this.phase2 += this.phase2Rate;
            if (this.phase > 62.831852f) {
                this.phase = 0.0f;
            }
            if (this.phase2 < -62.831852f) {
                this.phase2 = 0.0f;
            }
        }
        PeriodicIterator periodicIterator = new PeriodicIterator(1024, (float)Math.PI * 2, this.phase, (float)((double)(1.0f / (float)this.tileSize * this.lofreq) * Math.PI));
        PeriodicIterator periodicIterator2 = new PeriodicIterator(periodicIterator);
        PeriodicIterator periodicIterator3 = new PeriodicIterator(1024, (float)Math.PI * 2, this.phase2, (float)((double)(1.0f / (float)this.tileSize * this.hifreq) * Math.PI));
        PeriodicIterator periodicIterator4 = new PeriodicIterator(periodicIterator3);
        if (this.toggleVAR) {
            if (this.getFlag('v')) {
                gL.glEnableClientState(34077);
                gL.glVertexArrayRangeNV(this.bufferSize, (Buffer)this.bigArrayVar);
                this.bigArray = this.bigArrayVar;
            } else {
                gL.glDisableClientState(34077);
                this.bigArray = this.bigArraySystem;
            }
            this.toggleVAR = false;
            this.setupBuffers();
        }
        if (this.toggleLighting) {
            if (this.getFlag('d')) {
                gL.glDisable(2896);
            } else {
                gL.glEnable(2896);
            }
            this.toggleLighting = false;
        }
        if (this.toggleLightingModel) {
            if (this.getFlag('i')) {
                gL.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, 0.5f, 0.0f}, 0);
                gL.glLightModeli(2897, 0);
            } else {
                gL.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, -0.5f, 1.0f}, 0);
                gL.glLightModeli(2897, 1);
            }
            this.toggleLightingModel = false;
        }
        if (this.recomputeElements) {
            this.computeElements();
            this.recomputeElements = false;
        }
        gL.glClear(16640);
        gL.glPushMatrix();
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
        gL.glLoadMatrixf(fArray, 0);
        int n2 = 0;
        int n3 = n = this.tileSize / 48;
        while (--n3 >= 0) {
            n2 = n3 % this.numBuffers;
            if (n3 >= this.numBuffers && !gL.glTestFenceNV(this.buffers[n2].fence)) {
                gL.glFinishFenceNV(this.buffers[n2].fence);
            }
            FloatBuffer floatBuffer = this.buffers[n2].vertices;
            int n4 = 0;
            gL.glVertexPointer(3, 5126, 24, (Buffer)floatBuffer);
            gL.glNormalPointer(5126, 24, (Buffer)this.buffers[n2].normals);
            int n5 = 48;
            while (--n5 >= 0) {
                this.ysinlo[n5] = this.sinArray[periodicIterator2.getIndex()];
                this.ycoslo[n5] = this.cosArray[periodicIterator2.getIndex()];
                periodicIterator2.incr();
                this.ysinhi[n5] = this.sinArray[periodicIterator4.getIndex()];
                this.ycoshi[n5] = this.cosArray[periodicIterator4.getIndex()];
                periodicIterator4.incr();
            }
            periodicIterator2.decr();
            periodicIterator4.decr();
            n5 = this.tileSize;
            while (--n5 >= 0) {
                float f = this.xyArray[n5];
                int n6 = periodicIterator.getIndex();
                int n7 = periodicIterator3.getIndex();
                int n8 = 47 * n3;
                float f2 = this.locoef * -this.cosArray[n6] + this.hicoef * -this.cosArray[n7];
                float f3 = this.locoef;
                float f4 = this.hicoef;
                float[] fArray2 = this.ysinlo;
                float[] fArray3 = this.ysinhi;
                float[] fArray4 = this.ycoslo;
                float[] fArray5 = this.ycoshi;
                float[] fArray6 = this.sinArray;
                float[] fArray7 = this.xyArray;
                int n9 = 48;
                while (--n9 >= 0) {
                    float f5 = fArray7[n9 + n8];
                    floatBuffer.put(n4, f);
                    floatBuffer.put(n4 + 1, f5);
                    floatBuffer.put(n4 + 2, f3 * (fArray6[n6] + fArray2[n9]) + f4 * (fArray6[n7] + fArray3[n9]));
                    floatBuffer.put(n4 + 3, f2);
                    float f6 = f3 * -fArray4[n9] + f4 * -fArray5[n9];
                    floatBuffer.put(n4 + 4, f6);
                    floatBuffer.put(n4 + 5, 0.15f);
                    n4 += 6;
                }
                periodicIterator.incr();
                periodicIterator3.incr();
            }
            periodicIterator.reset();
            periodicIterator3.reset();
            for (n5 = 0; n5 < this.elements.length; ++n5) {
                ++this.numDrawElementsCalls;
                gL.glDrawElements(this.primitive, this.elements[n5].capacity(), 5125, (Buffer)this.elements[n5]);
                if (!this.getFlag('f')) continue;
                gL.glFlush();
            }
            gL.glSetFenceNV(this.buffers[n2].fence, 34034);
        }
        gL.glPopMatrix();
        gL.glFinishFenceNV(this.buffers[n2].fence);
        if (this.getFlag('r')) {
            if (!this.firstProfiledFrame) {
                if (++this.profiledFrameCount == 30) {
                    long l = System.currentTimeMillis();
                    double d = (double)(l - this.startTimeMillis) / 1000.0;
                    double d2 = 30.0 / d;
                    double d3 = this.tileSize * this.tileSize * 2;
                    double d4 = d3 * d2 / 1000000.0;
                    System.err.println("fps: " + d2 + " polys/frame: " + d3 + " million polys/sec: " + d4 + " DrawElements calls/frame: " + this.numDrawElementsCalls / 30);
                    this.profiledFrameCount = 0;
                    this.numDrawElementsCalls = 0;
                    this.startTimeMillis = System.currentTimeMillis();
                }
            } else {
                this.startTimeMillis = System.currentTimeMillis();
                this.firstProfiledFrame = false;
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void allocateBigArray(GL gL, boolean bl) {
        float f = 0.5f;
        this.bigArraySystem = this.setupBuffer(ByteBuffer.allocateDirect(this.bufferSize));
        float f2 = (float)this.bufferSize / 1000000.0f;
        try {
            this.bigArrayVar = this.setupBuffer(gL.glAllocateMemoryNV(this.bufferSize, 0.0f, 0.0f, f));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                this.bigArrayVar = this.setupBuffer(gL.glAllocateMemoryNV(this.bufferSize, 0.0f, 0.0f, 1.0f));
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                if (!bl) {
                    throw new RuntimeException("Unable to allocate " + f2 + " megabytes of fast memory. Giving up.");
                }
                System.err.println("Unable to allocate " + f2 + " megabytes of fast memory. Trying less.");
                this.bufferSize /= 2;
                this.numBuffers /= 2;
                this.allocateBigArray(gL, false);
                return;
            }
        }
        System.err.println("Allocated " + f2 + " megabytes of fast memory");
    }

    private FloatBuffer setupBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asFloatBuffer();
    }

    private FloatBuffer sliceBuffer(FloatBuffer floatBuffer, int n, int n2) {
        floatBuffer.position(n);
        FloatBuffer floatBuffer2 = floatBuffer.slice();
        floatBuffer.position(0);
        floatBuffer2.limit(n2);
        return floatBuffer2;
    }

    private void computeElements() {
        int n;
        this.xyArray = new float[this.tileSize];
        for (n = 0; n < this.tileSize; ++n) {
            this.xyArray[n] = (float)n / ((float)this.tileSize - 1.0f) - 0.5f;
        }
        this.elements = new IntBuffer[this.tileSize - 1];
        for (n = 0; n < this.tileSize - 1; ++n) {
            this.elements[n] = IntBuffer.allocate(96);
            for (int i = 0; i < 96; i += 2) {
                this.elements[n].put(i, n * 48 + i / 2);
                this.elements[n].put(i + 1, (n + 1) * 48 + i / 2);
            }
        }
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }

    static class PeriodicIterator {
        private int arraySizeMask;
        private int increment;
        private int initOffset;
        private int index;

        public PeriodicIterator(int n, float f, float f2, float f3) {
            float f4 = (float)n * (f3 / f);
            this.increment = (int)(f4 * 65536.0f);
            float f5 = (float)n * (f2 / f);
            this.initOffset = (int)(f5 * 65536.0f);
            this.arraySizeMask = 0;
            int n2 = 20;
            while ((n & 1 << n2) == 0) {
                --n2;
            }
            this.arraySizeMask = (1 << n2) - 1;
            this.index = this.initOffset;
        }

        public PeriodicIterator(PeriodicIterator periodicIterator) {
            this.arraySizeMask = periodicIterator.arraySizeMask;
            this.increment = periodicIterator.increment;
            this.initOffset = periodicIterator.initOffset;
            this.index = periodicIterator.index;
        }

        public int getIndex() {
            return this.index >> 16 & this.arraySizeMask;
        }

        public void incr() {
            this.index += this.increment;
        }

        public void decr() {
            this.index -= this.increment;
        }

        public void reset() {
            this.index = this.initOffset;
        }
    }

    static class VarBuffer {
        public FloatBuffer vertices;
        public FloatBuffer normals;
        public int fence;

        VarBuffer() {
        }
    }
}

