/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.Java2D;
import demos.xtrans.OffscreenComponentWrapper;
import demos.xtrans.OffscreenDesktopPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class OffscreenDesktopManager
implements DesktopManager {
    protected static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    protected VolatileImage offscreenBackBuffer;
    public static final int STATE_CLEAN = 0;
    public static final int STATE_COPY_BACK = 1;
    public static final int STATE_REDRAW = 2;
    public static final int STATE_RELAYOUT = 3;
    protected int dirtyState = 3;
    protected Map componentPositionsOnBackBuffer = new WeakHashMap();
    private static final boolean DEBUG = Debug.debug((String)"OffscreenDesktopManager");
    private static final boolean VERBOSE = Debug.verbose();
    private JFrame debuggingFrame;
    private JPanel debuggingPanel;

    public OffscreenDesktopManager() {
        if (DEBUG) {
            this.debuggingFrame = new JFrame("Debugging frame");
            this.debuggingPanel = new JPanel(){

                public void paintComponent(Graphics graphics) {
                    if (OffscreenDesktopManager.this.offscreenBackBuffer != null) {
                        graphics.drawImage(OffscreenDesktopManager.this.offscreenBackBuffer, 0, 0, null);
                    }
                }
            };
            this.debuggingPanel.setDoubleBuffered(false);
            this.debuggingFrame.getContentPane().add(this.debuggingPanel);
            this.debuggingFrame.pack();
            this.debuggingFrame.setLocation(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth() / 2, 0);
            this.debuggingFrame.setSize(256, 256);
            this.debuggingFrame.setVisible(true);
        }
    }

    public void setNeedsCopyBack() {
        this.dirtyState = Math.max(this.dirtyState, 1);
    }

    public void setNeedsRedraw() {
        this.dirtyState = Math.max(this.dirtyState, 2);
    }

    public void setNeedsReLayout() {
        this.dirtyState = Math.max(this.dirtyState, 3);
    }

    public boolean needsCopyBack() {
        return this.dirtyState >= 1;
    }

    public boolean needsRedraw() {
        return this.dirtyState >= 2;
    }

    public boolean needsReLayout() {
        return this.dirtyState >= 3;
    }

    protected GraphicsConfiguration getDefaultConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public Graphics getOffscreenGraphics() {
        return this.offscreenBackBuffer.getGraphics();
    }

    public Image getOffscreenBackBuffer() {
        return this.offscreenBackBuffer;
    }

    public int getOffscreenBackBufferWidth() {
        return this.offscreenBackBuffer.getWidth();
    }

    public int getOffscreenBackBufferHeight() {
        return this.offscreenBackBuffer.getHeight();
    }

    public Rectangle getBoundsOnBackBuffer(Component component) {
        return (Rectangle)this.componentPositionsOnBackBuffer.get(component);
    }

    public void layoutOffscreenBuffer(OffscreenDesktopPane offscreenDesktopPane) {
        if (this.needsReLayout()) {
            int n;
            int n2;
            int n3;
            int n4 = -1;
            int n5 = 0;
            for (n3 = 0; n3 < offscreenDesktopPane.getComponentCount(); ++n3) {
                Component component = ((OffscreenComponentWrapper)offscreenDesktopPane.getComponent(n3)).getChild();
                int n6 = component.getWidth();
                n2 = component.getHeight();
                n4 = Math.max(n4, n2);
                n5 += n6;
            }
            n3 = 0;
            for (n = 0; n < offscreenDesktopPane.getComponentCount(); ++n) {
                Component component = ((OffscreenComponentWrapper)offscreenDesktopPane.getComponent(n)).getChild();
                n2 = component.getWidth();
                int n7 = component.getHeight();
                Rectangle rectangle = new Rectangle(n3, 0, n2, n7);
                this.componentPositionsOnBackBuffer.put(component, rectangle);
                n3 += n2;
            }
            n = OffscreenDesktopManager.nextPowerOf2(n5);
            int n8 = OffscreenDesktopManager.nextPowerOf2(n4);
            if (this.offscreenBackBuffer == null || n != this.offscreenBackBuffer.getWidth() || n8 != this.offscreenBackBuffer.getHeight()) {
                if (this.offscreenBackBuffer != null) {
                    this.offscreenBackBuffer.flush();
                }
                this.offscreenBackBuffer = this.getDefaultConfiguration().createCompatibleVolatileImage(n, n8);
            }
            if (DEBUG) {
                this.debuggingPanel.setPreferredSize(new Dimension(n, n8));
                this.debuggingFrame.setSize(n + 10, n8 + 30);
            }
            this.dirtyState = 2;
        }
    }

    public void updateOffscreenBuffer(OffscreenDesktopPane offscreenDesktopPane) {
        if (!this.needsCopyBack()) {
            return;
        }
        this.layoutOffscreenBuffer(offscreenDesktopPane);
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            int n;
            if (this.needsRedraw()) {
                n = 0;
                do {
                    int n2;
                    if ((n2 = this.offscreenBackBuffer.validate(this.getDefaultConfiguration())) != 0 && n2 != 1) {
                        throw new RuntimeException("Unable to validate VolatileImage");
                    }
                    bl = true;
                    Graphics graphics = this.offscreenBackBuffer.getGraphics();
                    boolean bl3 = false;
                    for (int i = 0; i < offscreenDesktopPane.getComponentCount(); ++i) {
                        Component component = ((OffscreenComponentWrapper)offscreenDesktopPane.getComponent(i)).getChild();
                        if (!component.isVisible()) continue;
                        OffscreenDesktopManager.switchDoubleBuffering(component, false);
                        Rectangle rectangle = (Rectangle)this.componentPositionsOnBackBuffer.get(component);
                        if (rectangle == null) continue;
                        Graphics graphics2 = graphics.create();
                        if (DEBUG && VERBOSE) {
                            System.err.println("Translating Graphics to (" + rectangle.x + "," + rectangle.y + ")");
                            System.err.println("  Surface identifier = " + Java2D.getOGLSurfaceIdentifier((Graphics)graphics2));
                        }
                        graphics2.translate(rectangle.x, rectangle.y);
                        component.paint(graphics2);
                        graphics2.dispose();
                    }
                    graphics.dispose();
                    if (this.offscreenBackBuffer.contentsLost()) continue;
                    n = 1;
                    bl2 = true;
                } while (n == 0);
            }
            if (bl) continue;
            n = this.offscreenBackBuffer.validate(this.getDefaultConfiguration());
            if (n != 0 && n != 1) {
                throw new RuntimeException("Unable to validate VolatileImage");
            }
            if (n == 1) {
                this.setNeedsRedraw();
                continue;
            }
            bl2 = true;
        }
        this.dirtyState = 0;
        if (DEBUG) {
            this.debuggingPanel.repaint();
        }
    }

    public void openFrame(JInternalFrame jInternalFrame) {
        if (this.getDesktopPaneParent(jInternalFrame.getDesktopIcon()) != null) {
            this.getDesktopPaneParent(jInternalFrame.getDesktopIcon()).add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
        }
        this.setNeedsReLayout();
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        boolean bl = jInternalFrame.isSelected();
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jInternalFrame);
        if (bl) {
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (jDesktopPane != null) {
            jDesktopPane.remove(jInternalFrame.getParent());
            this.repaintPortionOfDesktop(jDesktopPane, jInternalFrame);
        }
        this.removeIconFor(jInternalFrame);
        if (jInternalFrame.getNormalBounds() != null) {
            jInternalFrame.setNormalBounds(null);
        }
        if (this.wasIcon(jInternalFrame)) {
            this.setWasIcon(jInternalFrame, null);
        }
        if (bl) {
            this.activateNextFrame(jDesktopPane);
        }
        this.setNeedsReLayout();
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
            Rectangle rectangle = this.getDesktopPaneParent(jInternalFrame).getBounds();
            this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setNeedsReLayout();
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            this.iconifyFrame(jInternalFrame);
            return;
        }
        if (jInternalFrame.getNormalBounds() != null) {
            Rectangle rectangle = jInternalFrame.getNormalBounds();
            jInternalFrame.setNormalBounds(null);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.setNeedsReLayout();
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Serializable serializable;
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jInternalFrame);
        JDesktopPane jDesktopPane2 = jInternalFrame.getDesktopPane();
        boolean bl = jInternalFrame.isSelected();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (!this.wasIcon(jInternalFrame)) {
            serializable = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(serializable.x, serializable.y, serializable.width, serializable.height);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if (jDesktopPane == null) {
            return;
        }
        if (jDesktopPane instanceof JLayeredPane) {
            serializable = jDesktopPane;
            int n = JLayeredPane.getLayer(jInternalFrame);
            JLayeredPane.putLayer(jDesktopIcon, n);
        }
        if (!jInternalFrame.isMaximum()) {
            jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        }
        ((Container)jDesktopPane).remove(jInternalFrame);
        jDesktopPane.add(jDesktopIcon);
        try {
            jInternalFrame.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (bl) {
            this.activateNextFrame(jDesktopPane);
        }
        this.setNeedsReLayout();
    }

    protected void activateNextFrame(Container container) {
        JInternalFrame jInternalFrame = null;
        if (container == null) {
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (!(container.getComponent(i) instanceof JInternalFrame)) continue;
            jInternalFrame = (JInternalFrame)container.getComponent(i);
            break;
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.moveToFront(jInternalFrame);
        } else {
            container.requestFocus();
        }
        this.setNeedsCopyBack();
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jDesktopIcon);
        if (jDesktopPane != null) {
            jDesktopPane.add(jInternalFrame);
            if (jInternalFrame.isMaximum()) {
                Rectangle rectangle = jDesktopPane.getBounds();
                if (jInternalFrame.getWidth() != rectangle.width || jInternalFrame.getHeight() != rectangle.height) {
                    this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
                }
            }
            this.removeIconFor(jInternalFrame);
            if (jInternalFrame.isSelected()) {
                this.moveToFront(jInternalFrame);
            } else {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        this.setNeedsReLayout();
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jInternalFrame);
        JDesktopPane jDesktopPane2 = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane2 == null ? null : jDesktopPane2.getSelectedFrame();
        if (jDesktopPane == null && (jDesktopPane = this.getDesktopPaneParent(jInternalFrame.getDesktopIcon())) == null) {
            return;
        }
        if (jInternalFrame2 == null) {
            if (jDesktopPane2 != null) {
                jDesktopPane2.setSelectedFrame(jInternalFrame);
            }
        } else if (jInternalFrame2 != jInternalFrame) {
            if (jInternalFrame2.isSelected()) {
                try {
                    jInternalFrame2.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (jDesktopPane2 != null) {
                jDesktopPane2.setSelectedFrame(jInternalFrame);
            }
        }
        this.moveToFront(jInternalFrame);
        this.setNeedsRedraw();
        this.repaintPortionOfDesktop(jInternalFrame);
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane == null ? null : jDesktopPane.getSelectedFrame();
        if (jInternalFrame2 == jInternalFrame) {
            jDesktopPane.setSelectedFrame(null);
        }
        this.setNeedsRedraw();
        this.repaintPortionOfDesktop(jInternalFrame);
    }

    public void beginDraggingFrame(JComponent jComponent) {
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        jComponent.setLocation(n, n2);
        this.repaintPortionOfDesktop(jComponent);
    }

    public void endDraggingFrame(JComponent jComponent) {
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.setBoundsForFrame(jComponent, n, n2, n3, n4);
        this.repaintPortionOfDesktop(jComponent);
    }

    public void endResizingFrame(JComponent jComponent) {
        this.repaintPortionOfDesktop(jComponent);
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
        jComponent.setBounds(n, n2, n3, n4);
        if (bl) {
            jComponent.validate();
        }
        this.setNeedsReLayout();
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jDesktopIcon);
        if (jDesktopPane != null) {
            jDesktopPane.remove(jDesktopIcon);
            this.repaintPortionOfDesktop(jDesktopPane, jDesktopIcon);
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Dimension dimension = jDesktopIcon.getPreferredSize();
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(jInternalFrame);
        if (jDesktopPane == null) {
            jDesktopPane = this.getDesktopPaneParent(jInternalFrame.getDesktopIcon());
        }
        if (jDesktopPane == null) {
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }
        Rectangle rectangle = jDesktopPane.getBounds();
        Component[] componentArray = jDesktopPane.getComponents();
        Rectangle rectangle2 = null;
        Component component = null;
        int n = 0;
        int n2 = rectangle.height - dimension.height;
        int n3 = dimension.width;
        int n4 = dimension.height;
        boolean bl = false;
        while (!bl) {
            rectangle2 = new Rectangle(n, n2, n3, n4);
            bl = true;
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof JInternalFrame) {
                    component = ((JInternalFrame)componentArray[i]).getDesktopIcon();
                } else {
                    if (!(componentArray[i] instanceof JInternalFrame.JDesktopIcon)) continue;
                    component = (JInternalFrame.JDesktopIcon)componentArray[i];
                }
                if (component.equals(jDesktopIcon) || !rectangle2.intersects(component.getBounds())) continue;
                bl = false;
                break;
            }
            if (component == null) {
                return rectangle2;
            }
            if ((n += component.getBounds().width) + n3 <= rectangle.width) continue;
            n = 0;
            n2 -= n4;
        }
        return rectangle2;
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        if (bl != null) {
            jInternalFrame.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, bl);
        }
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    protected JDesktopPane getDesktopPaneParent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (!(container instanceof OffscreenComponentWrapper)) {
            throw new RuntimeException("Illegal component structure");
        }
        Container container2 = container.getParent();
        if (container2 == null) {
            return null;
        }
        if (!(container2 instanceof JDesktopPane)) {
            throw new RuntimeException("Illegal component structure");
        }
        return (JDesktopPane)container2;
    }

    private void moveToFront(Component component) {
        JDesktopPane jDesktopPane = this.getDesktopPaneParent(component);
        if (jDesktopPane instanceof JDesktopPane) {
            jDesktopPane.moveToFront(component.getParent());
        }
    }

    private static int nextPowerOf2(int n) {
        if (n == 0) {
            return 2;
        }
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    protected void repaintPortionOfDesktop(Component component) {
        this.repaintPortionOfDesktop(this.getDesktopPaneParent(component), component);
    }

    protected void repaintPortionOfDesktop(JDesktopPane jDesktopPane, Component component) {
        Rectangle rectangle = component.getBounds();
        jDesktopPane.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void switchDoubleBuffering(Component component, boolean bl) {
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(bl);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                OffscreenDesktopManager.switchDoubleBuffering(container.getComponent(i), bl);
            }
        }
    }
}

