/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import demos.xtrans.InterpolatedFloat;
import demos.xtrans.InterpolatedQuad2f;
import demos.xtrans.InterpolatedQuad3f;
import demos.xtrans.InterpolatedVec3f;
import demos.xtrans.Quad2f;
import demos.xtrans.Quad3f;
import demos.xtrans.XTBasicTransition;
import demos.xtrans.XTTransition;
import demos.xtrans.XTTransitionManager;
import gleem.linalg.Vec2f;
import gleem.linalg.Vec3f;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class XTBasicTransitionManager
implements XTTransitionManager {
    public static Style STYLE_NO_MOTION = new Style();
    public static Style STYLE_SCROLL = new Style();
    public static Style STYLE_ROTATE = new Style();
    public static Direction DIR_LEFT = new Direction();
    public static Direction DIR_RIGHT = new Direction();
    public static Direction DIR_UP = new Direction();
    public static Direction DIR_DOWN = new Direction();
    private Style nextTransitionStyle;
    private Direction nextTransitionDirection;
    private boolean nextTransitionFade;
    private Random random;

    public void setNextTransition(Style style, Direction direction, boolean bl) {
        if (style == null) {
            throw new IllegalArgumentException("Must supply a style");
        }
        this.nextTransitionStyle = style;
        this.nextTransitionDirection = direction;
        this.nextTransitionFade = bl;
    }

    public XTTransition createTransitionForComponent(Component component, boolean bl, Rectangle rectangle, Point point, Rectangle2D rectangle2D) {
        InterpolatedFloat interpolatedFloat;
        if (this.nextTransitionStyle == null) {
            this.chooseRandomTransition();
        }
        Rectangle rectangle2 = component.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float f5 = rectangle.x;
        float f6 = rectangle.y;
        float f7 = rectangle.width;
        float f8 = rectangle.height;
        Quad3f quad3f = new Quad3f(new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, (float)(-n4), 0.0f), new Vec3f((float)n3, (float)(-n4), 0.0f), new Vec3f((float)n3, 0.0f, 0.0f));
        Quad2f quad2f = new Quad2f(new Vec2f(f, f2 + f4), new Vec2f(f, f2), new Vec2f(f + f3, f2), new Vec2f(f + f3, f2 + f4));
        XTBasicTransition xTBasicTransition = new XTBasicTransition();
        Vec3f vec3f = new Vec3f((float)(n - point.x), f8 - (float)n2 - (float)point.y, 0.0f);
        InterpolatedVec3f interpolatedVec3f = new InterpolatedVec3f();
        interpolatedVec3f.setStart(vec3f);
        interpolatedVec3f.setEnd(vec3f);
        InterpolatedQuad3f interpolatedQuad3f = new InterpolatedQuad3f();
        interpolatedQuad3f.setStart(quad3f);
        interpolatedQuad3f.setEnd(quad3f);
        InterpolatedQuad2f interpolatedQuad2f = new InterpolatedQuad2f();
        interpolatedQuad2f.setStart(quad2f);
        interpolatedQuad2f.setEnd(quad2f);
        xTBasicTransition.setTranslation(interpolatedVec3f);
        xTBasicTransition.setVertices(interpolatedQuad3f);
        xTBasicTransition.setTexCoords(interpolatedQuad2f);
        Style style = this.nextTransitionStyle;
        Direction direction = this.nextTransitionDirection;
        boolean bl2 = this.nextTransitionFade;
        this.nextTransitionStyle = null;
        this.nextTransitionDirection = null;
        this.nextTransitionFade = false;
        Object object = null;
        Object object2 = null;
        Vec3f vec3f2 = null;
        Vec3f vec3f3 = null;
        float f9 = 0.0f;
        float f10 = 0.0f;
        if (bl2) {
            interpolatedFloat = new InterpolatedFloat();
            float f11 = bl ? 0.0f : 1.0f;
            float f12 = bl ? 1.0f : 0.0f;
            interpolatedFloat.setStart(f11);
            interpolatedFloat.setEnd(f12);
            xTBasicTransition.setAlpha(interpolatedFloat);
        }
        if (direction != null) {
            if (style == STYLE_SCROLL) {
                if (direction == DIR_LEFT) {
                    object = new int[]{3, 2, 2, 3};
                    object2 = new int[]{0, 1, 1, 0};
                } else if (direction == DIR_RIGHT) {
                    object = new int[]{0, 1, 1, 0};
                    object2 = new int[]{3, 2, 2, 3};
                } else if (direction == DIR_UP) {
                    object = new int[]{1, 1, 2, 2};
                    object2 = new int[]{0, 0, 3, 3};
                } else {
                    object = new int[]{0, 0, 3, 3};
                    object2 = new int[]{1, 1, 2, 2};
                }
            } else if (style == STYLE_ROTATE) {
                if (direction == DIR_LEFT) {
                    vec3f2 = new Vec3f(0.0f, 1.0f, 0.0f);
                    vec3f3 = new Vec3f();
                    f9 = -90.0f;
                    f10 = 0.0f;
                } else if (direction == DIR_RIGHT) {
                    vec3f2 = new Vec3f(0.0f, 1.0f, 0.0f);
                    vec3f3 = new Vec3f((float)n3, 0.0f, 0.0f);
                    f9 = 90.0f;
                    f10 = 0.0f;
                } else if (direction == DIR_UP) {
                    vec3f2 = new Vec3f(1.0f, 0.0f, 0.0f);
                    vec3f3 = new Vec3f(0.0f, (float)(-n4), 0.0f);
                    f9 = 90.0f;
                    f10 = 0.0f;
                } else {
                    vec3f2 = new Vec3f(1.0f, 0.0f, 0.0f);
                    vec3f3 = new Vec3f();
                    f9 = -90.0f;
                    f10 = 0.0f;
                }
            }
        }
        if (object != null) {
            if (bl) {
                interpolatedQuad3f.setStart(new Quad3f(quad3f.getVec((int)object[0]), quad3f.getVec((int)object[1]), quad3f.getVec((int)object[2]), quad3f.getVec((int)object[3])));
                interpolatedQuad2f.setStart(new Quad2f(quad2f.getVec((int)object2[0]), quad2f.getVec((int)object2[1]), quad2f.getVec((int)object2[2]), quad2f.getVec((int)object2[3])));
            } else {
                interpolatedFloat = object;
                object = object2;
                object2 = interpolatedFloat;
                interpolatedQuad3f.setEnd(new Quad3f(quad3f.getVec((int)object[0]), quad3f.getVec((int)object[1]), quad3f.getVec((int)object[2]), quad3f.getVec((int)object[3])));
                interpolatedQuad2f.setEnd(new Quad2f(quad2f.getVec((int)object2[0]), quad2f.getVec((int)object2[1]), quad2f.getVec((int)object2[2]), quad2f.getVec((int)object2[3])));
            }
        } else if (vec3f2 != null) {
            if (!bl) {
                float f13 = f10;
                f10 = -f9;
                f9 = f13;
            }
            xTBasicTransition.setPivotPoint(vec3f3);
            xTBasicTransition.setRotationAxis(vec3f2);
            interpolatedFloat = new InterpolatedFloat();
            interpolatedFloat.setStart(f9);
            interpolatedFloat.setEnd(f10);
            xTBasicTransition.setRotationAngle(interpolatedFloat);
        }
        return xTBasicTransition;
    }

    protected void chooseRandomTransition() {
        int n;
        if (this.random == null) {
            this.random = new Random();
        }
        this.nextTransitionFade = this.random.nextBoolean();
        this.nextTransitionStyle = null;
        block9: do {
            n = this.random.nextInt(3);
            switch (n) {
                case 0: {
                    if (!this.nextTransitionFade) continue block9;
                    this.nextTransitionStyle = STYLE_NO_MOTION;
                    break;
                }
                case 1: {
                    this.nextTransitionStyle = STYLE_SCROLL;
                    break;
                }
                default: {
                    this.nextTransitionStyle = STYLE_ROTATE;
                }
            }
        } while (this.nextTransitionStyle == null);
        n = this.random.nextInt(4);
        switch (n) {
            case 0: {
                this.nextTransitionDirection = DIR_LEFT;
                break;
            }
            case 1: {
                this.nextTransitionDirection = DIR_RIGHT;
                break;
            }
            case 2: {
                this.nextTransitionDirection = DIR_UP;
                break;
            }
            default: {
                this.nextTransitionDirection = DIR_DOWN;
            }
        }
    }

    public static class Direction {
        private Direction() {
        }
    }

    public static class Style {
        private Style() {
        }
    }
}

