/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import com.sun.opengl.impl.Java2D;
import demos.xtrans.OffscreenDesktopPane;
import demos.xtrans.XTBasicTransitionManager;
import demos.xtrans.XTDesktopManager;
import demos.xtrans.XTTransition;
import demos.xtrans.XTTransitionManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;

public class XTDesktopPane
extends OffscreenDesktopPane {
    private GLContext j2dContext;
    private Object j2dContextSurfaceIdentifier;
    private Rectangle oglViewport;
    private XTTransitionManager transitionManager = new XTBasicTransitionManager();
    private boolean reallyRemove;
    private boolean alwaysRedraw;
    private List transitions = new ArrayList();
    private float TRANSITION_DURATION = 300.0f;
    private int textureTarget = 3553;
    private GLU glu = new GLU();

    public XTDesktopPane() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new RuntimeException("XTDesktopPane requires new Java2D/JOGL support in Java SE 6 and -Dsun.java2d.opengl=true");
        }
        this.setDesktopManager(new XTDesktopManager());
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.getOffscreenDesktopManager().layoutOffscreenBuffer(this);
        this.addTransition(true, component, this.transitionManager.createTransitionForComponent(component, true, this.getOGLViewport(), this.computeViewportOffsetToCenterComponent(component, this.getOGLViewport()), this.getXTDesktopManager().getOpenGLTextureCoords(component)));
    }

    public void remove(int n) {
        if (this.reallyRemove) {
            super.remove(n);
        } else {
            this.addRemoveTransition(XTDesktopPane.getRealComponent(this.getComponent(n)));
        }
    }

    public void remove(Component component) {
        if (this.reallyRemove) {
            super.remove(component);
        } else {
            this.addRemoveTransition(XTDesktopPane.getRealComponent(component));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeImpl(Component component) {
        this.reallyRemove = true;
        try {
            this.remove(component);
        }
        finally {
            this.reallyRemove = false;
        }
    }

    protected void paintChildren(final Graphics graphics) {
        if (this.alwaysRedraw) {
            this.getOffscreenDesktopManager().setNeedsRedraw();
        }
        this.getOffscreenDesktopManager().updateOffscreenBuffer(this);
        final Component[] componentArray = this.getRealChildComponents();
        final ArrayList arrayList = new ArrayList();
        Java2D.invokeWithOGLContextCurrent((Graphics)graphics, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (XTDesktopPane.this.j2dContext == null || XTDesktopPane.this.j2dContextSurfaceIdentifier != Java2D.getOGLSurfaceIdentifier((Graphics)graphics)) {
                    XTDesktopPane.this.j2dContext = GLDrawableFactory.getFactory().createExternalGLContext();
                    XTDesktopPane.this.j2dContext.setGL((GL)new DebugGL(XTDesktopPane.this.j2dContext.getGL()));
                    XTDesktopPane.this.j2dContextSurfaceIdentifier = Java2D.getOGLSurfaceIdentifier((Graphics)graphics);
                }
                XTDesktopPane.this.j2dContext.makeCurrent();
                try {
                    GL gL = XTDesktopPane.this.j2dContext.getGL();
                    Rectangle rectangle = Java2D.getOGLViewport((Graphics)graphics, (int)XTDesktopPane.this.getWidth(), (int)XTDesktopPane.this.getHeight());
                    XTDesktopPane.this.oglViewport = new Rectangle(rectangle);
                    double d = 30.0;
                    double d2 = rectangle.getWidth();
                    double d3 = rectangle.getHeight();
                    double d4 = d3 / 2.0 / Math.tan(Math.toRadians(d) / 2.0);
                    double d5 = d4 - d3 / 2.0;
                    double d6 = d4 + d3 / 2.0;
                    gL.glViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    gL.glMatrixMode(5889);
                    gL.glPushMatrix();
                    gL.glLoadIdentity();
                    XTDesktopPane.this.glu.gluPerspective(d, d2 / d3, d5, d6);
                    gL.glMatrixMode(5890);
                    gL.glPushMatrix();
                    gL.glLoadIdentity();
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    gL.glLoadIdentity();
                    double d7 = d2 / 2.0;
                    double d8 = d3 / 2.0;
                    XTDesktopPane.this.glu.gluLookAt(d7, d8, d4, d7, d8, 0.0, 0.0, 1.0, 0.0);
                    gL.glEnable(3089);
                    Rectangle rectangle2 = Java2D.getOGLScissorBox((Graphics)graphics);
                    if (rectangle2 != null) {
                        gL.glScissor(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    gL.glBindTexture(XTDesktopPane.this.textureTarget, XTDesktopPane.this.getXTDesktopManager().getOpenGLTextureObject());
                    gL.glEnable(XTDesktopPane.this.textureTarget);
                    gL.glTexParameteri(XTDesktopPane.this.textureTarget, 10242, 10496);
                    gL.glTexParameteri(XTDesktopPane.this.textureTarget, 10243, 10496);
                    gL.glTexParameteri(XTDesktopPane.this.textureTarget, 10240, 9729);
                    gL.glTexParameteri(XTDesktopPane.this.textureTarget, 10241, 9729);
                    gL.glEnable(3042);
                    gL.glTexEnvi(8960, 8704, 8448);
                    gL.glBlendFunc(770, 771);
                    int n = componentArray.length;
                    long l = XTDesktopPane.currentTimeMillis();
                    for (int i = n - 1; i >= 0; --i) {
                        Cloneable cloneable;
                        Component component = componentArray[i];
                        TransitionInfo transitionInfo = XTDesktopPane.this.transitionForComponent(component);
                        if (transitionInfo != null) {
                            gL.glPushMatrix();
                            cloneable = XTDesktopPane.this.computeViewportOffsetToCenterComponent(component, XTDesktopPane.this.getOGLViewport());
                            gL.glViewport(rectangle.x + ((Point)cloneable).x, rectangle.y + ((Point)cloneable).y, rectangle.width, rectangle.height);
                            float f = XTDesktopPane.clamp((float)(l - transitionInfo.startTime) / XTDesktopPane.this.TRANSITION_DURATION, 0.0f, 1.0f);
                            XTTransition xTTransition = transitionInfo.trans;
                            xTTransition.update(f);
                            xTTransition.draw(gL);
                            if (f == 1.0f) {
                                XTDesktopPane.this.transitions.remove(transitionInfo);
                                arrayList.add(transitionInfo);
                            }
                            gL.glPopMatrix();
                            gL.glViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            continue;
                        }
                        cloneable = XTDesktopPane.this.getXTDesktopManager().getOpenGLTextureCoords(component);
                        Rectangle rectangle3 = component.getBounds();
                        int n2 = rectangle3.x;
                        int n3 = rectangle3.y;
                        int n4 = rectangle3.width;
                        int n5 = rectangle3.height;
                        float f = (float)((RectangularShape)cloneable).getX();
                        float f2 = (float)((RectangularShape)cloneable).getY();
                        float f3 = (float)((RectangularShape)cloneable).getWidth();
                        float f4 = (float)((RectangularShape)cloneable).getHeight();
                        float f5 = rectangle.x;
                        float f6 = rectangle.y;
                        float f7 = rectangle.width;
                        float f8 = rectangle.height;
                        gL.glBegin(4);
                        gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                        gL.glTexCoord2f(f, f2 + f4);
                        gL.glVertex3f((float)n2, f8 - (float)n3, 0.0f);
                        gL.glTexCoord2f(f, f2);
                        gL.glVertex3f((float)n2, f8 - (float)n3 - (float)n5, 0.0f);
                        gL.glTexCoord2f(f + f3, f2 + f4);
                        gL.glVertex3f((float)(n2 + n4), f8 - (float)n3, 0.0f);
                        gL.glTexCoord2f(f + f3, f2 + f4);
                        gL.glVertex3f((float)(n2 + n4), f8 - (float)n3, 0.0f);
                        gL.glTexCoord2f(f, f2);
                        gL.glVertex3f((float)n2, f8 - (float)n3 - (float)n5, 0.0f);
                        gL.glTexCoord2f(f + f3, f2);
                        gL.glVertex3f((float)(n2 + n4), f8 - (float)n3 - (float)n5, 0.0f);
                        gL.glEnd();
                    }
                    gL.glFlush();
                    gL.glDisable(XTDesktopPane.this.textureTarget);
                    gL.glDisable(3042);
                    gL.glTexEnvi(8960, 8704, 8448);
                    gL.glMatrixMode(5889);
                    gL.glPopMatrix();
                    gL.glMatrixMode(5890);
                    gL.glPopMatrix();
                    gL.glMatrixMode(5888);
                    gL.glPopMatrix();
                    gL.glFinish();
                }
                finally {
                    XTDesktopPane.this.j2dContext.release();
                }
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TransitionInfo transitionInfo = (TransitionInfo)iterator.next();
            if (transitionInfo.isIn) continue;
            this.removeImpl(transitionInfo.target);
            this.repaint();
        }
        if (!this.transitions.isEmpty()) {
            this.repaint();
        }
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public XTDesktopManager getXTDesktopManager() {
        return (XTDesktopManager)this.getDesktopManager();
    }

    public XTTransitionManager getTransitionManager() {
        return this.transitionManager;
    }

    public void setTransitionManager(XTTransitionManager xTTransitionManager) {
        this.transitionManager = xTTransitionManager;
    }

    public void setAlwaysRedraw(boolean bl) {
        this.alwaysRedraw = bl;
    }

    public boolean getAlwaysRedraw() {
        return this.alwaysRedraw;
    }

    private TransitionInfo transitionForComponent(Component component) {
        Iterator iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            TransitionInfo transitionInfo = (TransitionInfo)iterator.next();
            if (transitionInfo.target != component) continue;
            return transitionInfo;
        }
        return null;
    }

    protected void addTransition(boolean bl, Component component, XTTransition xTTransition) {
        TransitionInfo transitionInfo = new TransitionInfo(bl, component, XTDesktopPane.currentTimeMillis(), xTTransition);
        this.transitions.add(transitionInfo);
    }

    protected void addRemoveTransition(Component component) {
        this.addTransition(false, component, this.transitionManager.createTransitionForComponent(component, false, this.getOGLViewport(), this.computeViewportOffsetToCenterComponent(component, this.getOGLViewport()), this.getXTDesktopManager().getOpenGLTextureCoords(component)));
    }

    protected Point computeViewportOffsetToCenterComponent(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = component.getBounds();
        return new Point(rectangle2.x + (rectangle2.width - rectangle.width) / 2, -rectangle2.y + (rectangle.height - rectangle2.height) / 2);
    }

    protected static float clamp(float f, float f2, float f3) {
        return Math.min(f3, Math.max(f2, f));
    }

    protected static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected Rectangle getOGLViewport() {
        if (this.oglViewport != null) {
            return this.oglViewport;
        }
        Rectangle rectangle = this.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    static class TransitionInfo {
        boolean isIn;
        Component target;
        long startTime;
        XTTransition trans;

        TransitionInfo(boolean bl, Component component, long l, XTTransition xTTransition) {
            this.isIn = bl;
            this.target = component;
            this.startTime = l;
            this.trans = xTTransition;
        }
    }
}

