/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.opengl;

import com.sun.javafx.newt.Display;
import com.sun.javafx.newt.Insets;
import com.sun.javafx.newt.KeyListener;
import com.sun.javafx.newt.MouseListener;
import com.sun.javafx.newt.NewtFactory;
import com.sun.javafx.newt.Screen;
import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.WindowEvent;
import com.sun.javafx.newt.WindowListener;
import com.sun.opengl.impl.GLDrawableHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class GLWindow
extends Window
implements GLAutoDrawable {
    public static final int EVENT_HANDLER_GL_NONE = 0;
    public static final int EVENT_HANDLER_GL_CURRENT = 1;
    private static List glwindows = new ArrayList();
    private Window window;
    private boolean runPumpMessages = true;
    private static int eventHandlerMode = 1;
    private static boolean autoSwapBufferMode = true;
    private GLDrawableFactory factory;
    private GLDrawable drawable;
    private GLContext context;
    private GLDrawableHelper helper = new GLDrawableHelper();
    private boolean sendReshape = false;
    private boolean sendDestroy = false;
    private boolean perfLog = false;
    private DisplayPumpMessage displayPumpMessage = new DisplayPumpMessage();
    private static DisplayPumpMessageStatic displayPumpMessageStatic = new DisplayPumpMessageStatic();
    private InitAction initAction = new InitAction();
    private DisposeAction disposeAction = new DisposeAction();
    private DisplayAction displayAction = new DisplayAction();
    private long startTime = 0L;
    private long curTime = 0L;
    private long lastCheck = 0L;
    private int totalFrames = 0;
    private int lastFrames = 0;
    private boolean ownerOfDisplayAndScreen;
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();

    protected GLWindow(Window window, boolean bl) {
        this.ownerOfDisplayAndScreen = bl;
        this.window = window;
        this.window.setAutoDrawableClient(true);
        window.addWindowListener(new WindowListener(){

            public void windowResized(WindowEvent windowEvent) {
                GLWindow.this.sendReshape = true;
            }

            public void windowMoved(WindowEvent windowEvent) {
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                GLWindow.this.sendDestroy = true;
            }
        });
        List list = (List)((ArrayList)glwindows).clone();
        list.add(this);
        glwindows = list;
    }

    public static GLWindow create() {
        return GLWindow.create(null, null, false);
    }

    public static GLWindow create(boolean bl) {
        return GLWindow.create(null, null, bl);
    }

    public static GLWindow create(Window window) {
        return GLWindow.create(window, null, false);
    }

    public static GLWindow create(GLCapabilities gLCapabilities) {
        return GLWindow.create(null, gLCapabilities, false);
    }

    public static GLWindow create(GLCapabilities gLCapabilities, boolean bl) {
        return GLWindow.create(null, gLCapabilities, bl);
    }

    private static GLWindow create(Window window, GLCapabilities gLCapabilities, boolean bl) {
        boolean bl2 = false;
        if (window == null) {
            if (gLCapabilities == null) {
                gLCapabilities = new GLCapabilities(null);
            }
            bl2 = true;
            Display display = NewtFactory.createDisplay(null);
            Screen screen = NewtFactory.createScreen((Display)display, (int)0);
            window = NewtFactory.createWindow((Screen)screen, (Capabilities)gLCapabilities, (boolean)bl);
        }
        return new GLWindow(window, bl2);
    }

    public void setRunPumpMessages(boolean bl) {
        this.runPumpMessages = bl;
    }

    protected void createNative(long l, Capabilities capabilities) {
        this.shouldNotCallThis();
    }

    protected void closeNative() {
        this.shouldNotCallThis();
    }

    protected void dispose(boolean bl) {
        block15: {
            block14: {
                Exception exception;
                block13: {
                    block12: {
                        if (Window.DEBUG_WINDOW_EVENT) break block12;
                        if (!Window.DEBUG_IMPLEMENTATION) break block13;
                    }
                    exception = new Exception("GLWindow.dispose(" + bl + ") " + Thread.currentThread().getName() + ", 1: " + (Object)((Object)this));
                    exception.printStackTrace();
                }
                this.sendDisposeEvent();
                if (this.context != null) {
                    this.context.destroy();
                }
                if (this.drawable != null) {
                    this.drawable.setRealized(false);
                }
                if (null != this.window) {
                    this.window.disposeSurfaceHandle();
                }
                if (bl) {
                    if (null == this.window) {
                        throw new GLException("GLWindow.dispose(true): null window");
                    }
                    exception = this.window.getWrappedWindow() != null ? NativeWindowFactory.getNativeWindow((Object)this.window.getWrappedWindow(), (AbstractGraphicsConfiguration)this.window.getGraphicsConfiguration()) : this.window;
                    this.drawable = this.factory.createGLDrawable((NativeWindow)exception);
                    this.drawable.setRealized(true);
                    if (this.getSurfaceHandle() == 0L) {
                        throw new GLException("SurfaceHandle==NULL after setRealize(true) " + (Object)((Object)this));
                    }
                    this.context = this.drawable.createContext(null);
                    this.sendReshape = true;
                }
                if (Window.DEBUG_WINDOW_EVENT) break block14;
                if (!Window.DEBUG_IMPLEMENTATION) break block15;
            }
            System.out.println("GLWindow.dispose(" + bl + ") " + Thread.currentThread().getName() + ", fin: " + (Object)((Object)this));
        }
    }

    public synchronized void destroy() {
        Display display;
        Screen screen;
        block13: {
            block12: {
                Object object;
                block11: {
                    block10: {
                        if (Window.DEBUG_WINDOW_EVENT) break block10;
                        if (!Window.DEBUG_IMPLEMENTATION) break block11;
                    }
                    object = new Exception("GLWindow.destroy " + Thread.currentThread().getName() + ", 1: " + (Object)((Object)this));
                    ((Throwable)object).printStackTrace();
                }
                object = (List)((ArrayList)glwindows).clone();
                object.remove((Object)this);
                glwindows = object;
                this.dispose(false);
                screen = null;
                display = null;
                if (null != this.window) {
                    if (this.ownerOfDisplayAndScreen && null != (screen = this.getScreen())) {
                        display = screen.getDisplay();
                    }
                    this.window.destroy();
                }
                if (Window.DEBUG_WINDOW_EVENT) break block12;
                if (!Window.DEBUG_IMPLEMENTATION) break block13;
            }
            System.out.println("GLWindow.destroy " + Thread.currentThread().getName() + ", fin: " + (Object)((Object)this));
        }
        this.drawable = null;
        this.context = null;
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
        this.window = null;
    }

    public boolean getPerfLogEnabled() {
        return this.perfLog;
    }

    public void enablePerfLog(boolean bl) {
        this.perfLog = bl;
    }

    public void setEventHandlerMode(int n) {
        eventHandlerMode = n;
    }

    public int getEventHandlerMode() {
        return eventHandlerMode;
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
        if (bl && this.context == null) {
            Object object = this.window.getWrappedWindow() != null ? NativeWindowFactory.getNativeWindow((Object)this.window.getWrappedWindow(), (AbstractGraphicsConfiguration)this.window.getGraphicsConfiguration()) : this.window;
            GLCapabilities gLCapabilities = (GLCapabilities)object.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
            this.factory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
            this.drawable = this.factory.createGLDrawable((NativeWindow)object);
            this.drawable.setRealized(true);
            if (this.getSurfaceHandle() == 0L) {
                throw new GLException("SurfaceHandle==NULL after setRealize(true) " + (Object)((Object)this));
            }
            this.context = this.drawable.createContext(null);
            this.sendReshape = true;
        }
    }

    public Screen getScreen() {
        return this.window.getScreen();
    }

    public void setTitle(String string) {
        this.window.setTitle(string);
    }

    public String getTitle() {
        return this.window.getTitle();
    }

    public void setUndecorated(boolean bl) {
        this.window.setUndecorated(bl);
    }

    public boolean isUndecorated() {
        return this.window.isUndecorated();
    }

    public void setSize(int n, int n2) {
        this.window.setSize(n, n2);
    }

    public void setPosition(int n, int n2) {
        this.window.setPosition(n, n2);
    }

    public Insets getInsets() {
        return this.window.getInsets();
    }

    public boolean setFullscreen(boolean bl) {
        return this.window.setFullscreen(bl);
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public int getX() {
        return this.window.getX();
    }

    public int getY() {
        return this.window.getY();
    }

    public int getWidth() {
        return this.window.getWidth();
    }

    public int getHeight() {
        return this.window.getHeight();
    }

    public boolean isFullscreen() {
        return this.window.isFullscreen();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    public MouseListener[] getMouseListeners() {
        return this.window.getMouseListeners();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    public KeyListener[] getKeyListeners() {
        return this.window.getKeyListeners();
    }

    public void addWindowListener(WindowListener windowListener) {
        this.window.addWindowListener(windowListener);
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.window.removeWindowListener(windowListener);
    }

    public WindowListener[] getWindowListeners() {
        return this.window.getWindowListeners();
    }

    public String toString() {
        return "NEWT-GLWindow[ " + this.drawable + ", \n\t" + this.window + ", \n\t" + this.helper + ", \n\t" + this.factory + "]";
    }

    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    public void setContext(GLContext gLContext) {
        this.context = gLContext;
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        if (this.context == null) {
            return null;
        }
        return this.context.getGL();
    }

    public GL setGL(GL gL) {
        if (this.context != null) {
            this.context.setGL(gL);
            return gL;
        }
        return null;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.helper.removeGLEventListener(gLEventListener);
    }

    public static void runCurrentThreadPumpMessage() {
        GLWindow gLWindow;
        Iterator iterator;
        Exception exception = null;
        if (0 != (eventHandlerMode & 1)) {
            iterator = glwindows.iterator();
            while (iterator.hasNext()) {
                gLWindow = (GLWindow)((Object)iterator.next());
                gLWindow.helper.setAutoSwapBufferMode(false);
                gLWindow.helper.invokeGL(gLWindow.drawable, gLWindow.context, null, (Runnable)gLWindow.initAction);
            }
        }
        try {
            Display.runCurrentThreadDisplaysAction((Display.Action)displayPumpMessageStatic);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (0 != (eventHandlerMode & 1)) {
            iterator = glwindows.iterator();
            while (iterator.hasNext()) {
                gLWindow = (GLWindow)((Object)iterator.next());
                gLWindow.helper.setAutoSwapBufferMode(autoSwapBufferMode);
            }
        }
        if (null != exception) {
            throw new GLException((Throwable)exception);
        }
    }

    public void display() {
        if (this.getSurfaceHandle() != 0L) {
            if (this.runPumpMessages) {
                this.displayPumpMessage.run(this.window.getScreen().getDisplay());
            }
            if (this.window.hasDeviceChanged() && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
                this.dispose(true);
            }
            if (this.sendDestroy) {
                this.destroy();
                this.sendDestroy = false;
            } else {
                this.helper.invokeGL(this.drawable, this.context, (Runnable)this.displayAction, (Runnable)this.initAction);
            }
        }
    }

    private void sendDisposeEvent() {
        if (this.disposeAction != null && this.drawable != null && this.context != null && this.window != null && this.getSurfaceHandle() != 0L) {
            this.helper.invokeGL(this.drawable, this.context, (Runnable)this.disposeAction, null);
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        autoSwapBufferMode = bl;
    }

    public boolean getAutoSwapBufferMode() {
        return autoSwapBufferMode;
    }

    public void swapBuffers() {
        if (this.getSurfaceHandle() != 0L) {
            if (this.context != null && this.context != GLContext.getCurrent()) {
                this.helper.invokeGL(this.drawable, this.context, (Runnable)this.swapBuffersAction, (Runnable)this.initAction);
            } else {
                this.drawable.swapBuffers();
            }
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCurrentTime() {
        return this.curTime;
    }

    public long getDuration() {
        return this.curTime - this.startTime;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public NativeWindow getNativeWindow() {
        return null != this.drawable ? this.drawable.getNativeWindow() : null;
    }

    public synchronized int lockSurface() throws NativeWindowException {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().lockSurface();
        }
        return 1;
    }

    public synchronized void unlockSurface() {
        if (null == this.drawable) {
            throw new NativeWindowException("NEWT-GLWindow not locked");
        }
        this.drawable.getNativeWindow().unlockSurface();
    }

    public synchronized boolean isSurfaceLocked() {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().isSurfaceLocked();
        }
        return false;
    }

    public synchronized Exception getLockedStack() {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().getLockedStack();
        }
        return null;
    }

    public boolean surfaceSwap() {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().surfaceSwap();
        }
        return super.surfaceSwap();
    }

    public void surfaceUpdated() {
        if (null != this.drawable) {
            this.drawable.getNativeWindow().surfaceUpdated();
        } else {
            super.surfaceUpdated();
        }
    }

    public long getWindowHandle() {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().getWindowHandle();
        }
        return super.getWindowHandle();
    }

    public long getSurfaceHandle() {
        if (null != this.drawable) {
            return this.drawable.getNativeWindow().getSurfaceHandle();
        }
        return super.getSurfaceHandle();
    }

    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public GLCapabilities getChosenGLCapabilities() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getChosenGLCapabilities();
    }

    public GLProfile getGLProfile() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getGLProfile();
    }

    private void shouldNotCallThis() {
        throw new NativeWindowException("Should not call this");
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLWindow.this.drawable.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            if (GLWindow.this.sendReshape) {
                int n = GLWindow.this.getWidth();
                int n2 = GLWindow.this.getHeight();
                GLWindow.this.getGL().glViewport(0, 0, n, n2);
                GLWindow.this.helper.reshape((GLAutoDrawable)GLWindow.this, 0, 0, n, n2);
                GLWindow.this.sendReshape = false;
            }
            GLWindow.this.helper.display((GLAutoDrawable)GLWindow.this);
            GLWindow.this.curTime = System.currentTimeMillis();
            GLWindow.this.totalFrames++;
            if (GLWindow.this.perfLog) {
                GLWindow.this.lastFrames++;
                long l = GLWindow.this.curTime - GLWindow.this.lastCheck;
                if (l > 5000L) {
                    long l2 = GLWindow.this.curTime - GLWindow.this.startTime;
                    System.out.println(l / 1000L + "s: " + GLWindow.this.lastFrames + "f, " + (long)(GLWindow.this.lastFrames * 1000) / l + " fps, " + l / (long)GLWindow.this.lastFrames + " ms/f; " + "total: " + l2 / 1000L + "s, " + (long)(GLWindow.this.totalFrames * 1000) / l2 + " fps, " + l2 / (long)GLWindow.this.totalFrames + " ms/f");
                    GLWindow.this.lastCheck = GLWindow.this.curTime;
                    GLWindow.this.lastFrames = 0;
                }
            }
        }
    }

    class DisposeAction
    implements Runnable {
        DisposeAction() {
        }

        public void run() {
            GLWindow.this.helper.dispose((GLAutoDrawable)GLWindow.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLWindow.this.helper.init((GLAutoDrawable)GLWindow.this);
            GLWindow.this.startTime = System.currentTimeMillis();
            GLWindow.this.curTime = GLWindow.this.startTime;
            if (GLWindow.this.perfLog) {
                GLWindow.this.lastCheck = GLWindow.this.startTime;
                GLWindow.this.totalFrames = 0;
                GLWindow.this.lastFrames = 0;
            }
        }
    }

    static class DisplayPumpMessageStatic
    implements Display.Action {
        DisplayPumpMessageStatic() {
        }

        public void run(Display display) {
            display.run();
        }
    }

    class DisplayPumpMessage
    implements Display.Action {
        DisplayPumpMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Display display) {
            if (0 == (eventHandlerMode & 1)) {
                display.run();
            } else {
                GLWindow.this.helper.setAutoSwapBufferMode(false);
                try {
                    GLWindow.this.helper.invokeGL(GLWindow.this.drawable, GLWindow.this.context, (Runnable)display, (Runnable)GLWindow.this.initAction);
                }
                finally {
                    GLWindow.this.helper.setAutoSwapBufferMode(autoSwapBufferMode);
                }
            }
        }
    }
}

