/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt;

import com.sun.javafx.newt.impl.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.nativewindow.AbstractGraphicsDevice;

public abstract class Display
implements Runnable {
    public static final boolean DEBUG = Debug.debug("Display");
    private static ThreadLocal currentDisplayMap = new ThreadLocal();
    protected String name;
    protected int refCount;
    protected AbstractGraphicsDevice aDevice;

    private static Class getDisplayClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if ("EGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.kd.KDDisplay");
        } else if ("Windows".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.windows.WindowsDisplay");
        } else if ("MacOSX".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.macosx.MacDisplay");
        } else if ("X11".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.x11.X11Display");
        } else if ("AWT".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.awt.AWTDisplay");
        } else if ("BroadcomEGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.broadcom.BCEGLDisplay");
        } else {
            throw new RuntimeException("Unknown display type \"" + string + "\"");
        }
        return clazz;
    }

    public static Map getCurrentDisplayMap() {
        HashMap hashMap = (HashMap)currentDisplayMap.get();
        if (null == hashMap) {
            hashMap = new HashMap();
            currentDisplayMap.set(hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Display setCurrentDisplay(Display display) {
        Map map = Display.getCurrentDisplayMap();
        Display display2 = null;
        Map map2 = map;
        synchronized (map2) {
            String string = display.getName();
            if (null == string) {
                string = "nil";
            }
            display2 = map.put(string, display);
            map.notifyAll();
        }
        return display2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Display removeCurrentDisplay(String string) {
        if (null == string) {
            string = "nil";
        }
        Map map = Display.getCurrentDisplayMap();
        Display display = null;
        Map map2 = map;
        synchronized (map2) {
            display = (Display)map.remove(string);
            map.notifyAll();
        }
        return display;
    }

    public static Display getCurrentDisplay(String string) {
        if (null == string) {
            string = "nil";
        }
        Map map = Display.getCurrentDisplayMap();
        Display display = (Display)map.get(string);
        return display;
    }

    private static void dumpDisplayMap(String string) {
        Map map = Display.getCurrentDisplayMap();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        System.err.println(string + " DisplayMap[" + set.size() + "] " + Thread.currentThread().getName());
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.err.println("  [" + n + "] " + entry.getKey() + " -> " + entry.getValue());
            ++n;
        }
    }

    public static Collection getCurrentDisplays() {
        return Display.getCurrentDisplayMap().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Display create(String string, String string2) {
        try {
            Display display = Display.getCurrentDisplay(string2);
            if (null == display) {
                Class clazz = Display.getDisplayClass(string);
                display = (Display)clazz.newInstance();
                display.name = string2;
                display.refCount = 1;
                display.createNative();
                if (null == display.aDevice) {
                    throw new RuntimeException("Display.createNative() failed to instanciate an AbstractGraphicsDevice");
                }
                Display.setCurrentDisplay(display);
                if (DEBUG) {
                    System.err.println("Display.create(" + string2 + ") NEW: " + display + " " + Thread.currentThread().getName());
                }
            } else {
                Display display2 = display;
                synchronized (display2) {
                    ++display.refCount;
                    if (DEBUG) {
                        System.err.println("Display.create(" + string2 + ") REUSE: refCount " + display.refCount + ", " + display + " " + Thread.currentThread().getName());
                    }
                }
            }
            return display;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized void destroy() {
        --this.refCount;
        if (0 == this.refCount) {
            Display.removeCurrentDisplay(this.name);
            if (DEBUG) {
                System.err.println("Display.destroy(" + this.name + ") REMOVE: " + this + " " + Thread.currentThread().getName());
            }
            this.closeNative();
        } else if (DEBUG) {
            System.err.println("Display.destroy(" + this.name + ") KEEP: refCount " + this.refCount + ", " + this + " " + Thread.currentThread().getName());
        }
    }

    protected static Display wrapHandle(String string, String string2, AbstractGraphicsDevice abstractGraphicsDevice) {
        try {
            Class clazz = Display.getDisplayClass(string);
            Display display = (Display)clazz.newInstance();
            display.name = string2;
            display.aDevice = abstractGraphicsDevice;
            return display;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract void createNative();

    protected abstract void closeNative();

    public String getName() {
        return this.name;
    }

    public long getHandle() {
        return this.aDevice.getHandle();
    }

    public AbstractGraphicsDevice getGraphicsDevice() {
        return this.aDevice;
    }

    public synchronized void pumpMessages() {
        this.dispatchMessages();
    }

    public void run() {
        this.pumpMessages();
    }

    public static void runCurrentThreadDisplaysAction(Action action) {
        Iterator iterator = Display.getCurrentDisplays().iterator();
        while (iterator.hasNext()) {
            action.run((Display)iterator.next());
        }
    }

    public String toString() {
        return "NEWT-Display[" + this.name + ", refCount " + this.refCount + ", " + this.aDevice + "]";
    }

    protected abstract void dispatchMessages();

    public static interface Action {
        public void run(Display var1);
    }
}

