/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.windows.wgl.PIXELFORMATDESCRIPTOR;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WGLExt;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsWGLGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG;
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    private PIXELFORMATDESCRIPTOR pixelfmt;
    private int pixelfmtID;
    private boolean isChosen = false;
    private GLCapabilitiesChooser chooser;
    private boolean choosenByWGLPixelFormat = false;
    private static int haveWGLChoosePixelFormatARB;
    private static int haveWGLARBMultisample;
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilities gLCapabilities, GLCapabilities gLCapabilities2, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, (Capabilities)gLCapabilities, (Capabilities)gLCapabilities2);
        this.chooser = gLCapabilitiesChooser;
        this.pixelfmt = pIXELFORMATDESCRIPTOR;
        this.pixelfmtID = n;
    }

    public static WindowsWGLGraphicsConfiguration create(long l, int n, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl, boolean bl2) {
        if (n <= 0) {
            throw new GLException("Invalid pixelformat id " + n);
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault();
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (WGL.DescribePixelFormat(l, n, pIXELFORMATDESCRIPTOR.size(), pIXELFORMATDESCRIPTOR) == 0) {
            throw new GLException("Unable to describe pixel format " + n);
        }
        GLCapabilities gLCapabilities = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, pIXELFORMATDESCRIPTOR, bl, bl2);
        if (null == gLCapabilities) {
            throw new GLException("Couldn't choose Capabilities by: HDC 0x" + Long.toHexString(l) + ", pfdID " + n);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilities, gLCapabilities, pIXELFORMATDESCRIPTOR, n, new DefaultGLCapabilitiesChooser());
        windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilities, pIXELFORMATDESCRIPTOR, n, false);
        return windowsWGLGraphicsConfiguration;
    }

    public Object clone() {
        return super.clone();
    }

    protected void updateGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow) {
        WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(this.chooser, gLDrawableFactory, nativeWindow);
    }

    protected void updateCapabilitiesByWGL(GLContextImpl gLContextImpl) {
        GLDrawable gLDrawable;
        NativeWindow nativeWindow;
        long l;
        if (this.choosenByWGLPixelFormat) {
            return;
        }
        GLCapabilities gLCapabilities = (GLCapabilities)this.getRequestedCapabilities();
        boolean bl = gLCapabilities.isOnscreen();
        boolean bl2 = gLCapabilities.isPBuffer();
        GLProfile gLProfile = gLCapabilities.getGLProfile();
        WGLExt wGLExt = (WGLExt)gLContextImpl.getPlatformGLExtensions();
        GLCapabilities[] gLCapabilitiesArray = WindowsWGLGraphicsConfiguration.HDC2GLCapabilities(wGLExt, l = (nativeWindow = (gLDrawable = gLContextImpl.getGLDrawable()).getNativeWindow()).getSurfaceHandle(), this.getPixelFormatID(), gLProfile, true, bl, bl2);
        if (null != gLCapabilitiesArray && null != gLCapabilitiesArray[0]) {
            this.setCapsPFD(gLCapabilitiesArray[0], this.getPixelFormat(), this.getPixelFormatID(), true);
        }
    }

    protected void setCapsPFD(GLCapabilities gLCapabilities, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, int n, boolean bl) {
        this.pixelfmt = pIXELFORMATDESCRIPTOR;
        this.pixelfmtID = n;
        this.setChosenCapabilities(gLCapabilities);
        this.isChosen = true;
        this.choosenByWGLPixelFormat = bl;
        if (DEBUG) {
            System.err.println("*** setCapsPFD: WGL-Choosen " + bl + ", pfdID " + n + ", " + gLCapabilities);
        }
    }

    public boolean getCapabilitiesChosen() {
        return this.isChosen;
    }

    public PIXELFORMATDESCRIPTOR getPixelFormat() {
        return this.pixelfmt;
    }

    public int getPixelFormatID() {
        return this.pixelfmtID;
    }

    public boolean isChoosenByWGL() {
        return this.choosenByWGLPixelFormat;
    }

    public static GLCapabilities[] HDC2GLCapabilities(WGLExt wGLExt, long l, int n, GLProfile gLProfile, boolean bl, boolean bl2, boolean bl3) {
        if (haveWGLChoosePixelFormatARB < 0) {
            int n2 = haveWGLChoosePixelFormatARB = wGLExt.isExtensionAvailable("WGL_ARB_pixel_format") ? 1 : 0;
        }
        if (haveWGLARBMultisample < 0) {
            int n3 = haveWGLARBMultisample = wGLExt.isExtensionAvailable("WGL_ARB_multisample") ? 1 : 0;
        }
        if (0 == haveWGLChoosePixelFormatARB) {
            return null;
        }
        GLCapabilities[] gLCapabilitiesArray = null;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        nArray[0] = 8192;
        if (wGLExt.wglGetPixelFormatAttribivARB(l, 0, 0, 1, nArray, 0, nArray2, 0)) {
            n4 = nArray2[0];
            if (DEBUG) {
                System.err.println("wglGetPixelFormatAttribivARB reported WGL_NUMBER_PIXEL_FORMATS = " + n4);
            }
            if (n > 0 && n > n4) {
                throw new GLException("Invalid pixelformat ID " + n + " (should be between 1 and " + n4 + ")");
            }
            nArray[n5++] = 8193;
            nArray[n5++] = 8195;
            nArray[n5++] = 8208;
            nArray[n5++] = 8226;
            nArray[n5++] = 8227;
            nArray[n5++] = 8209;
            nArray[n5++] = 8210;
            nArray[n5++] = 8211;
            nArray[n5++] = 8213;
            nArray[n5++] = 8215;
            nArray[n5++] = 8217;
            nArray[n5++] = 8219;
            nArray[n5++] = 8222;
            nArray[n5++] = 8223;
            nArray[n5++] = 8224;
            nArray[n5++] = 8225;
            if (1 == haveWGLARBMultisample) {
                nArray[n5++] = 8257;
                nArray[n5++] = 8258;
            }
            if (n > 0) {
                gLCapabilitiesArray = new GLCapabilities[1];
                if (!wGLExt.wglGetPixelFormatAttribivARB(l, n, 0, n5, nArray, 0, nArray2, 0)) {
                    throw new GLException("Error getting pixel format attributes for pixel format " + n + " of device context");
                }
                gLCapabilitiesArray[0] = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray, n5, nArray2, bl, bl2, bl3);
            } else {
                gLCapabilitiesArray = new GLCapabilities[n4];
                for (int i = 0; i < n4; ++i) {
                    if (!wGLExt.wglGetPixelFormatAttribivARB(l, i + 1, 0, n5, nArray, 0, nArray2, 0)) {
                        throw new GLException("Error getting pixel format attributes for pixel format " + (i + 1) + " of device context");
                    }
                    gLCapabilitiesArray[i] = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray, n5, nArray2, bl, bl2, bl3);
                }
            }
        } else {
            long l2 = WGL.GetLastError();
            if (l2 != 0L) {
                throw new GLException("Unable to enumerate pixel formats of window using wglGetPixelFormatAttribivARB: error code " + WGL.GetLastError());
            }
        }
        return gLCapabilitiesArray;
    }

    public static boolean GLCapabilities2AttribList(GLCapabilities gLCapabilities, int[] nArray, WGLExt wGLExt, boolean bl, int[] nArray2) throws GLException {
        if (!wGLExt.isExtensionAvailable("WGL_ARB_pixel_format")) {
            return false;
        }
        int n = 0;
        nArray[n++] = 8208;
        nArray[n++] = 1;
        if (bl) {
            nArray[n++] = 8237;
            nArray[n++] = 1;
        } else {
            nArray[n++] = 8193;
            nArray[n++] = 1;
        }
        nArray[n++] = 8209;
        nArray[n++] = gLCapabilities.getDoubleBuffered() ? 1 : 0;
        nArray[n++] = 8210;
        nArray[n++] = gLCapabilities.getStereo() ? 1 : 0;
        nArray[n++] = 8226;
        nArray[n++] = gLCapabilities.getDepthBits();
        nArray[n++] = 8213;
        nArray[n++] = gLCapabilities.getRedBits();
        nArray[n++] = 8215;
        nArray[n++] = gLCapabilities.getGreenBits();
        nArray[n++] = 8217;
        nArray[n++] = gLCapabilities.getBlueBits();
        nArray[n++] = 8219;
        nArray[n++] = gLCapabilities.getAlphaBits();
        nArray[n++] = 8227;
        nArray[n++] = gLCapabilities.getStencilBits();
        if (gLCapabilities.getAccumRedBits() > 0 || gLCapabilities.getAccumGreenBits() > 0 || gLCapabilities.getAccumBlueBits() > 0 || gLCapabilities.getAccumAlphaBits() > 0) {
            nArray[n++] = 8221;
            nArray[n++] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
            nArray[n++] = 8222;
            nArray[n++] = gLCapabilities.getAccumRedBits();
            nArray[n++] = 8223;
            nArray[n++] = gLCapabilities.getAccumGreenBits();
            nArray[n++] = 8224;
            nArray[n++] = gLCapabilities.getAccumBlueBits();
            nArray[n++] = 8225;
            nArray[n++] = gLCapabilities.getAccumAlphaBits();
        }
        if (wGLExt.isExtensionAvailable("WGL_ARB_multisample") && gLCapabilities.getSampleBuffers()) {
            nArray[n++] = 8257;
            nArray[n++] = 1;
            nArray[n++] = 8258;
            nArray[n++] = gLCapabilities.getNumSamples();
        }
        boolean bl2 = gLCapabilities.getPbufferRenderToTexture();
        boolean bl3 = gLCapabilities.getPbufferRenderToTextureRectangle();
        boolean bl4 = gLCapabilities.getPbufferFloatingPointBuffers();
        boolean bl5 = false;
        if (bl) {
            if (bl3 && !bl2) {
                throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
            }
            if (bl3 && !wGLExt.isExtensionAvailable("GL_NV_texture_rectangle")) {
                throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
            }
            if (bl4) {
                if (!wGLExt.isExtensionAvailable("WGL_ATI_pixel_format_float") && !wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    throw new GLException("Floating-point pbuffers not supported by this hardware");
                }
                if (wGLExt.isExtensionAvailable("WGL_NV_float_buffer")) {
                    bl5 = false;
                    nArray2[0] = 3;
                } else {
                    bl5 = true;
                    nArray2[0] = 2;
                }
                if (DEBUG) {
                    System.err.println("Using " + (bl5 ? "ATI" : "NVidia") + " floating-point extension");
                }
            }
            if (bl4 && bl5) {
                if (bl2) {
                    throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
                }
                nArray[n++] = 8211;
                nArray[n++] = 8608;
            } else if (!bl2) {
                nArray[n++] = 8211;
                nArray[n++] = 8235;
            }
            if (bl4 && !bl5) {
                nArray[n++] = 8368;
                nArray[n++] = 1;
            }
            if (bl2) {
                if (bl4) {
                    if (!$assertionsDisabled && bl5) {
                        throw new AssertionError();
                    }
                    if (!bl3) {
                        throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                    }
                    nArray[n++] = 8371;
                    nArray[n++] = 1;
                } else {
                    nArray[n++] = bl3 ? 8352 : 8304;
                    nArray[n++] = 1;
                }
            }
        } else {
            nArray[n++] = 8211;
            nArray[n++] = 8235;
        }
        nArray[n++] = 0;
        return true;
    }

    public static int WGLConfig2DrawableTypeBits(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            switch (n3) {
                case 8193: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 1;
                    continue block5;
                }
                case 8194: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 2;
                    continue block5;
                }
                case 8237: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 4;
                }
            }
        }
        return n2;
    }

    public static boolean WGLConfigDrawableTypeVerify(int n, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl) {
            bl3 = 0 != (n & 1);
        } else {
            boolean bl4 = bl3 = 0 != (n & 2) || bl2;
        }
        if (bl2) {
            bl3 = bl3 && 0 != (n & 4);
        }
        return bl3;
    }

    public static GLCapabilities AttribList2GLCapabilities(GLProfile gLProfile, int[] nArray, int n, int[] nArray2, boolean bl, boolean bl2, boolean bl3) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        int n2 = WindowsWGLGraphicsConfiguration.WGLConfig2DrawableTypeBits(nArray, n, nArray2);
        if (WindowsWGLGraphicsConfiguration.WGLConfigDrawableTypeVerify(n2, bl2, bl3)) {
            gLCapabilities.setOnscreen(bl2);
            gLCapabilities.setPBuffer(bl3);
        } else if (bl) {
            gLCapabilities.setOnscreen(0 != (n2 & 1));
            gLCapabilities.setPBuffer(0 != (n2 & 4));
        } else {
            return null;
        }
        block21: for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            switch (n3) {
                case 8193: 
                case 8194: 
                case 8237: {
                    continue block21;
                }
                case 8195: {
                    gLCapabilities.setHardwareAccelerated(nArray2[i] == 8231);
                    continue block21;
                }
                case 8208: {
                    if (nArray2[i] == 1) continue block21;
                    return null;
                }
                case 8226: {
                    gLCapabilities.setDepthBits(nArray2[i]);
                    continue block21;
                }
                case 8227: {
                    gLCapabilities.setStencilBits(nArray2[i]);
                    continue block21;
                }
                case 8209: {
                    gLCapabilities.setDoubleBuffered(nArray2[i] == 1);
                    continue block21;
                }
                case 8210: {
                    gLCapabilities.setStereo(nArray2[i] == 1);
                    continue block21;
                }
                case 8211: {
                    if (nArray2[i] != 8235 && nArray2[i] != 8608) continue block21;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8368: {
                    if (nArray2[i] == 0) continue block21;
                    gLCapabilities.setPbufferFloatingPointBuffers(true);
                    continue block21;
                }
                case 8213: {
                    gLCapabilities.setRedBits(nArray2[i]);
                    continue block21;
                }
                case 8215: {
                    gLCapabilities.setGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8217: {
                    gLCapabilities.setBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8219: {
                    gLCapabilities.setAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8222: {
                    gLCapabilities.setAccumRedBits(nArray2[i]);
                    continue block21;
                }
                case 8223: {
                    gLCapabilities.setAccumGreenBits(nArray2[i]);
                    continue block21;
                }
                case 8224: {
                    gLCapabilities.setAccumBlueBits(nArray2[i]);
                    continue block21;
                }
                case 8225: {
                    gLCapabilities.setAccumAlphaBits(nArray2[i]);
                    continue block21;
                }
                case 8257: {
                    gLCapabilities.setSampleBuffers(nArray2[i] != 0);
                    continue block21;
                }
                case 8258: {
                    gLCapabilities.setNumSamples(nArray2[i]);
                    continue block21;
                }
                default: {
                    throw new GLException("Unknown pixel format attribute " + nArray[i]);
                }
            }
        }
        return gLCapabilities;
    }

    public static GLCapabilities PFD2GLCapabilities(GLProfile gLProfile, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR, boolean bl, boolean bl2) {
        if ((pIXELFORMATDESCRIPTOR.dwFlags() & 0x20) == 0) {
            return null;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(pIXELFORMATDESCRIPTOR.cRedBits());
        gLCapabilities.setGreenBits(pIXELFORMATDESCRIPTOR.cGreenBits());
        gLCapabilities.setBlueBits(pIXELFORMATDESCRIPTOR.cBlueBits());
        gLCapabilities.setAlphaBits(pIXELFORMATDESCRIPTOR.cAlphaBits());
        gLCapabilities.setAccumRedBits(pIXELFORMATDESCRIPTOR.cAccumRedBits());
        gLCapabilities.setAccumGreenBits(pIXELFORMATDESCRIPTOR.cAccumGreenBits());
        gLCapabilities.setAccumBlueBits(pIXELFORMATDESCRIPTOR.cAccumBlueBits());
        gLCapabilities.setAccumAlphaBits(pIXELFORMATDESCRIPTOR.cAccumAlphaBits());
        gLCapabilities.setDepthBits(pIXELFORMATDESCRIPTOR.cDepthBits());
        gLCapabilities.setStencilBits(pIXELFORMATDESCRIPTOR.cStencilBits());
        gLCapabilities.setDoubleBuffered((pIXELFORMATDESCRIPTOR.dwFlags() & 1) != 0);
        gLCapabilities.setStereo((pIXELFORMATDESCRIPTOR.dwFlags() & 2) != 0);
        gLCapabilities.setHardwareAccelerated((pIXELFORMATDESCRIPTOR.dwFlags() & 0x40) == 0 || (pIXELFORMATDESCRIPTOR.dwFlags() & 0x1000) != 0);
        gLCapabilities.setOnscreen(bl && (pIXELFORMATDESCRIPTOR.dwFlags() & 4) != 0);
        gLCapabilities.setPBuffer(bl2);
        return gLCapabilities;
    }

    public static PIXELFORMATDESCRIPTOR GLCapabilities2PFD(GLCapabilities gLCapabilities) {
        int n = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        int n2 = 4128;
        if (gLCapabilities.getDoubleBuffered()) {
            n2 |= 1;
        }
        n2 = gLCapabilities.isOnscreen() ? (n2 |= 4) : (n2 |= 8);
        if (gLCapabilities.getStereo()) {
            n2 |= 2;
        }
        pIXELFORMATDESCRIPTOR.dwFlags(n2);
        pIXELFORMATDESCRIPTOR.iPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.cColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.cRedBits((byte)gLCapabilities.getRedBits());
        pIXELFORMATDESCRIPTOR.cGreenBits((byte)gLCapabilities.getGreenBits());
        pIXELFORMATDESCRIPTOR.cBlueBits((byte)gLCapabilities.getBlueBits());
        pIXELFORMATDESCRIPTOR.cAlphaBits((byte)gLCapabilities.getAlphaBits());
        int n3 = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.cAccumBits((byte)n3);
        pIXELFORMATDESCRIPTOR.cAccumRedBits((byte)gLCapabilities.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.cAccumGreenBits((byte)gLCapabilities.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.cAccumBlueBits((byte)gLCapabilities.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.cAccumAlphaBits((byte)gLCapabilities.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.cDepthBits((byte)gLCapabilities.getDepthBits());
        pIXELFORMATDESCRIPTOR.cStencilBits((byte)gLCapabilities.getStencilBits());
        pIXELFORMATDESCRIPTOR.iLayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    public static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor() {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.nSize((short)pIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.nVersion((short)1);
        return pIXELFORMATDESCRIPTOR;
    }

    public String toString() {
        return "WindowsWGLGraphicsConfiguration[" + this.getScreen() + ", pfdID " + this.pixelfmtID + ", wglChoosen " + this.choosenByWGLPixelFormat + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }

    static {
        $assertionsDisabled = !WindowsWGLGraphicsConfiguration.class.desiredAssertionStatus();
        DEBUG = Debug.debug("GraphicsConfiguration");
        haveWGLChoosePixelFormatARB = -1;
        haveWGLARBMultisample = -1;
    }
}

