/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11.glx;

import com.sun.nativewindow.impl.NullWindow;
import com.sun.opengl.impl.x11.glx.GLX;
import com.sun.opengl.impl.x11.glx.X11GLXDrawable;
import com.sun.opengl.impl.x11.glx.X11GLXGraphicsConfiguration;
import com.sun.opengl.impl.x11.glx.X11GLXGraphicsConfigurationFactory;
import com.sun.opengl.impl.x11.glx.X11PbufferGLXContext;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class X11PbufferGLXDrawable
extends X11GLXDrawable {
    protected X11PbufferGLXDrawable(GLDrawableFactory gLDrawableFactory, AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        super(gLDrawableFactory, (NativeWindow)new NullWindow((AbstractGraphicsConfiguration)X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilities, gLCapabilitiesChooser, abstractGraphicsScreen, false, true)), true);
        if (n <= 0 || n2 <= 0) {
            throw new GLException("Width and height of pbuffer must be positive (were (" + n + ", " + n2 + "))");
        }
        NullWindow nullWindow = (NullWindow)this.getNativeWindow();
        nullWindow.setSize(n, n2);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.createPbuffer();
    }

    public GLContext createContext(GLContext gLContext) {
        return new X11PbufferGLXContext(this, gLContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.getFactoryImpl().lockToolkit();
        try {
            NullWindow nullWindow = (NullWindow)this.getNativeWindow();
            if (nullWindow.getSurfaceHandle() != 0L) {
                GLX.glXDestroyPbuffer(nullWindow.getDisplayHandle(), nullWindow.getSurfaceHandle());
            }
            nullWindow.invalidate();
        }
        finally {
            this.getFactoryImpl().unlockToolkit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPbuffer() {
        this.getFactoryImpl().lockToolkit();
        try {
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            AbstractGraphicsScreen abstractGraphicsScreen = x11GLXGraphicsConfiguration.getScreen();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
            long l = abstractGraphicsDevice.getHandle();
            int n = abstractGraphicsScreen.getIndex();
            if (l == 0L) {
                throw new GLException("Null display");
            }
            NullWindow nullWindow = (NullWindow)this.getNativeWindow();
            GLCapabilities gLCapabilities = (GLCapabilities)x11GLXGraphicsConfiguration.getChosenCapabilities();
            if (gLCapabilities.getPbufferRenderToTexture()) {
                throw new GLException("Render-to-texture pbuffers not supported yet on X11");
            }
            if (gLCapabilities.getPbufferRenderToTextureRectangle()) {
                throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
            }
            int n2 = 0;
            int[] nArray = new int[5];
            nArray[n2++] = 32833;
            nArray[n2++] = nullWindow.getWidth();
            nArray[n2++] = 32832;
            nArray[n2++] = nullWindow.getHeight();
            nArray[n2++] = 0;
            long l2 = GLX.glXCreatePbuffer(l, x11GLXGraphicsConfiguration.getFBConfig(), nArray, 0);
            if (l2 == 0L) {
                throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
            }
            nullWindow.setSurfaceHandle(l2);
            int[] nArray2 = new int[1];
            GLX.glXQueryDrawable(l, l2, 32797, nArray2, 0);
            int n3 = nArray2[0];
            GLX.glXQueryDrawable(l, l2, 32798, nArray2, 0);
            int n4 = nArray2[0];
            nullWindow.setSize(n3, n4);
            if (DEBUG) {
                System.err.println("Created pbuffer " + n3 + " x " + n4);
            }
        }
        finally {
            this.getFactoryImpl().unlockToolkit();
        }
    }

    public int getFloatingPointMode() {
        return 3;
    }

    protected void swapBuffersImpl() {
    }
}

