/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.awt;

import com.sun.opengl.util.texture.TextureData;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class AWTTextureData
extends TextureData {
    private BufferedImage imageForLazyCustomConversion;
    private boolean expectingEXTABGR;
    private boolean expectingGL12;
    private static final ColorModel rgbaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel rgbColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public AWTTextureData(int n, int n2, boolean bl, BufferedImage bufferedImage) {
        this.internalFormat = n == 0 ? (bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407) : n;
        this.createFromImage(bufferedImage);
        this.mipmap = bl;
        if (this.buffer != null) {
            this.estimatedMemorySize = AWTTextureData.estimatedMemorySize(this.buffer);
        } else if (this.imageForLazyCustomConversion != null) {
            this.estimatedMemorySize = AWTTextureData.estimatedMemorySize(this.wrapImageDataBuffer(this.imageForLazyCustomConversion));
        }
    }

    public int getPixelFormat() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
        }
        return this.pixelFormat;
    }

    public int getPixelType() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
        }
        return this.pixelType;
    }

    public Buffer getBuffer() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
            this.createFromCustom(this.imageForLazyCustomConversion);
        }
        return this.buffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createFromImage(BufferedImage bufferedImage) {
        int n;
        this.pixelType = 0;
        this.mustFlipVertically = true;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            n = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        } else {
            if (!(sampleModel instanceof ComponentSampleModel)) {
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
            n = ((ComponentSampleModel)sampleModel).getScanlineStride();
        }
        GLProfile gLProfile = GLContext.getCurrentGL().getGLProfile();
        if (gLProfile.isGL2()) {
            switch (bufferedImage.getType()) {
                case 1: {
                    this.pixelFormat = 32993;
                    this.pixelType = 33639;
                    this.rowLength = n;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 3: {
                    this.pixelFormat = 32993;
                    this.pixelType = 33639;
                    this.rowLength = n;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 4: {
                    this.pixelFormat = 6408;
                    this.pixelType = 33639;
                    this.rowLength = n;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 5: {
                    if (n % 3 != 0) {
                        this.setupLazyCustomConversion(bufferedImage);
                        return;
                    }
                    this.pixelFormat = 32992;
                    this.pixelType = 5121;
                    this.rowLength = n / 3;
                    this.alignment = 1;
                    break;
                }
                case 7: {
                    if (n % 4 == 0) {
                        // empty if block
                    }
                    this.setupLazyCustomConversion(bufferedImage);
                    return;
                }
                case 8: {
                    this.pixelFormat = 6407;
                    this.pixelType = 33635;
                    this.rowLength = n;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 9: {
                    this.pixelFormat = 32993;
                    this.pixelType = 33638;
                    this.rowLength = n;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 10: {
                    this.pixelFormat = 6409;
                    this.pixelType = 5121;
                    this.rowLength = n;
                    this.alignment = 1;
                    break;
                }
                case 11: {
                    this.pixelFormat = 6409;
                    this.pixelType = 5123;
                    this.rowLength = n;
                    this.alignment = 2;
                    break;
                }
                default: {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    if (colorModel.equals(rgbColorModel)) {
                        this.pixelFormat = 6407;
                        this.pixelType = 5121;
                        this.rowLength = n / 3;
                        this.alignment = 1;
                        break;
                    }
                    if (!colorModel.equals(rgbaColorModel)) {
                        this.setupLazyCustomConversion(bufferedImage);
                        return;
                    }
                    this.pixelFormat = 6408;
                    this.pixelType = 5121;
                    this.rowLength = n / 4;
                    this.alignment = 4;
                    break;
                }
            }
        } else {
            switch (bufferedImage.getType()) {
                case 1: {
                    this.pixelFormat = 6407;
                    this.pixelType = 5121;
                    this.rowLength = n;
                    this.alignment = 3;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 3: {
                    throw new GLException("INT_ARGB_PRE n.a.");
                }
                case 4: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 5: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 7: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 8: {
                    this.pixelFormat = 6407;
                    this.pixelType = 33635;
                    this.rowLength = n;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 9: {
                    this.pixelFormat = 6408;
                    this.pixelType = 32820;
                    this.rowLength = n;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 10: {
                    this.pixelFormat = 6409;
                    this.pixelType = 5121;
                    this.rowLength = n;
                    this.alignment = 1;
                    break;
                }
                case 11: {
                    throw new GLException("USHORT_GRAY n.a.");
                }
                default: {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    if (colorModel.equals(rgbColorModel)) {
                        this.pixelFormat = 6407;
                        this.pixelType = 5121;
                        this.rowLength = n / 3;
                        this.alignment = 1;
                        break;
                    }
                    if (!colorModel.equals(rgbaColorModel)) {
                        this.setupLazyCustomConversion(bufferedImage);
                        return;
                    }
                    this.pixelFormat = 6408;
                    this.pixelType = 5121;
                    this.rowLength = n / 4;
                    this.alignment = 4;
                    break;
                }
            }
        }
        this.createNIOBufferFromImage(bufferedImage);
    }

    private void setupLazyCustomConversion(BufferedImage bufferedImage) {
        this.imageForLazyCustomConversion = bufferedImage;
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        if (this.pixelFormat == 0) {
            this.pixelFormat = bl ? 6408 : 6407;
        }
        this.alignment = 1;
        this.rowLength = this.width;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte || this.isPackedInt(bufferedImage)) {
            if (this.pixelType == 0) {
                this.pixelType = 5121;
            }
        } else {
            if (dataBuffer instanceof DataBufferDouble) {
                throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
            }
            if (dataBuffer instanceof DataBufferFloat) {
                if (this.pixelType == 0) {
                    this.pixelType = 5126;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                if (this.pixelType == 0) {
                    this.pixelType = 5125;
                }
            } else if (dataBuffer instanceof DataBufferShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5122;
                }
            } else if (dataBuffer instanceof DataBufferUShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5123;
                }
            } else {
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
        }
    }

    private void createFromCustom(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        ColorModel colorModel = null;
        int n3 = bufferedImage.getRaster().getDataBuffer().getDataType();
        if (this.isPackedInt(bufferedImage)) {
            n3 = 0;
        }
        colorModel = n3 == 0 ? (bl ? rgbaColorModel : rgbColorModel) : (bl ? new ComponentColorModel(ColorSpace.getInstance(1000), null, true, true, 3, n3) : new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, n3));
        boolean bl2 = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.createNIOBufferFromImage(bufferedImage2);
    }

    private boolean isPackedInt(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        return n == 1 || n == 4 || n == 2 || n == 3;
    }

    private void revertPixelFormatAndType() {
        this.pixelFormat = 0;
        this.pixelType = 0;
        this.setupLazyCustomConversion(this.imageForLazyCustomConversion);
    }

    private void createNIOBufferFromImage(BufferedImage bufferedImage) {
        this.buffer = this.wrapImageDataBuffer(bufferedImage);
    }

    private Buffer wrapImageDataBuffer(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            return ByteBuffer.wrap(((DataBufferByte)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferDouble) {
            throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
        }
        if (dataBuffer instanceof DataBufferFloat) {
            return FloatBuffer.wrap(((DataBufferFloat)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferInt) {
            return IntBuffer.wrap(((DataBufferInt)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferShort) {
            return ShortBuffer.wrap(((DataBufferShort)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferUShort) {
            return ShortBuffer.wrap(((DataBufferUShort)dataBuffer).getData());
        }
        throw new RuntimeException("Unexpected DataBuffer type?");
    }
}

