/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;

public class GLDrawableHelper {
    private volatile List listeners = new ArrayList();
    private static final boolean DEBUG = Debug.debug("GLDrawableHelper");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean NVIDIA_CRASH_WORKAROUND = Debug.isPropertyDefined("jogl.nvidia.crash.workaround", true);
    private boolean autoSwapBufferMode = true;
    private static final ThreadLocal perThreadInitAction = new ThreadLocal();

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GLEventListeners num " + this.listeners.size() + " [");
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + ", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void addGLEventListener(GLEventListener gLEventListener) {
        List list = (List)((ArrayList)this.listeners).clone();
        list.add(gLEventListener);
        this.listeners = list;
    }

    public synchronized void removeGLEventListener(GLEventListener gLEventListener) {
        List list = (List)((ArrayList)this.listeners).clone();
        list.remove(gLEventListener);
        this.listeners = list;
    }

    public synchronized void dispose(GLAutoDrawable gLAutoDrawable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).dispose(gLAutoDrawable);
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).init(gLAutoDrawable);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).display(gLAutoDrawable);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).reshape(gLAutoDrawable, n, n2, n3, n4);
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        int n;
        if (null == gLContext) {
            if (DEBUG) {
                GLException gLException = new GLException(Thread.currentThread().getName() + " GLDrawableHelper " + this + ".invokeGL(): NULL GLContext");
                gLException.printStackTrace();
            }
            return;
        }
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = (Runnable)perThreadInitAction.get();
        if (gLContext2 != null) {
            gLContext2.release();
        }
        int n2 = 0;
        try {
            n2 = gLContext.makeCurrent();
            if (n2 != 0) {
                if (null != runnable2) {
                    perThreadInitAction.set(runnable2);
                    if (n2 == 2) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                }
                if (null != runnable) {
                    if (DEBUG && VERBOSE) {
                        System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running runnable");
                    }
                    runnable.run();
                    if (this.autoSwapBufferMode && gLDrawable != null) {
                        gLDrawable.swapBuffers();
                    }
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            int n3;
            Object var9_10 = null;
            try {
                if (n2 != 0) {
                    gLContext.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (gLContext2 != null && (n3 = gLContext2.makeCurrent()) == 2) {
                runnable3.run();
            }
            throw throwable;
        }
        try {
            if (n2 != 0) {
                gLContext.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gLContext2 != null && (n = gLContext2.makeCurrent()) == 2) {
            runnable3.run();
        }
    }
}

