/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt;

import com.sun.javafx.newt.Display;
import com.sun.javafx.newt.impl.Debug;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.media.nativewindow.AbstractGraphicsScreen;

public abstract class Screen {
    protected Display display;
    protected AbstractGraphicsScreen aScreen;
    protected int width = -1;
    protected int height = -1;
    protected static int usrWidth = -1;
    protected static int usrHeight = -1;
    private static AccessControlContext localACC = AccessController.getContext();

    private static Class getScreenClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if ("EGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.kd.KDScreen");
        } else if ("Windows".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.windows.WindowsScreen");
        } else if ("MacOSX".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.macosx.MacScreen");
        } else if ("X11".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.x11.X11Screen");
        } else if ("AWT".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.awt.AWTScreen");
        } else if ("BroadcomEGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.broadcom.BCEGLScreen");
        } else {
            throw new RuntimeException("Unknown window type \"" + string + "\"");
        }
        return clazz;
    }

    protected static Screen create(String string, Display display, int n) {
        try {
            if (usrWidth < 0 || usrHeight < 0) {
                usrWidth = Debug.getIntProperty("newt.ws.swidth", true, localACC);
                usrHeight = Debug.getIntProperty("newt.ws.sheight", true, localACC);
                System.out.println("User screen size " + usrWidth + "x" + usrHeight);
            }
            Class clazz = Screen.getScreenClass(string);
            Screen screen = (Screen)clazz.newInstance();
            screen.display = display;
            screen.createNative(n);
            if (null == screen.aScreen) {
                throw new RuntimeException("Screen.createNative() failed to instanciate an AbstractGraphicsScreen");
            }
            return screen;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized void destroy() {
        this.closeNative();
    }

    protected static Screen wrapHandle(String string, Display display, AbstractGraphicsScreen abstractGraphicsScreen) {
        try {
            Class clazz = Screen.getScreenClass(string);
            Screen screen = (Screen)clazz.newInstance();
            screen.display = display;
            screen.aScreen = abstractGraphicsScreen;
            return screen;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract void createNative(int var1);

    protected abstract void closeNative();

    protected void setScreenSize(int n, int n2) {
        System.out.println("Detected screen size " + n + "x" + n2);
        this.width = n;
        this.height = n2;
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getIndex() {
        return this.aScreen.getIndex();
    }

    public AbstractGraphicsScreen getGraphicsScreen() {
        return this.aScreen;
    }

    public int getWidth() {
        return usrWidth > 0 ? usrWidth : (this.width > 0 ? this.width : 480);
    }

    public int getHeight() {
        return usrHeight > 0 ? usrHeight : (this.height > 0 ? this.height : 480);
    }
}

