/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.BufferUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StreamUtil {
    private StreamUtil() {
    }

    public static byte[] readAll2Array(InputStream inputStream) throws IOException {
        BytesRead bytesRead = StreamUtil.readAllImpl(inputStream);
        byte[] byArray = bytesRead.data;
        if (bytesRead.payloadLen != byArray.length) {
            byArray = new byte[bytesRead.payloadLen];
            System.arraycopy(bytesRead.data, 0, byArray, 0, bytesRead.payloadLen);
        }
        return byArray;
    }

    public static ByteBuffer readAll2Buffer(InputStream inputStream) throws IOException {
        BytesRead bytesRead = StreamUtil.readAllImpl(inputStream);
        return BufferUtil.newByteBuffer(bytesRead.data, 0, bytesRead.payloadLen);
    }

    private static BytesRead readAllImpl(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        do {
            if (n3 + n > byArray.length) {
                byte[] byArray2 = new byte[n3 + n];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
            }
            if ((n2 = inputStream.read(byArray, n3, n)) < 0) continue;
            n3 += n2;
        } while ((n = inputStream.available()) > 0 && n2 >= 0);
        return new BytesRead(n3, byArray);
    }

    private static class BytesRead {
        int payloadLen;
        byte[] data;

        BytesRead(int n, byte[] byArray) {
            this.payloadLen = n;
            this.data = byArray;
        }
    }
}

