/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.nativewindow.impl.NullWindow;
import com.sun.opengl.impl.windows.wgl.BITMAPINFO;
import com.sun.opengl.impl.windows.wgl.BITMAPINFOHEADER;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WindowsOffscreenWGLContext;
import com.sun.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class WindowsOffscreenWGLDrawable
extends WindowsWGLDrawable {
    private long origbitmap;
    private long hbitmap;

    public WindowsOffscreenWGLDrawable(GLDrawableFactory gLDrawableFactory, AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        super(gLDrawableFactory, (NativeWindow)new NullWindow((AbstractGraphicsConfiguration)WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilities, (CapabilitiesChooser)gLCapabilitiesChooser, abstractGraphicsScreen, false, false)), true);
        ((NullWindow)this.getNativeWindow()).setSize(n, n2);
        this.create();
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsOffscreenWGLContext(this, gLContext);
    }

    private void create() {
        NullWindow nullWindow = (NullWindow)this.getNativeWindow();
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nullWindow.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilities gLCapabilities = (GLCapabilities)windowsWGLGraphicsConfiguration.getRequestedCapabilities();
        int n = this.getWidth();
        int n2 = this.getHeight();
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.bmiHeader();
        int n3 = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        bITMAPINFOHEADER.biSize(bITMAPINFOHEADER.size());
        bITMAPINFOHEADER.biWidth(n);
        bITMAPINFOHEADER.biHeight(-1 * n2);
        bITMAPINFOHEADER.biPlanes((short)1);
        bITMAPINFOHEADER.biBitCount((short)n3);
        bITMAPINFOHEADER.biXPelsPerMeter(0L);
        bITMAPINFOHEADER.biYPelsPerMeter(0L);
        bITMAPINFOHEADER.biClrUsed(0);
        bITMAPINFOHEADER.biClrImportant(0);
        bITMAPINFOHEADER.biCompression(0);
        bITMAPINFOHEADER.biSizeImage(n * n2 * n3 / 8);
        long l = WGL.CreateCompatibleDC(0L);
        if (l == 0L) {
            System.out.println("LastError: " + WGL.GetLastError());
            throw new GLException("Error creating device context for offscreen OpenGL context");
        }
        nullWindow.setSurfaceHandle(l);
        this.hbitmap = WGL.CreateDIBSection(l, bITMAPINFO, 0, 0L, 0L, 0);
        if (this.hbitmap == 0L) {
            WGL.DeleteDC(l);
            l = 0L;
            throw new GLException("Error creating offscreen bitmap of width " + n + ", height " + n2);
        }
        this.origbitmap = WGL.SelectObject(l, this.hbitmap);
        if (this.origbitmap == 0L) {
            WGL.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            WGL.DeleteDC(l);
            l = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), (NativeWindow)nullWindow);
    }

    public void destroy() {
        NullWindow nullWindow = (NullWindow)this.getNativeWindow();
        if (nullWindow.getSurfaceHandle() != 0L) {
            WGL.SelectObject(nullWindow.getSurfaceHandle(), this.origbitmap);
            WGL.DeleteObject(this.hbitmap);
            WGL.DeleteDC(nullWindow.getSurfaceHandle());
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            nullWindow.setSurfaceHandle(0L);
        }
    }

    protected void swapBuffersImpl() {
    }
}

