/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.opengl.kd;

import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.opengl.kd.KDDisplay;
import com.sun.javafx.newt.opengl.kd.KDScreen;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.opengl.GLCapabilities;

public class KDWindow
extends Window {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private long eglWindowHandle;
    private long windowHandleClose;
    private long windowUserData;

    protected void createNative(long l, Capabilities capabilities) {
        if (0L != l) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDisplay().getGraphicsDevice()).chooseGraphicsConfiguration(capabilities, null, this.getScreen().getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        GLCapabilities gLCapabilities = (GLCapabilities)this.config.getChosenCapabilities();
        int[] nArray = EGLGraphicsConfiguration.GLCapabilities2AttribList((GLCapabilities)gLCapabilities, (int)4);
        this.windowHandle = 0L;
        this.eglWindowHandle = this.CreateWindow(this.getDisplayHandle(), nArray);
        if (this.eglWindowHandle == 0L) {
            throw new NativeWindowException("Error creating egl window: " + this.config);
        }
        this.setVisible0(this.eglWindowHandle, false);
        this.windowHandleClose = this.eglWindowHandle;
    }

    protected void closeNative() {
        if (0L != this.windowHandleClose) {
            this.CloseWindow(this.windowHandleClose, this.windowUserData);
            this.windowUserData = 0L;
        }
    }

    public void setVisible(boolean bl) {
        if (0L != this.eglWindowHandle && this.visible != bl) {
            this.visible = bl;
            this.setVisible0(this.eglWindowHandle, bl);
            if (0L == this.windowHandle) {
                this.windowHandle = this.RealizeWindow(this.eglWindowHandle);
                if (0L == this.windowHandle) {
                    throw new NativeWindowException("Error native Window Handle is null");
                }
            }
            this.clearEventMask();
        }
    }

    public void setSize(int n, int n2) {
        if (0L != this.eglWindowHandle) {
            this.setSize0(this.eglWindowHandle, n, n2);
        }
    }

    public void setPosition(int n, int n2) {
        System.err.println("setPosition n/a in KD");
    }

    public boolean setFullscreen(boolean bl) {
        if (0L != this.eglWindowHandle && this.fullscreen != bl) {
            this.fullscreen = bl;
            if (this.fullscreen) {
                this.setFullScreen0(this.eglWindowHandle, true);
            } else {
                this.setFullScreen0(this.eglWindowHandle, false);
                this.setSize0(this.eglWindowHandle, this.nfs_width, this.nfs_height);
            }
        }
        return true;
    }

    protected static native boolean initIDs();

    private native long CreateWindow(long var1, int[] var3);

    private native long RealizeWindow(long var1);

    private native int CloseWindow(long var1, long var3);

    private native void setVisible0(long var1, boolean var3);

    private native void setSize0(long var1, int var3, int var4);

    private native void setFullScreen0(long var1, boolean var3);

    private void windowCreated(long l) {
        this.windowUserData = l;
    }

    private void sizeChanged(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (!this.fullscreen) {
            this.nfs_width = this.width;
            this.nfs_height = this.height;
        } else {
            ((KDScreen)this.screen).setScreenSize(this.width, this.height);
        }
        this.sendWindowEvent(100);
    }

    static {
        KDDisplay.initSingleton();
    }
}

