/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLBufferSizeTracker;
import com.sun.opengl.impl.GLContextImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.media.opengl.GLContext;

public class GLContextShareSet {
    private static final boolean DEBUG;
    private static Map shareMap;
    private static Object dummyValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized void registerSharing(GLContext gLContext, GLContext gLContext2) {
        if (gLContext == null || gLContext2 == null) {
            throw new IllegalArgumentException("Both share1 and share2 must be non-null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            shareSet = GLContextShareSet.entryFor(gLContext2);
        }
        if (shareSet == null) {
            shareSet = new ShareSet();
        }
        shareSet.add(gLContext);
        shareSet.add(gLContext2);
        GLContextShareSet.addEntry(gLContext, shareSet);
        GLContextShareSet.addEntry(gLContext2, shareSet);
    }

    public static synchronized GLContext getShareContext(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            return null;
        }
        return shareSet.getCreatedShare(gLContext);
    }

    public static synchronized void contextCreated(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextCreated(gLContext);
        }
    }

    public static synchronized void contextDestroyed(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextDestroyed(gLContext);
        }
    }

    public static void registerForBufferObjectSharing(GLContext gLContext, GLContext gLContext2) {
        GLContextImpl gLContextImpl = (GLContextImpl)gLContext;
        GLContextImpl gLContextImpl2 = (GLContextImpl)gLContext2;
        GLBufferSizeTracker gLBufferSizeTracker = null;
        if (gLContextImpl != null) {
            gLBufferSizeTracker = gLContextImpl.getBufferSizeTracker();
            if (!$assertionsDisabled && gLBufferSizeTracker == null) {
                throw new AssertionError((Object)"registerForBufferObjectSharing was not called properly for the older context, or has a bug in it");
            }
        }
        if (gLBufferSizeTracker == null) {
            gLBufferSizeTracker = new GLBufferSizeTracker();
        }
        gLContextImpl2.setBufferSizeTracker(gLBufferSizeTracker);
    }

    private static ShareSet entryFor(GLContext gLContext) {
        return (ShareSet)shareMap.get(gLContext);
    }

    private static void addEntry(GLContext gLContext, ShareSet shareSet) {
        if (shareMap.get(gLContext) == null) {
            shareMap.put(gLContext, shareSet);
        }
    }

    static {
        $assertionsDisabled = !GLContextShareSet.class.desiredAssertionStatus();
        DEBUG = Debug.debug("GLContextShareSet");
        shareMap = new WeakHashMap();
        dummyValue = new Object();
    }

    private static class ShareSet {
        private Map allShares = new WeakHashMap();
        private Map createdShares = new WeakHashMap();
        private Map destroyedShares = new WeakHashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        private ShareSet() {
        }

        public void add(GLContext gLContext) {
            if (this.allShares.put(gLContext, dummyValue) == null) {
                if (((GLContextImpl)gLContext).isCreated()) {
                    this.createdShares.put(gLContext, dummyValue);
                } else {
                    this.destroyedShares.put(gLContext, dummyValue);
                }
            }
        }

        public GLContext getCreatedShare(GLContext gLContext) {
            Iterator iterator = this.createdShares.keySet().iterator();
            while (iterator.hasNext()) {
                GLContext gLContext2 = (GLContext)iterator.next();
                if (gLContext2 == gLContext) continue;
                return gLContext2;
            }
            return null;
        }

        public void contextCreated(GLContext gLContext) {
            Object object = this.destroyedShares.remove(gLContext);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " should have been in destroyed set but wasn't"));
            }
            object = this.createdShares.put(gLContext, dummyValue);
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " shouldn't have been in created set but was"));
            }
        }

        public void contextDestroyed(GLContext gLContext) {
            Object object = this.createdShares.remove(gLContext);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " should have been in created set but wasn't"));
            }
            object = this.destroyedShares.put(gLContext, dummyValue);
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError((Object)("State of ShareSet corrupted; thought context " + gLContext + " shouldn't have been in destroyed set but was"));
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$opengl$impl$GLContextShareSet == null ? (class$com$sun$opengl$impl$GLContextShareSet = GLContextShareSet.class$("com.sun.opengl.impl.GLContextShareSet")) : class$com$sun$opengl$impl$GLContextShareSet).desiredAssertionStatus();
        }
    }
}

