/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class InternalBufferUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;
    private static boolean isCDCFP;
    private static Class byteOrderClass;
    private static Object nativeOrderObject;
    private static Method orderMethod;

    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        InternalBufferUtil.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(n * 8);
        return byteBuffer.asDoubleBuffer();
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(n * 4);
        return byteBuffer.asIntBuffer();
    }

    public static ShortBuffer newShortBuffer(int n) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(n * 2);
        return byteBuffer.asShortBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(n * 4);
        return byteBuffer.asFloatBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        ByteBuffer byteBuffer = InternalBufferUtil.newByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = InternalBufferUtil.newByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static float[] getFloatArray(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n--];
        while (n >= 0) {
            fArray[n] = (float)dArray[n];
            --n;
        }
        return fArray;
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        if (!isCDCFP) {
            try {
                if (byteOrderClass == null) {
                    byteOrderClass = Class.forName("java.nio.ByteOrder");
                    orderMethod = ByteBuffer.class.getMethod("order", byteOrderClass);
                    Method method = byteOrderClass.getMethod("nativeOrder", null);
                    nativeOrderObject = method.invoke(null, null);
                }
            }
            catch (Throwable throwable) {
                isCDCFP = true;
            }
            if (!isCDCFP) {
                try {
                    orderMethod.invoke((Object)byteBuffer, nativeOrderObject);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return byteBuffer;
    }
}

