/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.egl;

import com.sun.gluegen.runtime.ProcAddressTable;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.egl.EGL;
import com.sun.opengl.impl.egl.EGLDrawable;
import com.sun.opengl.impl.egl.EGLExt;
import com.sun.opengl.impl.egl.EGLExtImpl;
import com.sun.opengl.impl.egl.EGLExtProcAddressTable;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import com.sun.opengl.impl.egl._EGLConfig;
import java.nio.ByteBuffer;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class EGLContext
extends GLContextImpl {
    protected EGLDrawable drawable;
    private long eglContext;
    private boolean eglQueryStringInitialized;
    private boolean eglQueryStringAvailable;
    private EGLExt eglExt;
    private EGLExtProcAddressTable eglExtProcAddressTable;

    public EGLContext(EGLDrawable eGLDrawable, GLContext gLContext) {
        super(eGLDrawable.getGLProfile(), gLContext);
        this.drawable = eGLDrawable;
    }

    public Object getPlatformGLExtensions() {
        return this.getEGLExt();
    }

    public EGLExt getEGLExt() {
        if (this.eglExt == null) {
            this.eglExt = new EGLExtImpl(this);
        }
        return this.eglExt;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    public final EGLExtProcAddressTable getEGLExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    public long getContext() {
        return this.eglContext;
    }

    protected int makeCurrentImpl() throws GLException {
        if (0L == this.drawable.getDisplay()) {
            System.err.println("drawable not properly initialized");
            return 0;
        }
        boolean bl = false;
        if (this.eglContext == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": !!! Created GL context 0x" + Long.toHexString(this.eglContext) + " for " + this.getClass().getName());
            }
            bl = true;
        }
        if (EGL.eglGetCurrentContext() != this.eglContext && !EGL.eglMakeCurrent(this.drawable.getDisplay(), this.drawable.getSurface(), this.drawable.getSurface(), this.eglContext)) {
            throw new GLException("Error making context 0x" + Long.toHexString(this.eglContext) + " current: error code " + EGL.eglGetError());
        }
        if (bl) {
            this.setGLFunctionAvailability(false);
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() throws GLException {
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            if (!EGL.eglMakeCurrent(this.drawable.getDisplay(), 0L, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context 0x" + Long.toHexString(this.eglContext) + ": error code " + EGL.eglGetError());
            }
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() throws GLException {
        this.getDrawableImpl().getFactoryImpl().lockToolkit();
        try {
            if (this.eglContext != 0L) {
                if (!EGL.eglDestroyContext(this.drawable.getDisplay(), this.eglContext)) {
                    throw new GLException("Error destroying OpenGL context 0x" + Long.toHexString(this.eglContext) + ": error code " + EGL.eglGetError());
                }
                this.eglContext = 0L;
                GLContextShareSet.contextDestroyed(this);
            }
        }
        finally {
            this.getDrawableImpl().getFactoryImpl().unlockToolkit();
        }
    }

    protected void create() throws GLException {
        EGLContext eGLContext;
        long l;
        _EGLConfig _EGLConfig2;
        GLProfile gLProfile;
        long l2;
        block13: {
            l2 = this.drawable.getDisplay();
            EGLGraphicsConfiguration eGLGraphicsConfiguration = this.drawable.getGraphicsConfiguration();
            gLProfile = this.drawable.getGLProfile();
            _EGLConfig2 = eGLGraphicsConfiguration.getNativeConfig();
            l = 0L;
            if (l2 == 0L) {
                throw new GLException("Error: attempted to create an OpenGL context without a display connection");
            }
            if (_EGLConfig2 == null) {
                throw new GLException("Error: attempted to create an OpenGL context without a graphics configuration");
            }
            try {
                if (!EGL.eglBindAPI(12448)) {
                    throw new GLException("eglBindAPI to ES failed , error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block13;
                gLException.printStackTrace();
            }
        }
        if ((eGLContext = (EGLContext)GLContextShareSet.getShareContext(this)) != null && (l = eGLContext.getContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[]{12440, -1, 12344};
        if (gLProfile.usesNativeGLES2()) {
            nArray[1] = 2;
        } else if (gLProfile.usesNativeGLES1()) {
            nArray[1] = 1;
        } else {
            throw new GLException("Error creating OpenGL context - invalid GLProfile: " + gLProfile);
        }
        this.eglContext = EGL.eglCreateContext(l2, _EGLConfig2, l, nArray, 0);
        if (this.eglContext == 0L) {
            throw new GLException("Error creating OpenGL context: eglDisplay 0x" + Long.toHexString(l2) + ", " + gLProfile + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        GLContextShareSet.contextCreated(this);
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": !!! Created OpenGL context 0x" + Long.toHexString(this.eglContext) + " for " + this + ", surface 0x" + Long.toHexString(this.drawable.getSurface()) + ", sharing with 0x" + Long.toHexString(l));
        }
        if (!EGL.eglMakeCurrent(this.drawable.getDisplay(), this.drawable.getSurface(), this.drawable.getSurface(), this.eglContext)) {
            throw new GLException("Error making context 0x" + Long.toHexString(this.eglContext) + " current: error code " + EGL.eglGetError());
        }
        this.setGLFunctionAvailability(true);
    }

    public boolean isCreated() {
        return this.eglContext != 0L;
    }

    protected void updateGLProcAddressTable() {
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": !!! Initializing EGL extension address table");
        }
        if (this.eglExtProcAddressTable == null) {
            this.eglExtProcAddressTable = new EGLExtProcAddressTable();
        }
        this.resetProcAddressTable(this.getEGLExtProcAddressTable());
        super.updateGLProcAddressTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getPlatformExtensionsString() {
        if (!this.eglQueryStringInitialized) {
            this.eglQueryStringAvailable = this.getDrawableImpl().getDynamicLookupHelper().dynamicLookupFunction("eglQueryString") != 0L;
            this.eglQueryStringInitialized = true;
        }
        if (this.eglQueryStringAvailable) {
            GLDrawableFactoryImpl gLDrawableFactoryImpl = this.getDrawableImpl().getFactoryImpl();
            gLDrawableFactoryImpl.lockToolkit();
            try {
                String string = EGL.eglQueryString(this.drawable.getDisplay(), 12373);
                if (DEBUG) {
                    System.err.println("!!! EGL extensions: " + string);
                }
                String string2 = string;
                return string2;
            }
            finally {
                gLDrawableFactoryImpl.unlockToolkit();
            }
        }
        return "";
    }

    protected void setSwapIntervalImpl(int n) {
        if (EGL.eglSwapInterval(this.drawable.getDisplay(), n)) {
            this.currentSwapInterval = n;
        }
    }

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public void copy(GLContext gLContext, int n) throws GLException {
        throw new GLException("Not yet implemented");
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }
}

