/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.spi.DDSImage;
import com.sun.opengl.util.texture.spi.SGIImage;
import com.sun.opengl.util.texture.spi.TGAImage;
import com.sun.opengl.util.texture.spi.TextureProvider;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    private static final boolean DEBUG = Debug.debug((String)"TextureIO");
    private static boolean texRectEnabled = true;
    private static List textureProviders = new ArrayList();
    private static List textureWriters = new ArrayList();

    public static TextureData newTextureData(File file, boolean bl, String string) throws IOException {
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, 0, 0, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, boolean bl, String string) throws IOException {
        return TextureIO.newTextureDataImpl(inputStream, 0, 0, bl, string);
    }

    public static TextureData newTextureData(URL uRL, boolean bl, String string) throws IOException {
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, 0, 0, bl, string);
    }

    public static TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, n, n2, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(inputStream, n, n2, bl, string);
    }

    public static TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, n, n2, bl, string);
    }

    public static Texture newTexture(TextureData textureData) throws GLException, IllegalArgumentException {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(textureData);
    }

    public static Texture newTexture(File file, boolean bl) throws IOException, GLException {
        TextureData textureData = TextureIO.newTextureData(file, bl, FileUtil.getFileSuffix(file));
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(InputStream inputStream, boolean bl, String string) throws IOException, GLException {
        TextureData textureData = TextureIO.newTextureData(inputStream, bl, string);
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(URL uRL, boolean bl, String string) throws IOException, GLException {
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        TextureData textureData = TextureIO.newTextureData(uRL, bl, string);
        Texture texture = TextureIO.newTexture(textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(int n) throws GLException {
        return new Texture(n);
    }

    public static Texture newTexture(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return new Texture(n, n2, n3, n4, n5, n6, bl);
    }

    public static void write(Texture texture, File file) throws IOException, GLException {
        Object object;
        int n;
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLContext.getCurrentGL();
        if (!gL.isGL2()) {
            throw new GLException("Only GL2 supports fetching compressed images, GL: " + gL);
        }
        GL2 gL2 = gL.getGL2();
        texture.bind();
        int n2 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4099);
        int n3 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4096);
        int n4 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4097);
        int n5 = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 4101);
        TextureData textureData = null;
        if (n2 == 33776 || n2 == 33777 || n2 == 33778 || n2 == 33779) {
            n = TextureIO.glGetTexLevelParameteri(gL2, 3553, 0, 34464);
            object = ByteBuffer.wrap(new byte[n]);
            gL2.glGetCompressedTexImage(3553, 0, (Buffer)object);
            textureData = new TextureData(n2, n3, n4, n5, n2, 5121, false, true, true, (Buffer)object, null);
        } else {
            n = 0;
            int n6 = 0;
            switch (n2) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n = 3;
                    n6 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n = 4;
                    n6 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n2));
                }
            }
            int n7 = TextureIO.glGetInteger(3333);
            int n8 = TextureIO.glGetInteger(3330);
            int n9 = TextureIO.glGetInteger(3331);
            int n10 = TextureIO.glGetInteger(3332);
            int n11 = TextureIO.glGetInteger(3328);
            gL2.glPixelStorei(3333, 1);
            gL2.glPixelStorei(3330, 0);
            gL2.glPixelStorei(3331, 0);
            gL2.glPixelStorei(3332, 0);
            gL2.glPixelStorei(3328, 0);
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[(n3 + 2 * n5) * (n4 + 2 * n5) * n]);
            if (DEBUG) {
                System.out.println("Allocated buffer of size " + byteBuffer.remaining() + " for fetched image (" + (n6 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL2.glGetTexImage(3553, 0, n6, 5121, (Buffer)byteBuffer);
            gL2.glPixelStorei(3333, n7);
            gL2.glPixelStorei(3330, n8);
            gL2.glPixelStorei(3331, n9);
            gL2.glPixelStorei(3332, n10);
            gL2.glPixelStorei(3328, n11);
            textureData = new TextureData(n2, n3, n4, n5, n6, 5121, false, false, false, byteBuffer, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        Iterator iterator = textureWriters.iterator();
        while (iterator.hasNext()) {
            object = (TextureWriter)iterator.next();
            if (!object.write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found");
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        textureProviders.add(0, textureProvider);
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    public static void setTexRectEnabled(boolean bl) {
        texRectEnabled = bl;
    }

    public static boolean isTexRectEnabled() {
        return texRectEnabled;
    }

    private static TextureData newTextureDataImpl(File file, int n, int n2, boolean bl, String string) throws IOException {
        if (file == null) {
            throw new IOException("File was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(file, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given file");
    }

    private static TextureData newTextureDataImpl(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
        if (inputStream == null) {
            throw new IOException("Stream was null");
        }
        string = TextureIO.toLowerCase(string);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(inputStream, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureProvider textureProvider = (TextureProvider)iterator.next();
            TextureData textureData = textureProvider.newTextureData(uRL, n, n2, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given URL");
    }

    private static int glGetInteger(int n) {
        int[] nArray = new int[1];
        GL gL = GLContext.getCurrentGL();
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    private static int glGetTexLevelParameteri(GL2 gL2, int n, int n2, int n3) {
        int[] nArray = new int[1];
        gL2.glGetTexLevelParameteriv(n, 0, n3, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    static {
        TextureIO.addTextureProvider(new DDSTextureProvider());
        TextureIO.addTextureProvider(new SGITextureProvider());
        TextureIO.addTextureProvider(new TGATextureProvider());
        TextureIO.addTextureWriter(new DDSTextureWriter());
        TextureIO.addTextureWriter(new SGITextureWriter());
        TextureIO.addTextureWriter(new TGATextureWriter());
    }

    static class DDSTextureProvider
    implements TextureProvider {
        DDSTextureProvider() {
        }

        public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || TextureIO.DDS.equals(FileUtil.getFileSuffix(file))) {
                DDSImage dDSImage = DDSImage.read(file);
                return this.newTextureData(dDSImage, n, n2, bl);
            }
            return null;
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || DDSImage.isDDSImage(inputStream)) {
                DDSImage dDSImage = DDSImage.read(inputStream);
                return this.newTextureData(dDSImage, n, n2, bl);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        private TextureData newTextureData(final DDSImage dDSImage, int n, int n2, boolean bl) {
            TextureData textureData;
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(0);
            if (n2 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            if (imageInfo.isCompressed()) {
                switch (imageInfo.getCompressionFormat()) {
                    case 827611204: {
                        n = 33776;
                        break;
                    }
                    case 861165636: {
                        n = 33778;
                        break;
                    }
                    case 894720068: {
                        n = 33779;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(imageInfo.getCompressionFormat()) + "\"");
                    }
                }
            }
            if (n == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n2 = 6407;
                        break;
                    }
                    default: {
                        n2 = 6408;
                    }
                }
            }
            TextureData.Flusher flusher = new TextureData.Flusher(){

                public void flush() {
                    dDSImage.close();
                }
            };
            if (bl && dDSImage.getNumMipMaps() > 0) {
                Buffer[] bufferArray = new Buffer[dDSImage.getNumMipMaps()];
                for (int i = 0; i < dDSImage.getNumMipMaps(); ++i) {
                    bufferArray[i] = dDSImage.getMipMap(i).getData();
                }
                textureData = new TextureData(n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, imageInfo.isCompressed(), true, bufferArray, flusher);
            } else {
                bl = false;
                textureData = new TextureData(n, imageInfo.getWidth(), imageInfo.getHeight(), 0, n2, 5121, bl, imageInfo.isCompressed(), true, imageInfo.getData(), flusher);
            }
            return textureData;
        }
    }

    static class DDSTextureWriter
    implements TextureWriter {
        DDSTextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.DDS.equals(FileUtil.getFileSuffix(file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (n2 != 5120 && n2 != 5121) {
                    throw new IOException("DDS writer only supports byte / unsigned byte textures");
                }
                int n3 = 0;
                switch (n) {
                    case 6407: {
                        n3 = 20;
                        break;
                    }
                    case 6408: {
                        n3 = 21;
                        break;
                    }
                    case 33776: {
                        n3 = 827611204;
                        break;
                    }
                    case 33777: {
                        throw new IOException("RGBA DXT1 not yet supported");
                    }
                    case 33778: {
                        n3 = 861165636;
                        break;
                    }
                    case 33779: {
                        n3 = 894720068;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n) + " by DDS writer");
                    }
                }
                ByteBuffer[] byteBufferArray = null;
                if (textureData.getMipmapData() != null) {
                    byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                    for (int i = 0; i < byteBufferArray.length; ++i) {
                        byteBufferArray[i] = (ByteBuffer)textureData.getMipmapData()[i];
                    }
                } else {
                    byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
                }
                DDSImage dDSImage = DDSImage.createFromData(n3, textureData.getWidth(), textureData.getHeight(), byteBufferArray);
                dDSImage.write(file);
                return true;
            }
            return false;
        }
    }

    static class SGITextureProvider
    extends StreamBasedTextureProvider {
        SGITextureProvider() {
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string) || SGIImage.isSGIImage(inputStream)) {
                SGIImage sGIImage = SGIImage.read(inputStream);
                if (n2 == 0) {
                    n2 = sGIImage.getFormat();
                }
                if (n == 0) {
                    n = sGIImage.getFormat();
                }
                return new TextureData(n, sGIImage.getWidth(), sGIImage.getHeight(), 0, n2, 5121, bl, false, false, ByteBuffer.wrap(sGIImage.getData()), null);
            }
            return null;
        }
    }

    static class SGITextureWriter
    implements TextureWriter {
        SGITextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            String string = FileUtil.getFileSuffix(file);
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string)) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    byte[] byArray;
                    ByteBuffer byteBuffer;
                    ByteBuffer byteBuffer2 = byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byteBuffer.rewind();
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        byteBuffer.rewind();
                    }
                    SGIImage sGIImage = SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, byArray);
                    sGIImage.write(file, false);
                    return true;
                }
                throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }

    static abstract class StreamBasedTextureProvider
    implements TextureProvider {
        StreamBasedTextureProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string != null ? string : FileUtil.getFileSuffix(file));
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                TextureData textureData = this.newTextureData(bufferedInputStream, n, n2, bl, string);
                return textureData;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    static class TGATextureProvider
    extends StreamBasedTextureProvider {
        TGATextureProvider() {
        }

        public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
            if (TextureIO.TGA.equals(string)) {
                TGAImage tGAImage = TGAImage.read(inputStream);
                if (n2 == 0) {
                    n2 = tGAImage.getGLFormat();
                }
                if (n == 0) {
                    GL gL = GLContext.getCurrentGL();
                    n = gL.isGL2() ? 32856 : (tGAImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(n, tGAImage.getWidth(), tGAImage.getHeight(), 0, n2, 5121, bl, false, false, tGAImage.getData(), null);
            }
            return null;
        }
    }

    static class TGATextureWriter
    implements TextureWriter {
        TGATextureWriter() {
        }

        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.TGA.equals(FileUtil.getFileSuffix(file))) {
                int n = textureData.getPixelFormat();
                int n2 = textureData.getPixelType();
                if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
                    ByteBuffer byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    int n3 = n == 6407 ? 3 : 4;
                    for (int i = 0; i < byteBuffer.remaining(); i += n3) {
                        byte by = byteBuffer.get(i + 0);
                        byte by2 = byteBuffer.get(i + 2);
                        byteBuffer.put(i + 0, by2);
                        byteBuffer.put(i + 2, by);
                    }
                    TGAImage tGAImage = TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n == 6408, false, textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0]);
                    tGAImage.write(file);
                    return true;
                }
                throw new IOException("TGA writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }
}

