/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationLogger;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.RegistrationServiceConfig;
import com.sun.enterprise.registration.RepositoryManager;
import com.sun.enterprise.registration.SOAccount;
import com.sun.enterprise.registration.ServiceTag;
import com.sun.enterprise.registration.StringManager;
import com.sun.enterprise.registration.SysnetTransferManager;
import com.sun.scn.client.comm.RegistrationWrapper;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.servicetags.EnvironmentInformation;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetRegistrationService
implements RegistrationService {
    private final RegistrationWrapper regWrapper;
    private final File localRepositoryFile;
    private static final String REGISTRATOR_ID = "ApplicationServer";
    private static final String AIX = "AIX";
    private static final Logger logger = RegistrationLogger.getLogger();

    public SysnetRegistrationService(File localRepositoryFile) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID());
    }

    public SysnetRegistrationService(File localRepositoryFile, String proxyHost, int proxyPort) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), proxyHost, proxyPort);
    }

    public SysnetRegistrationService(Object[] params) {
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), (String)params[1], (Integer)params[2]);
    }

    public SysnetRegistrationService(RegistrationServiceConfig rc) {
        Object[] params = rc.getParams();
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = params.length == 1 ? new RegistrationWrapper(SysnetRegistrationService.getRegistratorID()) : new RegistrationWrapper(SysnetRegistrationService.getRegistratorID(), (String)rc.getParams()[1], (Integer)rc.getParams()[2]);
    }

    public static String getRegistratorID() {
        return REGISTRATOR_ID;
    }

    public boolean isRegistrationEnabled() {
        if (AIX.equalsIgnoreCase(System.getProperty("os.name"))) {
            return false;
        }
        return this.localRepositoryFile.canWrite();
    }

    public void register(RegistrationAccount account) throws RegistrationException, ConnectException, UnknownHostException {
        try {
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage());
            }
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArchitecture = System.getProperty("os.arch");
            String systemModel = "";
            String systemManufacturer = "";
            String cpuManufacturer = "";
            EnvironmentInformation env = new EnvironmentInformation(hostName, hostName, osName, osVersion, osArchitecture, systemModel, systemManufacturer, cpuManufacturer, "");
            RepositoryManager rm = new RepositoryManager(this.localRepositoryFile);
            rm.updateRuntimeValues();
            List<ServiceTag> serviceTags = rm.getServiceTags();
            List<SvcTag> svcTags = ServiceTag.getSvcTags(serviceTags);
            String registryURN = "urn:st:" + UUID.randomUUID().toString();
            logger.log(Level.FINEST, "registryURN = " + registryURN);
            logger.log(Level.FINE, "Attempting to  register " + svcTags.size() + " servicetags");
            SOAccount soAccount = (SOAccount)account;
            this.regWrapper.registerServiceTags(env, svcTags, registryURN, soAccount.getUserID(), soAccount.getPassword());
            this.setRegistrationStatus(RegistrationService.RegistrationStatus.REGISTERED);
            logger.log(Level.INFO, "Registered " + svcTags.size() + " tags");
        }
        catch (SvcTagException ex) {
            throw new RegistrationException((Throwable)ex);
        }
    }

    public void createRegistrationAccount(RegistrationAccount soa) throws RegistrationException {
        try {
            SunOnlineAccount account = ((SOAccount)soa).getSunOnlineAccount();
            this.regWrapper.createSunOnlineAccount(account);
        }
        catch (SvcTagException ex) {
            throw new RegistrationException((Throwable)ex);
        }
    }

    public List<String> getAvailableCountries() {
        return this.regWrapper.getAvailableCountries();
    }

    public List getAvailableCountries(Locale locale) {
        String cts = StringManager.getString("COUNTRY_LIST_TOTAL_COUNT", new Object[0]);
        int count = Integer.parseInt(cts);
        ArrayList<String> displayList = new ArrayList<String>();
        ArrayList<String> actualList = new ArrayList<String>();
        for (int i = 1; i < count + 1; ++i) {
            displayList.add(StringManager.getString("COUNTRY-" + i, new Object[0]));
            actualList.add(StringManager.getString("en_COUNTRY-" + i, new Object[0]));
        }
        ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>(2);
        ret.add(0, displayList);
        ret.add(1, actualList);
        return ret;
    }

    public List<String> getAvailableSecurityQuestions() {
        return this.regWrapper.getAvailableSecurityQuestions();
    }

    public RegistrationService.RegistrationReminder getRegistrationReminder() throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        return repository.getRegistrationReminder();
    }

    public void setRegistrationReminder(RegistrationService.RegistrationReminder reminder) throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        repository.setRegistrationReminder(reminder);
    }

    public RegistrationService.RegistrationStatus getRegistrationStatus() throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        return repository.getRegistrationStatus();
    }

    public void setRegistrationStatus(RegistrationService.RegistrationStatus status) throws RegistrationException {
        RepositoryManager repository = new RepositoryManager(this.localRepositoryFile);
        repository.setRegistrationStatus(status);
    }

    public String getPasswordHelpURL() {
        return "https://reg.sun.com/accounthelp";
    }

    public boolean isRegistrationAccountValid(RegistrationAccount account) throws RegistrationException, UnknownHostException, ConnectException {
        SOAccount soAccount = (SOAccount)account;
        try {
            this.regWrapper.authenticate(soAccount.getUserID(), soAccount.getPassword());
        }
        catch (SvcTagException sve) {
            throw new RegistrationException((Throwable)sve);
        }
        return true;
    }

    public void transferEligibleServiceTagsToSysNet() throws RegistrationException {
        SysnetTransferManager transferManager = new SysnetTransferManager(this.localRepositoryFile);
        transferManager.transferServiceTags();
    }
}

