/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.install;

import java.net.MalformedURLException;
import java.net.URL;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;

public class Common {
    public static String getProcessingMode() throws EnhancedException {
        BusRequest modeReq = new BusRequest("Process_Mode_Request", new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.PROCESSING_MODE));
        BusResponse modeResp = ControlBus.getInstance().publishRequest(modeReq, "svc://general/EngineConfig");
        if (modeResp == null) {
            throw new EnhancedException("COULD_NOT_GET_PROCESSING_MODE", "req=" + modeReq);
        }
        if (modeResp.getException() != null) {
            throw new EnhancedException("COULD_NOT_GET_PROCESSING_MODE", (Throwable)modeResp.getException(), "req=" + modeReq);
        }
        return (String)modeResp.getResult();
    }

    public static String getDefaultProductID() throws EnhancedException {
        BusRequest prodReq = new BusRequest("ConfigRequest", new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DEFAULT_PRODUCT_ID));
        BusResponse prodResp = ControlBus.getInstance().publishRequest(prodReq, "svc://general/EngineConfig");
        if (prodResp == null) {
            throw new EnhancedException("COULD_NOT_GET_DEFAULT_PRODUCT_ID", "req=" + prodReq);
        }
        if (prodResp.getException() != null) {
            throw new EnhancedException("COULD_NOT_GET_DEFAULT_PRODUCT_ID", (Throwable)prodResp.getException(), "req=" + prodReq);
        }
        return (String)prodResp.getResult();
    }

    public static URL getMediaLocationURL() throws BusException {
        try {
            BusRequest theReq = new BusRequest("ConfigRequest", new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.MEDIA_LOCATION));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theMediaPath = theResp.getResult();
            if (null == theMediaPath) {
                throw new BusException("MEDIA_LOCATION_NOT_SPECIFIED");
            }
            return new URL((String)theMediaPath);
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new BusException("BUS_REQUEST_FAILED", (Throwable)theEIAEx, new String[0]);
        }
        catch (MalformedURLException theMalformedURLException) {
            throw new BusException("INVALID_MEDIA_LOCATION", (Throwable)theMalformedURLException, ClassUtils.getClassName());
        }
    }
}

