/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.logging;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;

public class UniformLogFormatter
extends Formatter {
    protected LogManager gLogManager;
    protected Date gDate;
    protected String gProductName = "Install Engine";
    protected String gProductVersion = "1.0";
    protected static final int FINE_LEVEL_INT_VALUE = Level.FINE.intValue();
    protected static final String LINE_SEPARATOR = "\n";
    protected static final String RECORD_BEGIN_MARKER = "[#|";
    protected static final String RECORD_END_MARKER = "|#]\n";
    protected static final String FIELD_SEPARATOR = "|";
    protected static final String NV_PAIRS_SEPARATOR = ";";
    protected static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected SimpleDateFormat DATE_FORMAT;
    private Locale gLocale = null;
    private static String gResourceBundleName = "org.openinstaller.resources.ResourceMsgs";

    public UniformLogFormatter() {
        this.DATE_FORMAT = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
    }

    public UniformLogFormatter(Locale aLocale) {
        this.setLogLocale(aLocale);
        this.DATE_FORMAT = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
    }

    public final void setLogLocale(Locale aLocale) {
        this.gLocale = aLocale;
    }

    public String format(LogRecord aRecord) {
        return this.uniformLogFormat(aRecord);
    }

    public String formatMessage(LogRecord aRecord) {
        return this.uniformLogFormat(aRecord);
    }

    public void setProductName(String aProductName) {
        this.gProductName = aProductName;
    }

    public void setProductVersion(String aVersion) {
        this.gProductVersion = aVersion;
    }

    protected String getProductName() {
        return this.gProductName;
    }

    protected String getProductVersion() {
        return this.gProductVersion;
    }

    protected String getKeyValuePairs(LogRecord aRecord) {
        StringBuffer theParamBuffer = new StringBuffer("");
        String theArgPattern = "arg";
        Object[] theObjArray = aRecord.getParameters();
        if (theObjArray != null) {
            List<Object> theParamList = Arrays.asList(theObjArray);
            int theIndx = 0;
            for (Object theObj : theParamList) {
                String theKey = "arg" + theIndx;
                String theValue = "";
                if (theObj != null) {
                    theValue = theObj.toString();
                }
                if (theParamBuffer.length() > 0) {
                    theParamBuffer.append(NV_PAIRS_SEPARATOR);
                }
                theParamBuffer.append(this.escapeKeyValuePair(theKey)).append('=').append(this.escapeKeyValuePair(theValue));
                ++theIndx;
            }
        }
        return theParamBuffer.toString();
    }

    private String escapeKeyValuePair(String aKeyOrValue) {
        String escapedKeyValuePair = aKeyOrValue;
        escapedKeyValuePair = escapedKeyValuePair.replace("=", "\\=");
        escapedKeyValuePair = escapedKeyValuePair.replace(NV_PAIRS_SEPARATOR, "\\;");
        escapedKeyValuePair = escapedKeyValuePair.replace(FIELD_SEPARATOR, "\\|");
        return escapedKeyValuePair;
    }

    protected synchronized String writeLogRecord(LogRecord aRecord, String aMsgText) {
        this.gDate = new Date();
        try {
            StringBuffer theRecordBuffer = new StringBuffer(RECORD_BEGIN_MARKER);
            this.gDate.setTime(aRecord.getMillis());
            String theFormattedDate = this.DATE_FORMAT.format(this.gDate);
            theFormattedDate = theFormattedDate.substring(0, theFormattedDate.length() - 2) + ":" + theFormattedDate.substring(theFormattedDate.length() - 2);
            theRecordBuffer.append(theFormattedDate);
            theRecordBuffer.append(FIELD_SEPARATOR).append(aRecord.getLevel().getName()).append(FIELD_SEPARATOR);
            theRecordBuffer.append(this.getProductName()).append(FIELD_SEPARATOR);
            theRecordBuffer.append(aRecord.getLoggerName()).append(FIELD_SEPARATOR);
            theRecordBuffer.append(this.getKeyValuePairs(aRecord)).append(FIELD_SEPARATOR);
            String theLogMessageID = aRecord.getMessage();
            theRecordBuffer.append(theLogMessageID);
            if (aMsgText != null && !"".equals(aMsgText)) {
                theRecordBuffer.append(':');
                theRecordBuffer.append(this.escapeMessageText(aMsgText));
            }
            if (aRecord.getThrown() != null) {
                theRecordBuffer.append(LINE_SEPARATOR);
                Throwable theThrowable = aRecord.getThrown();
                if (EnhancedException.class.isInstance(theThrowable)) {
                    theRecordBuffer.append(theThrowable.toString());
                } else {
                    theRecordBuffer.append(EnhancedException.getCompleteStack(theThrowable));
                }
            }
            theRecordBuffer.append(RECORD_END_MARKER);
            return theRecordBuffer.toString();
        }
        catch (Exception theEx) {
            new ErrorManager().error("Error in formatting Logrecord", theEx, 5);
            return "";
        }
    }

    protected String uniformLogFormat(LogRecord aLogRecord) {
        String theMessageText = null;
        String PRODUCT_NAME = "PRODUCT_NAME";
        String PRODCUT_VERSION = "PRODUCT_VERSION";
        if (aLogRecord.getLevel().intValue() > Level.FINE.intValue() && this.gLocale != null) {
            try {
                theMessageText = Msg.getWithLocaleName(gResourceBundleName, aLogRecord.getMessage(), this.gLocale, aLogRecord.getParameters());
                String theProductName = Msg.getWithBundleName(gResourceBundleName, "PRODUCT_NAME", new Object[0]);
                String theProductVer = Msg.getWithBundleName(gResourceBundleName, "PRODUCT_VERSION", new Object[0]);
                this.setProductName(theProductName);
                this.setProductVersion(theProductVer);
            }
            catch (MissingResourceException theMRE) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error formatting in Locale " + this.gLocale.getDisplayName() + " : Resource Missing", theMRE.getClassName());
            }
        } else {
            theMessageText = aLogRecord.getMessage();
        }
        return this.writeLogRecord(aLogRecord, theMessageText);
    }

    protected String escapeMessageText(String aMessageText) {
        String theEscapedMessageText = aMessageText;
        theEscapedMessageText = theEscapedMessageText.replace(FIELD_SEPARATOR, "\\|");
        theEscapedMessageText = theEscapedMessageText.replace("[", "\\[");
        theEscapedMessageText = theEscapedMessageText.replace("#", "\\#");
        theEscapedMessageText = theEscapedMessageText.replace("]", "\\]");
        return theEscapedMessageText;
    }
}

