/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency.legacy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.DependencyManager;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.legacy.LegacyData;
import org.openinstaller.provider.dependency.legacy.LegacyUtil;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.install.Common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyDependency {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private List<LegacyData> gLegacyDataList = new ArrayList<LegacyData>();
    private String gLegacyProductID;
    private URL gLegacyDescriptorsLoc;

    public LegacyDependency(URL aLegacyDescriptorsLoc) {
        this.setLegacyDescriptorsLocation(aLegacyDescriptorsLoc);
    }

    public void initialize() throws EnhancedException {
        LOGGER.finer("@Initializing Legacy Dependency");
        if (this.gLegacyDescriptorsLoc == null) {
            throw new EnhancedException("INVALID_LEGACY_DESC_LOC", new String[0]);
        }
        LOGGER.finer("@Legacy URL  = " + this.gLegacyDescriptorsLoc.toExternalForm());
        this.buildLegacyDependencies(this.gLegacyDescriptorsLoc);
    }

    public void buildLegacyDependencies(URL aLegacyDescriptorsLoc) throws EnhancedException {
        this.gLegacyProductID = null;
        Object theResp = null;
        this.gLegacyProductID = Common.getDefaultProductID();
        File theLegacyVersionDir = new File(aLegacyDescriptorsLoc.getPath());
        for (File theLegacyDir : LegacyDependency.findLegacies(theLegacyVersionDir)) {
            DependencyManager theLegacyDependencyManager;
            try {
                URL theLegacyIndexURL = new URL(theLegacyDir.toURL(), "index.txt");
                LOGGER.fine("Legacy Index URL = " + theLegacyIndexURL.toExternalForm());
                theLegacyDependencyManager = new DependencyManager(new URL[]{theLegacyIndexURL, this.getClass().getResource("/dependency/Engine.xml")}, this.gLegacyProductID, null);
                theLegacyDependencyManager.selectHybridElement(this.gLegacyProductID);
                for (MediaProduct theSubFeature : theLegacyDependencyManager.getProductNode(this.gLegacyProductID).getFeatures()) {
                    theLegacyDependencyManager.selectHybridElement(theSubFeature.getID());
                }
                theLegacyDependencyManager.selectHybridElement("Engine");
                MediaProduct theHybrid = this.createHybridElementTree(theLegacyDependencyManager);
                if (theHybrid == null) continue;
                LegacyData theLegacyData = new LegacyData(theHybrid.getID(), theHybrid.getVersion(), theLegacyDependencyManager, theHybrid);
                LOGGER.finest("@ Adding legacy product -> " + theHybrid.getID() + " " + theHybrid.getVersion());
                this.gLegacyDataList.add(theLegacyData);
            }
            catch (MalformedURLException theMUEx) {
                throw new EnhancedException("CANNOT_FORM_LEGACY_INDEX_URL", new String[]{"directory=" + theLegacyVersionDir.getName()});
            }
            finally {
                theLegacyDependencyManager = null;
            }
        }
    }

    public MediaProduct createHybridElementTree(DependencyManager aDepMgr) throws EnhancedException {
        MediaProduct theHybridElement = null;
        try {
            theHybridElement = aDepMgr.getProductNode(this.gLegacyProductID);
            LOGGER.finest("Created HCETPNA for " + theHybridElement.getID() + " with Version " + theHybridElement.getVersion());
        }
        catch (EnhancedException theEE) {
            theEE.addContext("CANNOT_CREATE_LEGACY_HYBRID_ELEMENT_ADAPTOR", new String[0]);
            throw theEE;
        }
        return theHybridElement;
    }

    public SystemProduct getLegacySIMSProduct(MediaProduct aLegacyProduct) throws EnhancedException {
        LOGGER.finer("@ About to create legacy SIMS Product from HCETPNA for " + aLegacyProduct.getID());
        return LegacyUtil.createProduct(aLegacyProduct);
    }

    public void setLegacyDescriptorsLocation(URL aLegacyDescriptorsLoc) {
        this.gLegacyDescriptorsLoc = aLegacyDescriptorsLoc;
    }

    public List<LegacyData> getLegacyData() throws EnhancedException {
        if (this.gLegacyDataList.isEmpty() && this.gLegacyDescriptorsLoc != null) {
            try {
                this.initialize();
            }
            catch (EnhancedException theEEx) {
                theEEx.addContext("COULD_NOT_GET_LEGACY_DATA", new String[0]);
                throw theEEx;
            }
        }
        return this.gLegacyDataList;
    }

    private static List<File> findLegacies(File aFileSystemNode) {
        ArrayList<File> theIndices = new ArrayList<File>();
        if (aFileSystemNode != null && aFileSystemNode.isDirectory()) {
            for (File theFileSystemSubNode : aFileSystemNode.listFiles()) {
                theIndices.addAll(LegacyDependency.findLegacies(theFileSystemSubNode));
            }
        }
        if (aFileSystemNode != null && "index.txt".equals(aFileSystemNode.getName())) {
            theIndices.add(aFileSystemNode.getParentFile());
        }
        return theIndices;
    }
}

