/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.operation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.provider.operation.OperationData;
import org.openinstaller.provider.operation.OperationImpossibleException;
import org.openinstaller.provider.operation.OperationManager;
import org.openinstaller.provider.operation.OpsControl;
import org.openinstaller.provider.operation.ProductMap;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public final class OpsProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private OperationData gOperationData;

    public void init(ControlBus aBus) {
        this.gOperationData = new OperationData();
    }

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        EnhancedException theException = null;
        if (!OpsControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new EnhancedException("INVALID_OPS_REQUEST", new String[]{"request=" + aReq})));
            return;
        }
        switch (((OpsControl)aReq.getData()).getCommand()) {
            case GET_PRODUCT_MAP: {
                Object theSIMSData = ((OpsControl)aReq.getData()).getData();
                if (String.class.isInstance(theSIMSData)) {
                    String theInstallHome = (String)theSIMSData;
                    try {
                        aResp.setFinalResult((Object)this.gOperationData.getProductMap(theInstallHome));
                    }
                    catch (EnhancedException theEEx) {
                        theException = theEEx;
                    }
                    break;
                }
                theException = new EnhancedException("INVALID_OPS_REQUEST", new String[]{"request=" + aReq});
                break;
            }
            case PERFORM: {
                Object theSIMSData = ((OpsControl)aReq.getData()).getData();
                if (ProductMap.class.isInstance(theSIMSData)) {
                    ProductMap theMap = (ProductMap)theSIMSData;
                    try {
                        aResp.setFinalResult(OperationManager.getOperations(theMap.getSystemModel(), theMap.getMediaModel(), theMap.getOperation(), theMap.getPlatform()));
                    }
                    catch (OperationImpossibleException theEx) {
                        theException = theEx;
                    }
                    break;
                }
                theException = new EnhancedException("INVALID_OPS_REQUEST", new String[]{"request=" + aReq});
                break;
            }
            default: {
                LOGGER.log(Level.FINE, "Invalid request: " + aReq);
                theException = new EnhancedException("INVALID_SIMS_REQUEST", new String[]{"request=" + aReq});
                aResp.setFinalResult(null);
            }
        }
        if (theException != null) {
            aResp.setException((Exception)((Object)theException));
        }
    }

    public String getName() {
        return "svc://general/operation";
    }
}

