/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.core;

import java.io.File;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;

public final class TempFileProvider
implements ServiceProvider {
    private final SortedSet<File> gFiles = new TreeSet<File>(new Comparator<File>(){

        @Override
        public int compare(File aFile, File aDifferentFile) {
            if (aDifferentFile.getAbsolutePath().length() == aFile.getAbsolutePath().length()) {
                if (aDifferentFile.getAbsolutePath().equals(aFile.getAbsolutePath())) {
                    return 0;
                }
                return 1;
            }
            return aDifferentFile.getAbsolutePath().length() - aFile.getAbsolutePath().length();
        }

        @Override
        public boolean equals(Object aObject) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    });
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public void init(ControlBus aBus) {
    }

    public void shutdown() {
        this.deleteFiles();
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aRequest, BusResponse aResp) {
        if (!File.class.isInstance(aRequest.getData())) {
            String theMsg = Msg.get(this.getClass(), "NOT_A_FILE", new Object[0]);
            aResp.setException(new InvalidArgumentException(aRequest + theMsg, new String[0]));
            return;
        }
        this.gFiles.add((File)aRequest.getData());
    }

    public String getName() {
        return "svc://general/tmpfiles";
    }

    private void deleteFiles() {
        for (File theFile : this.gFiles) {
            if (theFile.isFile() && theFile.exists()) {
                LOGGER.log(Level.FINE, "DELETING_FILE", theFile);
                theFile.delete();
                continue;
            }
            if (!theFile.isDirectory() || !theFile.exists() || !this.isEmpty(theFile)) continue;
            LOGGER.log(Level.FINE, "DELETING_FILE", theFile);
            theFile.delete();
        }
    }

    private boolean isEmpty(File aFile) {
        if (!aFile.isDirectory()) {
            return false;
        }
        File[] theFiles = aFile.listFiles();
        return theFiles != null && theFiles.length == 0;
    }

    public int countFiles() {
        int fileCount = 0;
        int dirCount = 0;
        for (File theFile : this.gFiles) {
            if (theFile.isFile() && theFile.exists()) {
                ++fileCount;
                continue;
            }
            if (!theFile.isDirectory() || !theFile.exists() || !this.isEmpty(theFile)) continue;
            ++dirCount;
        }
        return fileCount + dirCount;
    }
}

