/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.pkg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZIPPackageUtils {
    private static final String UNZIP_CMD_LOC_PROPNAME = "org.openinstaller.cmd.unzip";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final File ZIP_UTIL;

    public static void installPkg(File aSrcPath, String aPkgName, String aInstallHome, ProgressListener aListener) throws PackageException {
        LOGGER.log(Level.INFO, "EXTRACTING_ZIP", new String[]{"file=" + aSrcPath, "pkg=" + aPkgName, "dir=" + aInstallHome});
        FilterOutputStream theBufOutStream = null;
        ZipInputStream theZipInStream = null;
        File theInstallHomeFile = new File(aInstallHome);
        boolean theZipUtilFlag = ZIP_UTIL.exists();
        try {
            ZipEntry theZipEntry;
            ZipFile theZipFile = new ZipFile(aSrcPath);
            int theTotalEntryCount = theZipFile.size();
            theZipFile.close();
            theZipInStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(aSrcPath)));
            SortedSet<File> theSortedList = Collections.synchronizedSortedSet(new TreeSet<File>(new Comparator<File>(){

                @Override
                public int compare(File aFile, File aDifferentFile) {
                    if (aDifferentFile.getAbsolutePath().length() == aFile.getAbsolutePath().length()) {
                        if (aDifferentFile.getAbsolutePath().equals(aFile.getAbsolutePath())) {
                            return 0;
                        }
                        return 1;
                    }
                    return aDifferentFile.getAbsolutePath().length() - aFile.getAbsolutePath().length();
                }
            }));
            if (theZipUtilFlag) {
                try {
                    ZIPPackageUtils.extractZipUsingUtility(aSrcPath, theInstallHomeFile, theTotalEntryCount, aListener);
                }
                catch (EnhancedException theEx) {
                    throw new PackageException(theEx, "PACKAGE_INSTALL_FAILED", new String[0]);
                }
            }
            int theCount = 0;
            while ((theZipEntry = theZipInStream.getNextEntry()) != null) {
                ZIPPackageUtils.addFileHierarchy(new File(theZipEntry.getName()), theSortedList);
                if (theZipUtilFlag) continue;
                if (aListener != null) {
                    int theProgress = Math.min(100, (int)(100.0 * ((double)theCount / (double)theTotalEntryCount)));
                    aListener.updateProgress(theProgress);
                }
                ++theCount;
                File theOutFile = new File(theInstallHomeFile, theZipEntry.getName());
                if (theZipEntry.isDirectory()) {
                    if (!theOutFile.exists() && !theOutFile.mkdirs()) {
                        throw new PackageException("CANNOT_CREATE_DIRECTORY", "dir=" + theOutFile);
                    }
                    LOGGER.finest("Created or re-used existing directory " + theOutFile);
                    continue;
                }
                if (!theOutFile.getParentFile().exists() && !theOutFile.getParentFile().mkdirs()) {
                    throw new PackageException("CANNOT_CREATE_DIRECTORY", "dir=" + theOutFile.getParentFile());
                }
                theBufOutStream = new BufferedOutputStream(new FileOutputStream(new File(aInstallHome, theZipEntry.getName())));
                LOGGER.log(Level.INFO, "EXTRACTING_FILE", "file=" + theZipEntry.getName());
                FileUtils.copyStream(theZipInStream, theBufOutStream);
                ((BufferedOutputStream)theBufOutStream).flush();
                theBufOutStream.close();
            }
            try {
                ZIPPackageUtils.writeManifest(aInstallHome, aPkgName, theSortedList);
            }
            catch (Exception theEx) {
                throw new PackageException(theEx, "CANNOT_WRITE_FILE", "dir=" + aInstallHome, "pkg=" + aPkgName);
            }
            theSortedList.clear();
            theZipInStream.close();
            LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", "pkg=" + aPkgName);
        }
        catch (IOException theIOE) {
            throw new PackageException(theIOE, "CANNOT_INSTALL_PKG", "pkg=" + aPkgName);
        }
        finally {
            try {
                if (theBufOutStream != null) {
                    theBufOutStream.close();
                }
                if (theZipInStream != null) {
                    theZipInStream.close();
                }
            }
            catch (IOException theEx) {
                LOGGER.log(Level.WARNING, "CANNOT_CLOSE_STREAM", theEx);
            }
        }
    }

    private static void extractZipUsingUtility(File aSrcPath, File aInstallHomeFile, int aTotalEntryCount, ProgressListener aListener) throws EnhancedException {
        ProcessBuilder theProcBuilder = new ProcessBuilder(ZIP_UTIL.getAbsolutePath(), "-o", "-d", aInstallHomeFile.getAbsolutePath(), aSrcPath.getAbsolutePath());
        theProcBuilder.redirectErrorStream(true);
        Process theProc = null;
        try {
            String theLine;
            theProc = theProcBuilder.start();
            theProc.getOutputStream().close();
            BufferedReader theIn = new BufferedReader(new InputStreamReader(theProc.getInputStream()));
            int theCount = 0;
            while ((theLine = theIn.readLine()) != null) {
                if (theLine.trim().length() == 0) continue;
                if (aListener != null) {
                    int theProgress = Math.min(100, (int)(100.0 * ((double)theCount / (double)aTotalEntryCount)));
                    aListener.updateProgress(theProgress);
                }
                ++theCount;
            }
            theProc.waitFor();
        }
        catch (IOException theEx) {
            throw new EnhancedException("ZIP_UTIL_FAILED", "cmd=" + theProcBuilder.command(), "exit-value=" + theProc.exitValue());
        }
        catch (InterruptedException theEx) {
            throw new EnhancedException("ZIP_UTIL_FAILED", "cmd=" + theProcBuilder.command(), "exit-value=" + theProc.exitValue());
        }
        if (theProc.exitValue() != 0) {
            throw new EnhancedException("ZIP_UTIL_FAILED", "cmd=" + theProcBuilder.command(), "exit-value=" + theProc.exitValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePkg(String aPkgName, String aInstallHome, ProgressListener aListener) throws PackageException {
        File theUn = ZIPPackageUtils.getManifestDir(aInstallHome);
        File theFile = new File(theUn, aPkgName.replaceAll(".zip", "") + ".properties");
        BufferedReader theIn = null;
        LOGGER.log(Level.INFO, "REMOVING_PKG_FILES", new String[]{"pkg=" + aPkgName, "dir=" + aInstallHome, "manifest=" + theFile});
        try {
            String theFilePath;
            theIn = new BufferedReader(new FileReader(theFile));
            int theCount = 0;
            int theTotal = 0;
            try {
                theTotal = Integer.parseInt(theIn.readLine());
            }
            catch (Exception theEx) {
                LOGGER.log(Level.FINE, "cannot determine number of files to delete", theEx);
            }
            while ((theFilePath = theIn.readLine()) != null) {
                File theTarget = new File(aInstallHome, theFilePath);
                if (theTarget.exists() && !theTarget.delete()) {
                    LOGGER.log(Level.WARNING, "CANNOT_DELETE_FILE", "file=" + theTarget.getAbsolutePath());
                }
                ++theCount;
                if (theTotal <= 0 || aListener == null) continue;
                int theProgress = Math.min(100, (int)(100.0 * ((double)theCount / (double)theTotal)));
                aListener.updateProgress(theProgress);
            }
        }
        catch (IOException theEx) {
            LOGGER.log(Level.WARNING, "CANNOT_READ_MANIFEST", "file=" + theFile.getAbsolutePath());
        }
        finally {
            try {
                if (theIn != null) {
                    theIn.close();
                }
            }
            catch (IOException theEx) {
                LOGGER.log(Level.WARNING, "CANNOT_CLOSE_FILE", "file=" + theFile.getAbsolutePath());
            }
        }
        if (!theFile.delete()) {
            LOGGER.log(Level.WARNING, "CANNOT_DELETE_FILE", "file=" + theFile.getAbsolutePath());
        }
        LOGGER.log(Level.INFO, "PACKAGE_UNINSTALL_SUCCESSFUL", "pkg=" + aPkgName);
    }

    private static void addFileHierarchy(File aEntry, Set<File> aManifest) {
        for (File theEntry = aEntry; theEntry != null; theEntry = theEntry.getParentFile()) {
            aManifest.add(theEntry);
        }
    }

    private static void writeManifest(String aParent, String aPackageName, Set<File> aManifest) throws FileNotFoundException {
        File theUn = ZIPPackageUtils.getManifestDir(aParent);
        if (!theUn.exists()) {
            theUn.mkdirs();
        }
        File theFile = new File(theUn, aPackageName.replaceAll(".zip", "") + ".properties");
        PrintWriter theOut = new PrintWriter(theFile);
        theOut.println(aManifest.size());
        for (File theEntry : aManifest) {
            theOut.println(theEntry.getPath());
        }
        theOut.close();
    }

    private static File getManifestDir(String aInstallHome) {
        File theIHFile = new File(aInstallHome);
        File thePkgDB = new File(theIHFile, "var/install/pkgdb");
        File theUn = new File(thePkgDB, "uninstall");
        return theUn;
    }

    static {
        File theBin = new File("/usr/bin/unzip");
        String unzipLocationSpecified = System.getProperty(UNZIP_CMD_LOC_PROPNAME);
        ZIP_UTIL = unzipLocationSpecified != null ? new File(unzipLocationSpecified) : (theBin.exists() ? theBin : new File("/bin/unzip"));
    }
}

