/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.chaxml.DefaultFactory;
import org.chaxml.Factory;

public abstract class TagLibrary {
    private Map tags = new HashMap();

    public TagLibrary() {
        this.registerTags();
    }

    protected abstract void registerTags();

    public void registerTag(String name, Class template) {
        this.registerTag(name, new DefaultFactory(template));
    }

    public void registerTag(String name, Factory factory) {
        this.tags.put(name.toLowerCase(), factory);
    }

    public boolean unregisterTag(String name) {
        return null != this.tags.remove(name);
    }

    public Map getTagClasses() {
        return this.tags;
    }

    public Factory getFactory(String name) {
        return (Factory)this.tags.get(name.toLowerCase());
    }

    public Factory getFactory(Class template) {
        Factory factory = null;
        Iterator it = this.tags.values().iterator();
        while (it != null && it.hasNext()) {
            Factory f = (Factory)it.next();
            if (!f.getTemplate().equals(template)) continue;
            factory = f;
            break;
        }
        return factory;
    }

    protected Method getSetter(Class template, String name) {
        Method method = null;
        Factory factory = this.getFactory(template.getName());
        if (factory != null) {
            method = factory.getSetter(name);
        }
        return method;
    }

    protected Method guessSetter(Class template, String name) {
        Method method = null;
        Factory factory = this.getFactory(template.getName());
        if (factory != null) {
            method = factory.guessSetter(name);
        }
        return method;
    }
}

