/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openinstaller.util.ClassUtils;

public class ModulesTOC {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private URL gURL;
    private String gModuleIdentifier;
    private final Map<String, Map<String, String>> gModulesMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> gModuleMap = new HashMap<String, String>();
    private String gModule;
    private static final char SEPARATOR = '=';
    private final Pattern SEPARATOR_PATTERN;

    public ModulesTOC(URL aURLOfTheFile) {
        String theSeparator = "\\s*+" + String.valueOf('=') + "\\s*+";
        this.SEPARATOR_PATTERN = Pattern.compile(theSeparator);
        this.setURL(aURLOfTheFile);
        this.splitFile();
    }

    public final String getValue(String aModule, String aVariable) {
        Map<String, String> thePackageMap;
        String theResult = "";
        if (this.gModulesMap.containsKey(aModule) && (thePackageMap = this.gModulesMap.get(aModule)).containsKey(aVariable)) {
            theResult = thePackageMap.get(aVariable);
        }
        return theResult;
    }

    public final Set getContents(String aModule) {
        Set<Object> theResult = new HashSet();
        if (this.gModulesMap.containsKey(aModule)) {
            Map<String, String> thePackageMap = this.gModulesMap.get(aModule);
            theResult = thePackageMap.keySet();
        }
        return theResult;
    }

    private void splitFile() {
        try {
            BufferedReader theIntake = new BufferedReader(new InputStreamReader(this.gURL.openStream()));
            String theInputLine = theIntake.readLine();
            this.setModuleIdentifier(theInputLine);
            while ("".equals(this.getModuleIdentifier())) {
                theInputLine = theIntake.readLine();
                this.setModuleIdentifier(theInputLine);
            }
            while (theInputLine != null) {
                LOGGER.log(Level.FINE, "Reading " + theInputLine);
                if (this.isNewCycle(theInputLine)) {
                    this.wrapUpModule(theInputLine);
                }
                this.addAttributeValue(theInputLine);
                theInputLine = theIntake.readLine();
            }
        }
        catch (IOException theException) {
            LOGGER.log(Level.SEVERE, "CANNOT_OPEN_TOC_PAGE", theException);
        }
    }

    private void addAttributeValue(String aInput) {
        String theVariable = this.extractVariable(aInput);
        if (!"".equals(theVariable)) {
            String theValue = this.extractValue(aInput);
            this.gModuleMap.put(theVariable, theValue);
        }
    }

    private boolean isNewCycle(String aInput) {
        return this.getModuleIdentifier().equals(this.extractVariable(aInput));
    }

    private void wrapUpModule(String aNextInput) {
        if (!this.gModuleMap.isEmpty()) {
            this.gModulesMap.put(this.gModule, this.gModuleMap);
        }
        this.gModule = this.extractValue(aNextInput);
        this.gModuleMap = new HashMap<String, String>();
    }

    public final String extractValue(String aInput) {
        String[] theResult = this.SEPARATOR_PATTERN.split(aInput, 2);
        return theResult[1].trim();
    }

    public final String extractVariable(String aInput) {
        String theVariable = "";
        if (aInput != null) {
            String[] theResult = this.SEPARATOR_PATTERN.split(aInput, 2);
            theVariable = theResult[0].trim();
        }
        return theVariable;
    }

    private void setURL(URL aURL) {
        this.gURL = aURL;
    }

    private void setModuleIdentifier(String aInputLine) {
        String theModuleIdentifier = this.extractVariable(aInputLine);
        if (!"".equals(theModuleIdentifier)) {
            this.gModuleIdentifier = theModuleIdentifier;
        }
    }

    private String getModuleIdentifier() {
        return this.gModuleIdentifier;
    }
}

