/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.List;
import org.openinstaller.provider.dependency.InstallableUnitParameter;
import org.openinstaller.provider.dependency.L10nInstallableUnitKeyValue;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformInstUnit {
    private Platform gPlatform;
    private List<InstallableUnitParameter> gParams;
    private L10nInstallableUnitKeyValue gInstUnit;

    public PlatformInstUnit(String aEncodedRealizationID, L10nInstallableUnitKeyValue aL10nInstallableUnit) throws EnhancedException {
        this.setPlatform(aEncodedRealizationID);
        this.setIU(aL10nInstallableUnit);
    }

    public PlatformInstUnit(Platform aPlatform, L10nInstallableUnitKeyValue aL10nInstallableUnit) throws EnhancedException {
        this.gPlatform = aPlatform;
        this.setIU(aL10nInstallableUnit);
    }

    private void setPlatform(String aEncodedRealizationID) throws EnhancedException {
        L10nInstallableUnitKeyValue theTemporary = new L10nInstallableUnitKeyValue(aEncodedRealizationID);
        this.gPlatform = Platform.decode((String)theTemporary.getValue());
    }

    private void setIU(L10nInstallableUnitKeyValue aL10nInstallableUnit) {
        this.gInstUnit = aL10nInstallableUnit;
    }

    public final Platform getPlatform() {
        return this.gPlatform;
    }

    public final L10nInstallableUnitKeyValue getIU() {
        return this.gInstUnit;
    }

    public List<InstallableUnitParameter> getParameters() {
        return this.gParams;
    }

    public void setParameters(List<InstallableUnitParameter> aParamList) {
        this.gParams = aParamList;
    }
}

