/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform;

import java.io.File;
import java.util.ArrayList;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlatformToolkit {
    public abstract String getOSPatchLevel() throws EnhancedException;

    public abstract void setNativeFileDir(String var1);

    public abstract ArrayList<String> createPatchPresentList() throws EnhancedException;

    public abstract String checkPatchInstalled(String var1) throws EnhancedException;

    public abstract String[] getProcessorInfo() throws EnhancedException;

    public abstract long getSwapSpace() throws EnhancedException;

    public abstract long getPhysicalMemory() throws EnhancedException;

    public abstract long getUsableDiskSpace(String var1) throws EnhancedException;

    public static final String getScriptPath(String aBase, String aScript) throws EnhancedException {
        File theNativeDir = new File(aBase);
        File theType = new File(theNativeDir, Platform.getCurrentOsType().getValue());
        File theName = new File(theType, Platform.getCurrentOsName().getValue());
        File theArch = new File(theName, Platform.getCurrentOsArch().getValue());
        File theScriptPath = new File(theArch, aScript);
        if (theScriptPath.exists()) {
            return theScriptPath.getAbsolutePath();
        }
        theScriptPath = new File(theName, aScript);
        if (theScriptPath.exists()) {
            return theScriptPath.getAbsolutePath();
        }
        theScriptPath = new File(theType, aScript);
        if (theScriptPath.exists()) {
            return theScriptPath.getAbsolutePath();
        }
        throw new EnhancedException("NO_SCRIPT_FOUND", new String[]{"dir=" + aBase, "script=" + aScript, "type=" + Platform.getCurrentOsType().getValue(), "name=" + Platform.getCurrentOsName().getValue(), "arch=" + Platform.getCurrentOsArch().getValue()});
    }
}

