/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.config.PropertySheet;
import org.openinstaller.config.lib.Helper;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.provider.conf.Configurator;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.provider.conf.ResultReportReaderThread;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLIConfigurator
implements Configurator,
NotificationListener {
    private final String gComponentBasedir;
    private final String gName;
    private final String gFilePath;
    private final String gAltRoot;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private int gWaitCount = 0;

    public CLIConfigurator(String aComponentName, String aAltRoot, String aAbsoluteComponentSchemaFilePath, String aComponentBasedir) {
        this.gComponentBasedir = aComponentBasedir;
        this.gName = aComponentName;
        this.gFilePath = aAbsoluteComponentSchemaFilePath;
        this.gAltRoot = aAltRoot;
    }

    @Override
    public ResultReport configure(PropertySheet aSheet, boolean aValidateFlag) throws EnhancedException {
        return this.runConfigure(aSheet, aValidateFlag);
    }

    @Override
    public PropertySheet getCurrentConfiguration() throws EnhancedException {
        throw new RuntimeException("Not implemented");
    }

    private static List<String> formCommand(String aBaseDir, String aCompName) throws EnhancedException {
        String theLoc;
        ArrayList<String> theCmd = new ArrayList<String>();
        BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.INIT_CONFIG_LOCATIONS));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        String theLocations = (String)theResp.getResult();
        File theBin = null;
        if (theLocations != null && (theLoc = CLIConfigurator.parseLoc(theLocations, aCompName)) != null && (theBin = new File(theLoc)).isFile() && theBin.exists() && theBin.canRead()) {
            theCmd.add(theBin.getAbsolutePath());
            return theCmd;
        }
        if (theBin == null) {
            File theBase = new File(aBaseDir);
            File theComp = new File(theBase, aCompName);
            theBin = new File(theComp, "bin");
        }
        LOGGER.log(Level.INFO, "CONFIG_LOC", "file=" + theBin);
        File theRawCmd = new File(theBin, "init-config");
        File theSh = new File(theBin, "init-config.sh");
        File theVbs = new File(theBin, "init-config.vbs");
        File theBat = new File(theBin, "init-config.bat");
        File theExe = new File(theBin, "init-config.exe");
        boolean theWinFlag = Platform.getCurrentOsType().equals((Object)Platform.OSType.WINDOWS);
        boolean theUnixFlag = Platform.getCurrentOsType().equals((Object)Platform.OSType.UNIX);
        if (theUnixFlag && theRawCmd.exists() && theRawCmd.canRead()) {
            theCmd.add(theRawCmd.getAbsolutePath());
        } else if (theUnixFlag && theSh.exists() && theSh.canRead()) {
            if (new File("/usr/bin/sh").exists()) {
                theCmd.add("/usr/bin/sh");
            } else {
                theCmd.add("/bin/sh");
            }
            theCmd.add(theSh.getAbsolutePath());
        } else if (theWinFlag && theVbs.exists() && theVbs.canRead()) {
            theCmd.add("cscript");
            theCmd.add("//nologo");
            theCmd.add(theVbs.getAbsolutePath());
        } else if (theBat.exists() && theBat.canRead()) {
            theCmd.add(theBat.getAbsolutePath());
        } else if (theExe.exists() && theExe.canRead()) {
            theCmd.add(theExe.getAbsolutePath());
        } else {
            return null;
        }
        return theCmd;
    }

    protected static String parseLoc(String aLocs, String aCompName) {
        for (String theLoc : aLocs.split(",")) {
            String[] theParts = theLoc.split(":", 2);
            if (theParts.length == 1) {
                return theParts[0];
            }
            if (!theParts[0].equals(aCompName)) continue;
            return theParts[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultReport runConfigure(PropertySheet aSheet, boolean aValidateFlag) throws EnhancedException {
        Process theProcess;
        List<String> theCmdLine = CLIConfigurator.formCommand(this.gComponentBasedir, this.gName);
        if (theCmdLine == null) {
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CLI_MISSING_NEXT_STEPS", (Object[])new Object[]{this.gComponentBasedir, this.gName + "/bin/[init-config, init-config.vbs, init-config.bat]"}), Msg.get((String)"CLI_MISSING", (Object[])new Object[0]), null);
        }
        File theConfigFilePath = this.createConfigFile(aSheet);
        theCmdLine.add("-f");
        theCmdLine.add(this.gFilePath);
        theCmdLine.add("-d");
        theCmdLine.add(theConfigFilePath.getAbsolutePath());
        theCmdLine.add("-s");
        if (aValidateFlag) {
            theCmdLine.add("-v");
        }
        if (this.gAltRoot != null) {
            theCmdLine.add("-R");
            theCmdLine.add(this.gAltRoot);
        }
        StringBuffer theClassPath = new StringBuffer("");
        if (URLClassLoader.class.isInstance(this.getClass().getClassLoader())) {
            URL[] theURLArray;
            URLClassLoader theURL = (URLClassLoader)this.getClass().getClassLoader();
            for (URL thePathComponent : theURLArray = theURL.getURLs()) {
                String thePath = new File(thePathComponent.getFile()).getAbsolutePath().replaceAll("%20", " ");
                theClassPath.append(thePath).append(File.pathSeparator);
            }
        }
        theClassPath.append(System.getProperty("java.class.path"));
        Vector<String> theEnv = new Vector<String>();
        theEnv.add("INIT_CONFIG_PROGRESS_PASSWORD=" + System.getProperty("INIT_CONFIG_PROGRESS_PASSWORD"));
        theEnv.add("INIT_CONFIG_PROGRESS_RMIPORT=" + System.getProperty("INIT_CONFIG_PROGRESS_RMIPORT"));
        theEnv.add("INIT_CONFIG_PROGRESS_OBJECTNAME=" + System.getProperty("INIT_CONFIG_PROGRESS_OBJECTNAME"));
        theEnv.add("INIT_CONFIG_JAVA_HOME=" + System.getProperty("java.home"));
        theEnv.add("INIT_CONFIG_JAVA_CLASSPATH=" + theClassPath.toString());
        theEnv.add("INIT_CONFIG_HELPER_CLASS=" + Helper.class.getName());
        for (Map.Entry<String, String> theEnvSetting : System.getenv().entrySet()) {
            theEnv.add(theEnvSetting.getKey() + "=" + theEnvSetting.getValue());
        }
        CLIConfigurator i$ = this;
        synchronized (i$) {
            this.gWaitCount = 0;
        }
        Object[] theCmdArgs = theCmdLine.toArray(new String[0]);
        try {
            LOGGER.fine("Executing configurator " + Arrays.toString(theCmdArgs) + " with environment variables " + theEnv);
            theProcess = Runtime.getRuntime().exec((String[])theCmdArgs, theEnv.toArray(new String[0]));
        }
        catch (IOException theEx) {
            if (!theConfigFilePath.delete()) {
                LOGGER.log(Level.FINE, "CANNOT_DELETE_FILE", "file=" + theConfigFilePath);
            }
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CHECK_INSTALL_IMAGE", (Object[])new Object[0]), Msg.get((String)"COULD_NOT_INVOKE", (Object[])new Object[]{theCmdLine.toString()}), null);
        }
        ResultReportReaderThread theResultReader = new ResultReportReaderThread(theProcess.getInputStream(), theProcess.getErrorStream());
        Thread theReaderThread = new Thread(theResultReader);
        theReaderThread.setName("ResultReportReader:CONFIG:" + this.gName);
        theReaderThread.start();
        int theMaxCount = 2000;
        boolean theTimedOutFlag = false;
        while (!theTimedOutFlag && theReaderThread.getState() != Thread.State.TERMINATED) {
            CLIConfigurator cLIConfigurator = this;
            synchronized (cLIConfigurator) {
                if (this.gWaitCount > 2000) {
                    theTimedOutFlag = true;
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException theEx) {
                LOGGER.fine("interrupted while waiting for configurator");
            }
            cLIConfigurator = this;
            synchronized (cLIConfigurator) {
                ++this.gWaitCount;
            }
        }
        if (!theConfigFilePath.delete()) {
            LOGGER.log(Level.FINE, "CANNOT_DELETE_FILE", "file=" + theConfigFilePath);
        }
        if (theTimedOutFlag) {
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CHECK_CONFIG", (Object[])new Object[0]), Msg.get((String)"CONFIG_TIMED_OUT_PARTIALLY", (Object[])new Object[]{this.gName, 1000}), theResultReader.getAllOutput());
        }
        LOGGER.log(Level.FINE, "CONFIG_LOG_OUTPUT", "component=" + this.gName);
        LOGGER.log(Level.FINE, theResultReader.getAllOutput());
        return theResultReader.getResult();
    }

    private File createConfigFile(PropertySheet aConfig) throws EnhancedException {
        File theConfigFile = TempFileManager.findTempDir((String)(aConfig.getComponentName() + "-config"));
        try {
            aConfig.write((OutputStream)new FileOutputStream(theConfigFile));
        }
        catch (IOException theEx) {
            throw new EnhancedException("CANNOT_CREATE_FILE", (Throwable)theEx, new String[]{"file=" + theConfigFile});
        }
        return theConfigFile;
    }

    @Override
    public ResultReport unConfigure(PropertySheet aSheet, boolean aValidateFlag) throws EnhancedException {
        Process theProcess;
        List<String> theCmdLine = CLIConfigurator.formCommand(this.gComponentBasedir, this.gName);
        if (theCmdLine == null) {
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CLI_MISSING_NEXT_STEPS", (Object[])new Object[]{this.gComponentBasedir, this.gName + "/bin/[init-config, init-config.vbs, init-config.bat]"}), Msg.get((String)"CLI_MISSING", (Object[])new Object[0]), null);
        }
        if (aValidateFlag) {
            theCmdLine.add("-v");
        }
        theCmdLine.add("-r");
        File theConfigFilePath = this.createConfigFile(aSheet);
        theCmdLine.add("-f");
        theCmdLine.add(this.gFilePath);
        theCmdLine.add("-d");
        theCmdLine.add(theConfigFilePath.getAbsolutePath());
        Vector<String> theEnv = new Vector<String>();
        StringBuffer theClassPath = new StringBuffer("");
        if (URLClassLoader.class.isInstance(this.getClass().getClassLoader())) {
            URL[] theURLArray;
            URLClassLoader theURL = (URLClassLoader)this.getClass().getClassLoader();
            for (URL thePathComponent : theURLArray = theURL.getURLs()) {
                String thePath = new File(thePathComponent.getFile()).getAbsolutePath().replaceAll("%20", " ");
                theClassPath.append(thePath).append(File.pathSeparator);
            }
        }
        theClassPath.append(System.getProperty("java.class.path"));
        theEnv.add("INIT_CONFIG_JAVA_HOME=" + System.getProperty("java.home"));
        theEnv.add("INIT_CONFIG_JAVA_CLASSPATH=" + theClassPath.toString());
        theEnv.add("INIT_CONFIG_HELPER_CLASS=" + Helper.class.getName());
        theEnv.add("INIT_CONFIG_PROGRESS_PASSWORD=" + System.getProperty("INIT_CONFIG_PROGRESS_PASSWORD"));
        theEnv.add("INIT_CONFIG_PROGRESS_RMIPORT=" + System.getProperty("INIT_CONFIG_PROGRESS_RMIPORT"));
        theEnv.add("INIT_CONFIG_PROGRESS_OBJECTNAME=" + System.getProperty("INIT_CONFIG_PROGRESS_OBJECTNAME"));
        String[] theCmdArgs = theCmdLine.toArray(new String[0]);
        try {
            theProcess = Runtime.getRuntime().exec(theCmdArgs, theEnv.toArray(new String[0]));
        }
        catch (IOException theEx) {
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CHECK_INSTALL_IMAGE", (Object[])new Object[0]), Msg.get((String)"COULD_NOT_INVOKE", (Object[])new Object[]{theCmdLine.toString()}), null);
        }
        ResultReportReaderThread theResultReader = new ResultReportReaderThread(theProcess.getInputStream(), theProcess.getErrorStream());
        Thread theReaderThread = new Thread(theResultReader);
        theReaderThread.setName("ResultReportReader:RESET:" + this.gName);
        theReaderThread.start();
        try {
            theReaderThread.join(1000000L);
        }
        catch (InterruptedException theEx) {
            LOGGER.log(Level.WARNING, "CONFIG_LOG_OUTPUT", "component=" + this.gName);
            LOGGER.log(Level.WARNING, theResultReader.getAllOutput());
            return new ResultReport(ResultReport.ResultStatus.FAIL, null, Msg.get((String)"CHECK_CONFIG", (Object[])new Object[0]), Msg.get((String)"CONFIG_TIMED_OUT", (Object[])new Object[]{this.gName, 1000}), null);
        }
        LOGGER.log(Level.FINE, "CONFIG_LOG_OUTPUT", "component=" + this.gName);
        LOGGER.log(Level.FINE, theResultReader.getAllOutput());
        return theResultReader.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification aNotification, Object aHandback) {
        CLIConfigurator cLIConfigurator = this;
        synchronized (cLIConfigurator) {
            this.gWaitCount = 0;
        }
    }
}

