/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.oor;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.oor.ConfigType;
import org.openinstaller.provider.conf.oor.Constraint;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Scripting;
import org.openinstaller.util.substitution.SubstitutionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OORProp {
    private final String gName;
    private final ConfigType gType;
    private Object gDefaultValue;
    private Object gValue;
    private Object gPreviousValue;
    private Object gLoadedValue;
    private boolean gHasLoadedValue = false;
    private boolean gIsConfirmed = false;
    private final List<Constraint> gConstraints;
    private String gEval;
    private String gEvalEngine;
    private boolean gNillable;
    private boolean gTransient;
    private final String gSeparator;
    private static final String ERROR = "error=";
    private static final String ERRORLINE = "errorline=";
    private static final String FILE = "file=";
    private String gOnSetAction;
    private String gOnInvalidValueSetAction;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public OORProp(String aName, ConfigType aType, Object aDefaultValue, Object aCurrentValue, String aSep) {
        this.gName = aName;
        this.gType = aType;
        this.gSeparator = aSep;
        this.gDefaultValue = aDefaultValue;
        this.gValue = this.gPreviousValue = aCurrentValue;
        this.gNillable = true;
        this.gTransient = true;
        this.gConstraints = new ArrayList<Constraint>();
    }

    public String getName() {
        return this.gName;
    }

    public String getEval() {
        return this.gEval;
    }

    public void setEval(String aEval) {
        this.gEval = aEval;
    }

    public String getEvalEngine() {
        return this.gEvalEngine;
    }

    public void setEvalEngine(String aEvalEngine) {
        this.gEvalEngine = aEvalEngine;
    }

    public Object getDefaultValue() throws EnhancedException {
        Object theReturnValue = this.substitute();
        if (theReturnValue != null) {
            this.gDefaultValue = theReturnValue;
        }
        return this.gDefaultValue;
    }

    public ConfigType getType() {
        return this.gType;
    }

    public boolean isNillable() {
        return this.gNillable;
    }

    public void setNillable(boolean aNillable) {
        this.gNillable = aNillable;
    }

    public boolean isTransient() {
        return this.gTransient;
    }

    public void setTransient(boolean aTransient) {
        this.gTransient = aTransient;
    }

    public Object getPreviousValue() {
        return this.gPreviousValue;
    }

    public Object getValue() throws EnhancedException {
        if (!this.gIsConfirmed && this.gHasLoadedValue) {
            if (this.validate(this.gLoadedValue) == null) {
                this.gValue = this.gLoadedValue;
                this.gIsConfirmed = true;
            } else {
                this.gIsConfirmed = false;
            }
            this.gHasLoadedValue = false;
        }
        if (this.gIsConfirmed) {
            return this.gValue;
        }
        return this.getDefaultValue();
    }

    public boolean hasUnconfirmedValue() {
        return this.gHasLoadedValue;
    }

    public Object getUnconfirmedValue() throws EnhancedException {
        if (this.gHasLoadedValue) {
            return this.gLoadedValue;
        }
        return this.getValue();
    }

    public void setUnconfirmedValue(Object aValue) {
        this.gLoadedValue = aValue;
        this.gHasLoadedValue = true;
        this.gIsConfirmed = false;
    }

    public List<Constraint> getConstraints() {
        return this.gConstraints;
    }

    public Constraint setValue(Object aValue) throws EnhancedException {
        this.setUnconfirmedValue(aValue);
        Constraint theFailedConstraint = this.validate(aValue);
        if (theFailedConstraint == null) {
            this.gIsConfirmed = true;
        } else {
            this.gHasLoadedValue = false;
        }
        this.gValue = aValue;
        this.gPreviousValue = aValue;
        this.gHasLoadedValue = false;
        return theFailedConstraint;
    }

    public Constraint validate(Object aValue) throws EnhancedException {
        for (Constraint theConstraint : this.getConstraints()) {
            if (theConstraint.isValid(aValue)) continue;
            if (this.getOnInvalidValueSetAction() != null) {
                this.invokeScript(this.getOnInvalidValueSetAction());
            }
            return theConstraint;
        }
        if (this.getOnSetAction() != null) {
            this.invokeScript(this.getOnSetAction());
        }
        return null;
    }

    public BusResponse doAction() throws EnhancedException {
        BusResponse theResponse = new BusResponse();
        Interpreter theInterpreter = Scripting.getInterpreter();
        Throwable theBshError = null;
        try {
            try {
                theInterpreter.set("gSharedResponse", (Object)theResponse);
                theInterpreter.eval(this.getOnSetAction());
                theInterpreter.getNameSpace().invokeMethod("run", null, theInterpreter);
            }
            catch (TargetError theTargetError) {
                Throwable theCause = theTargetError.getTarget();
                theBshError = theCause;
                throw new EnhancedException("SCRIPT_FAILED", theCause, new String[]{"component=" + this.getName(), ERROR + theTargetError.getErrorText(), ERRORLINE + theTargetError.getErrorLineNumber(), FILE + theTargetError.getErrorSourceFile()});
            }
            catch (EvalError theEvalError) {
                theBshError = theEvalError;
                throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theEvalError.getCause(), new String[]{"component=" + this.getName(), ERROR + theEvalError.getErrorText(), ERRORLINE + theEvalError.getErrorLineNumber(), FILE + theEvalError.getErrorSourceFile()});
            }
            catch (Exception theEx) {
                theBshError = theEx;
                throw new EnhancedException("SCRIPT_FAILED", (Throwable)theEx, new String[]{"component=" + this.getName()});
            }
        }
        catch (Exception theEx) {
            throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theBshError, new String[]{"component=" + this.getName()});
        }
        return theResponse;
    }

    private void invokeScript(String aScript) throws EnhancedException {
        try {
            try {
                LOGGER.finest(ClassUtils.getFQMethodName() + " called by " + ClassUtils.getFQCallingMethodName());
                Interpreter theInterp = Scripting.getInterpreter();
                theInterp.set("thisProperty", (Object)this);
                LOGGER.finest("The script is " + aScript);
                Object theReturnVal = theInterp.eval(aScript);
                LOGGER.log(Level.FINE, ClassUtils.getFQMethodName() + ": Script returned " + theReturnVal);
            }
            catch (TargetError theTargetError) {
                Throwable theCause = theTargetError.getTarget();
                throw new EnhancedException("SCRIPT_FAILED", theCause, new String[]{ERROR + theTargetError.getErrorText(), ERRORLINE + theTargetError.getErrorLineNumber(), FILE + theTargetError.getErrorSourceFile()});
            }
            catch (ParseException theParseException) {
                throw new EnhancedException("SCRIPT_UNPARSEABLE", (Throwable)theParseException, new String[]{ERROR + theParseException.getErrorText(), ERRORLINE + theParseException.getErrorLineNumber(), FILE + theParseException.getErrorSourceFile()});
            }
            catch (EvalError theEvalError) {
                throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", theEvalError.getCause(), new String[]{ERROR + theEvalError.getErrorText(), ERRORLINE + theEvalError.getErrorLineNumber(), FILE + theEvalError.getErrorSourceFile()});
            }
        }
        catch (Exception theEx) {
            throw new EnhancedException("SCRIPT_NOT_INVOKEABLE", (Throwable)theEx, new String[]{"component=" + this.getName()});
        }
    }

    public void addConstraint(Constraint aConstraint) {
        this.gConstraints.add(aConstraint);
    }

    public String getSeparator() {
        return this.gSeparator;
    }

    public String getOnSetAction() {
        return this.gOnSetAction;
    }

    public void setOnSetAction(String aOnSetAction) {
        this.gOnSetAction = aOnSetAction;
    }

    public String getOnInvalidValueSetAction() {
        return this.gOnInvalidValueSetAction;
    }

    public void setOnInvalidValueSetAction(String aOnInvalidValueSetAction) {
        this.gOnInvalidValueSetAction = aOnInvalidValueSetAction;
    }

    private Object substitute() throws EnhancedException {
        String theReturnValue;
        block12: {
            theReturnValue = null;
            try {
                if (this.gEval != null) {
                    theReturnValue = SubstitutionEngine.resolve((String)this.gEval);
                }
            }
            catch (EnhancedException theEx) {
                LOGGER.log(Level.FINE, "SUBSTITUTION_EXCEPTION", theEx);
                this.gEval = null;
            }
            try {
                if (this.gEvalEngine == null) break block12;
                Object[] theArgsObject = null;
                try {
                    Class<?> theEvalEngineClass = Class.forName(this.gEvalEngine);
                    Class[] theArgsClass = new Class[]{String.class, String.class};
                    theArgsObject = new Object[]{theReturnValue, this.gDefaultValue};
                    Object theEvalEngineObject = theEvalEngineClass.newInstance();
                    Method theResolveMethod = theEvalEngineClass.getMethod("resolve", theArgsClass);
                    theReturnValue = (String)theResolveMethod.invoke(theEvalEngineObject, theArgsObject);
                    this.gEval = null;
                    this.gEvalEngine = null;
                }
                catch (ClassNotFoundException theException) {
                    throw new EnhancedException("EVALENGINE_INVOCATION_ERROR", (Throwable)theException, new String[]{"engine=" + this.gEvalEngine, "args=" + Arrays.toString(theArgsObject)});
                }
                catch (InstantiationException theException) {
                    throw new EnhancedException("EVALENGINE_INVOCATION_ERROR", (Throwable)theException, new String[]{"engine=" + this.gEvalEngine, "args=" + Arrays.toString(theArgsObject)});
                }
                catch (NoSuchMethodException theException) {
                    throw new EnhancedException("EVALENGINE_INVOCATION_ERROR", (Throwable)theException, new String[]{"engine=" + this.gEvalEngine, "args=" + Arrays.toString(theArgsObject)});
                }
                catch (IllegalAccessException theException) {
                    throw new EnhancedException("EVALENGINE_INVOCATION_ERROR", (Throwable)theException, new String[]{"engine=" + this.gEvalEngine, "args=" + Arrays.toString(theArgsObject)});
                }
                catch (InvocationTargetException theException) {
                    throw new EnhancedException("EVALENGINE_INVOCATION_ERROR", (Throwable)theException, new String[]{"engine=" + this.gEvalEngine, "args=" + Arrays.toString(theArgsObject)});
                }
            }
            catch (EnhancedException theEx) {
                LOGGER.log(Level.FINE, "SUBSTITUTION_EXCEPTION", theEx);
                this.gEvalEngine = null;
            }
        }
        if (theReturnValue != null) {
            return ConfigHelper.thaw(theReturnValue, this.gType);
        }
        return null;
    }
}

