/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.regex.Pattern;

public class KeyValueStringPair {
    private String gKey;
    private String gValue;
    private static final char SEPARATOR = ',';

    protected KeyValueStringPair() {
    }

    protected KeyValueStringPair(String aCompactForm) {
        this.setCompactForm(aCompactForm);
    }

    protected KeyValueStringPair(String aKey, String aValue) {
        this.setKey(aKey);
        this.setValue(aValue);
    }

    public final String getCompactForm() {
        return KeyValueStringPair.encode(this.getKey()) + KeyValueStringPair.encode(this.getValue());
    }

    protected final void setCompactForm(String aCompactForm) {
        this.decode(aCompactForm);
    }

    protected final String getKey() {
        return this.gKey;
    }

    protected void setKey(String aKey) {
        this.gKey = aKey;
    }

    protected final String getValue() {
        return this.gValue;
    }

    protected void setValue(String aValue) {
        this.gValue = aValue;
    }

    protected static final String encode(String aInput) {
        Pattern theP = Pattern.compile(String.valueOf(','));
        StringBuilder theEncoded = new StringBuilder();
        if (aInput == null || aInput.length() == 0) {
            theEncoded.append(String.valueOf(','));
            theEncoded.append('0');
            theEncoded.append(String.valueOf(','));
        } else {
            String[] theItems = theP.split(aInput, -1);
            theEncoded.append(String.valueOf(','));
            theEncoded.append(theItems.length);
            theEncoded.append(String.valueOf(','));
            for (int theI = 0; theI < theItems.length; ++theI) {
                theEncoded.append(theItems[theI]);
                if (theI >= theItems.length - 1) continue;
                theEncoded.append(String.valueOf(','));
                theEncoded.append(String.valueOf(','));
            }
        }
        return theEncoded.toString();
    }

    protected final void decode(String aInput) {
        String theStrHeaderPattern = String.valueOf(',') + "\\d++" + String.valueOf(',');
        Pattern thePHeader = Pattern.compile(theStrHeaderPattern);
        String[] theItems = thePHeader.split(aInput, -1);
        this.setKey(this.unpad(theItems[1], ','));
        if (theItems.length > 2) {
            this.setValue(this.unpad(theItems[2], ','));
        } else {
            this.setValue(null);
        }
    }

    protected final String concat(String aSubstrate, String aAddon) {
        return aSubstrate + KeyValueStringPair.encode(aAddon);
    }

    private String unpad(String aInput, char aSep) {
        String theStrPaddedPattern = String.valueOf(aSep) + String.valueOf(aSep);
        Pattern thePPadded = Pattern.compile(theStrPaddedPattern);
        StringBuilder theResult = new StringBuilder();
        String[] theSubItems = thePPadded.split(aInput, -1);
        for (int theI = 0; theI < theSubItems.length; ++theI) {
            theResult.append(theSubItems[theI]);
            if (theI >= theSubItems.length - 1) continue;
            theResult.append(String.valueOf(aSep));
        }
        return theResult.toString();
    }
}

