/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.AbstractListModel;
import charvax.swing.DefaultListModel;
import charvax.swing.DefaultListSelectionModel;
import charvax.swing.JComponent;
import charvax.swing.JViewport;
import charvax.swing.ListModel;
import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class JList
extends JComponent
implements Scrollable {
    private int _visibleRows = 5;
    private int _columns = 10;
    private int _caret = 0;
    private int _visibleColumns = this._columns;
    protected int _currentRow = 0;
    protected ListSelectionModel _selectionModel = new DefaultListSelectionModel();
    protected ListModel _listModel;
    private Vector _scrollListeners = null;

    public JList() {
        this.setModel(new DefaultListModel());
    }

    public JList(ListModel model_) {
        this.setModel(model_);
    }

    public JList(Object[] items_) {
        this.setListData(items_);
    }

    public JList(Vector items_) {
        this.setListData(items_);
    }

    public void setListData(Object[] listData_) {
        DefaultListModel model = new DefaultListModel();
        for (int i = 0; i < listData_.length; ++i) {
            model.addElement(listData_[i]);
        }
        this.setModel(model);
    }

    public void setListData(Vector listData_) {
        Enumeration e = listData_.elements();
        DefaultListModel model = new DefaultListModel();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            model.addElement(item);
        }
        this.setModel(model);
    }

    public void setModel(ListModel model_) {
        this._listModel = model_;
        this._selectionModel.clearSelection();
        ((AbstractListModel)this._listModel)._selection = this._selectionModel;
    }

    public ListModel getModel() {
        return this._listModel;
    }

    public void setVisibleRowCount(int rows_) {
        this._visibleRows = rows_;
    }

    public int getVisibleRowCount() {
        return this._visibleRows;
    }

    public void setVisibleColumnCount(int columns_) {
        this._visibleColumns = columns_;
    }

    public int getVisibleColumnCount() {
        Insets insets = super.getInsets();
        return this._visibleColumns + insets.left + insets.right;
    }

    public void setColumns(int cols_) {
        this._columns = cols_;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return this._listModel.getSize() + insets.top + insets.bottom;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getVisibleColumnCount(), this.getVisibleRowCount());
    }

    public void setSelectionModel(ListSelectionModel model_) {
        this._selectionModel = model_;
    }

    public ListSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void addListSelectionListener(ListSelectionListener il_) {
        this._selectionModel.addListSelectionListener(il_);
    }

    public void removeListSelectionListener(ListSelectionListener listener_) {
        this._selectionModel.removeListSelectionListener(listener_);
    }

    public int getSelectedIndex() {
        return this._selectionModel.getMinSelectionIndex();
    }

    public int[] getSelectedIndices() {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        if (!this._selectionModel.isSelectionEmpty()) {
            int first = this._selectionModel.getMinSelectionIndex();
            int last = this._selectionModel.getMaxSelectionIndex();
            for (int i = first; i <= last; ++i) {
                if (!this._selectionModel.isSelectedIndex(i)) continue;
                objects.add(new Integer(i));
            }
        }
        int[] values = new int[objects.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Integer)objects.get(i);
        }
        return values;
    }

    public Object getSelectedValue() {
        int index = this._selectionModel.getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this._listModel.getElementAt(index);
    }

    public Object[] getSelectedValues() {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (!this._selectionModel.isSelectionEmpty()) {
            int first = this._selectionModel.getMinSelectionIndex();
            int last = this._selectionModel.getMaxSelectionIndex();
            for (int i = first; i <= last; ++i) {
                if (!this._selectionModel.isSelectedIndex(i)) continue;
                objects.add(this._listModel.getElementAt(i));
            }
        }
        return objects.toArray();
    }

    public synchronized void ensureIndexIsVisible(int index_) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        if (index_ < 0) {
            index_ = 0;
        } else if (index_ > this._listModel.getSize() - 1) {
            index_ = this._listModel.getSize() - 1;
        }
        this._currentRow = index_;
        Toolkit term = Toolkit.getDefaultToolkit();
        EventQueue evtqueue = term.getSystemEventQueue();
        evtqueue.postEvent(new ScrollEvent(this, 103, new Point(0, 0)));
        evtqueue.postEvent(new ScrollEvent(this, 102, new Point(0, index_)));
    }

    public void setSelectedIndex(int index_) {
        this._selectionModel.setSelectionInterval(index_, index_);
    }

    public void addSelectionInterval(int index0_, int index1_) {
        this._selectionModel.addSelectionInterval(index0_, index1_);
    }

    public void removeSelectionInterval(int index0_, int index1_) {
        this._selectionModel.removeSelectionInterval(index0_, index1_);
    }

    public void clearSelection() {
        this._selectionModel.clearSelection();
    }

    public int getMinSelectionIndex() {
        return this._selectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this._selectionModel.getMaxSelectionIndex();
    }

    public void setSelectionMode(int mode_) {
        this._selectionModel.setSelectionMode(mode_);
    }

    public int getSelectionMode() {
        return this._selectionModel.getSelectionMode();
    }

    public boolean isIndexSelected(int index_) {
        return this._selectionModel.isSelectedIndex(index_);
    }

    public Dimension minimumSize() {
        this._columns = 1;
        for (int i = 0; i < this._listModel.getSize(); ++i) {
            String c = this._listModel.getElementAt(i).toString();
            if (c.length() <= this._columns) continue;
            this._columns = c.length();
        }
        Insets insets = super.getInsets();
        return new Dimension(this._columns + insets.left + insets.right, this._visibleRows + insets.top + insets.bottom);
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        if (this.getParent() instanceof JViewport && origin.x >= ((JViewport)this.getParent()).getLocationOnScreen().x) {
            Toolkit.getDefaultToolkit().setCursor(origin.addOffset(0, this._currentRow));
        } else {
            Toolkit.getDefaultToolkit().setCursor(origin.addOffset(this._caret, this._currentRow));
        }
    }

    public void draw() {
        int i;
        if (this._currentRow >= this._listModel.getSize()) {
            this._currentRow = this._listModel.getSize() == 0 ? 0 : this._listModel.getSize() - 1;
        }
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        StringBuffer blanks = new StringBuffer();
        for (int j = 0; j < this._columns; ++j) {
            blanks.append(' ');
        }
        for (i = 0; i < this._listModel.getSize(); ++i) {
            term.setCursor(origin.x, origin.y + i);
            int attribute = this.isIndexSelected(i) ? Toolkit.A_REVERSE : 0;
            if (i == this._currentRow) {
                attribute += Toolkit.A_BOLD;
            }
            String item = this._listModel.getElementAt(i).toString();
            StringBuffer buffer = new StringBuffer(item);
            for (int k = item.length(); k < this._columns; ++k) {
                buffer.append(' ');
            }
            term.addString(buffer.toString(), attribute, colorpair);
        }
        for (i = this._listModel.getSize(); i < this._visibleRows; ++i) {
            term.setCursor(origin.x, origin.y + i);
            term.addString(blanks.toString(), 0, colorpair);
        }
        term.setCursor(this._caret + origin.x, origin.y + this._currentRow);
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        Toolkit term = Toolkit.getDefaultToolkit();
        Point cursor = term.getCursor();
        EventQueue evtqueue = term.getSystemEventQueue();
        int key = ke_.getKeyCode();
        switch (key) {
            case 9: {
                this.getParent().nextFocus();
                return;
            }
            case 353: {
                this.getParent().previousFocus();
                return;
            }
            case 258: {
                if (this._currentRow >= this._listModel.getSize() - 1) {
                    return;
                }
                evtqueue.postEvent(new ScrollEvent(this, 102, new Point(0, ++this._currentRow)));
                break;
            }
            case 338: {
                this._currentRow += this._visibleRows;
                if (this._currentRow >= this._listModel.getSize()) {
                    this._currentRow = this._listModel.getSize() - 1;
                }
                evtqueue.postEvent(new ScrollEvent(this, 102, new Point(0, this._currentRow)));
                break;
            }
            case 360: {
                this._currentRow = this._listModel.getSize() - 1;
                evtqueue.postEvent(new ScrollEvent(this, 102, new Point(0, this._currentRow)));
                break;
            }
            case 259: {
                if (this._currentRow < 1) {
                    return;
                }
                evtqueue.postEvent(new ScrollEvent(this, 103, new Point(0, --this._currentRow)));
                break;
            }
            case 339: {
                this._currentRow -= this._visibleRows;
                if (this._currentRow < 0) {
                    this._currentRow = 0;
                }
                evtqueue.postEvent(new ScrollEvent(this, 103, new Point(0, this._currentRow)));
                break;
            }
            case 343: {
                this._doSelect();
                break;
            }
            case 262: {
                this._currentRow = 0;
                break;
            }
            case 261: {
                if (!(this.getParent() instanceof JViewport)) break;
                if (this._caret <= this.getVisibleColumnCount() - 2) {
                    cursor.translate(1, 0);
                    term.setCursor(cursor);
                    ++this._caret;
                    break;
                }
                if (this._caret >= ((String)this._listModel.getElementAt(this._currentRow)).length() - 1) break;
                evtqueue.postEvent(new ScrollEvent(this, 100, new Point(this._caret + 1, cursor.y)));
                ++this._caret;
                break;
            }
            case 260: {
                if (!(this.getParent() instanceof JViewport)) break;
                if (term.getCursor().x <= ((JViewport)this.getParent()).getLocationOnScreen().x && this._caret - 1 != -1) {
                    evtqueue.postEvent(new ScrollEvent(this, 101, new Point(this._caret - 1, cursor.y)));
                    --this._caret;
                    break;
                }
                if (this._caret <= 0) break;
                cursor.translate(-1, 0);
                term.setCursor(cursor);
                --this._caret;
            }
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    private void _doSelect() {
        if (this._listModel.getSize() == 0) {
            return;
        }
        if (this.isIndexSelected(this._currentRow)) {
            this.removeSelectionInterval(this._currentRow, this._currentRow);
        } else {
            int mode = this.getSelectionMode();
            if (mode == 201) {
                this.setSelectedIndex(this._currentRow);
            } else {
                this.addSelectionInterval(this._currentRow, this._currentRow);
            }
        }
        this.repaint();
    }

    public void processMouseEvent(MouseEvent e_) {
        super.processMouseEvent(e_);
        if (e_.getButton() == 1 && e_.getModifiers() == 102 && this.isFocusTraversable()) {
            if (e_.getClickCount() == 1) {
                int y = e_.getY();
                Point origin = this.getLocationOnScreen();
                Container parent = this.getParent();
                if (parent instanceof JViewport) {
                    this._currentRow = y - origin.y;
                    this.repaint();
                }
            } else {
                this._doSelect();
            }
        }
    }

    public void addScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(sl_);
    }

    public void removeScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(sl_);
    }

    public void processScrollEvent(ScrollEvent e_) {
        if (this._scrollListeners != null) {
            Enumeration e = this._scrollListeners.elements();
            while (e.hasMoreElements()) {
                ScrollListener sl = (ScrollListener)e.nextElement();
                sl.scroll(e_);
            }
        }
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JList origin=" + this._origin + " size=" + this.minimumSize());
    }
}

