/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Adjustable;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AdjustmentEvent;
import charva.awt.event.AdjustmentListener;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JScrollBar
extends JComponent
implements Adjustable {
    private int _orientation = 200;
    private int _minimum = 0;
    private int _value = 0;
    private int _extent = 10;
    private int _maximum = 100;
    private int _blockIncrement = 10;
    private int _length = 12;
    protected Vector _adjustmentListeners = null;

    public JScrollBar() {
    }

    public JScrollBar(int orientation_) {
        this.setOrientation(orientation_);
    }

    public JScrollBar(int orientation_, int value_, int extent_, int min_, int max_) {
        this.setOrientation(orientation_);
        if (min_ > value_ || extent_ < 0 || value_ + extent_ > max_) {
            throw new IllegalArgumentException("invalid values for scrollbar");
        }
        this._minimum = min_;
        this._value = value_;
        this._blockIncrement = this._extent = extent_;
        this._maximum = max_;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setMinimum(int min_) {
        this._minimum = min_;
        if (this._maximum <= this._minimum) {
            this._maximum = this._minimum + 1;
        }
        if (this._value < this._minimum) {
            this._value = this._minimum;
        }
        if (this._value + this._extent > this._maximum) {
            this._extent = this._maximum - this._value;
        }
    }

    public void setValue(int value_) {
        this._value = value_ < this._minimum ? this._minimum : (value_ > this._maximum - this._extent ? this._maximum - this._extent : value_);
        this.repaint();
    }

    public void setVisibleAmount(int extent_) {
        this._extent = this._value + this._extent > this._maximum ? this._maximum - this._value : extent_;
    }

    public void setMaximum(int max_) {
        this._maximum = max_;
        if (this._minimum > this._maximum) {
            this._minimum = this._maximum - 1;
        }
        if (this._value > this._maximum) {
            this._value = this._maximum;
        }
        if (this._value + this._extent > this._maximum) {
            this._extent = this._maximum - this._value;
        }
    }

    public void setBlockIncrement(int val_) {
        this._blockIncrement = val_;
    }

    public void setSize(Dimension size_) {
        this._length = this._orientation == 200 ? size_.height : size_.width;
        if (this._length < 3) {
            throw new IllegalArgumentException("length of scrollbar must be at least 3");
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this._orientation == 200 ? 1 : this._length;
    }

    public int getHeight() {
        return this._orientation == 200 ? this._length : 1;
    }

    public void draw() {
        block6: {
            Point origin = this.getLocationOnScreen();
            Toolkit term = Toolkit.getDefaultToolkit();
            int colorpair = this.getCursesColor();
            if (!this._enabled) break block6;
            int offset = this._value * (this._length - 2) / this._maximum;
            int visible = this._extent * (this._length - 2) / this._maximum;
            int n = visible = visible == 0 ? 1 : visible;
            if (this._orientation == 200) {
                term.setCursor(origin);
                term.addChar(94, Toolkit.A_REVERSE, colorpair);
                for (int k = 1; k < this._length - 1; ++k) {
                    term.setCursor(origin.addOffset(0, k));
                    term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
                }
                term.setCursor(origin.addOffset(0, this._length - 1));
                term.addChar(118, Toolkit.A_REVERSE, colorpair);
                for (int i = 0; i < visible; ++i) {
                    term.setCursor(origin.addOffset(0, 1 + offset + i));
                    term.addChar(32, Toolkit.A_REVERSE, colorpair);
                }
            } else {
                term.setCursor(origin);
                term.addChar(60, Toolkit.A_REVERSE, colorpair);
                for (int k = 1; k < this._length - 1; ++k) {
                    term.setCursor(origin.addOffset(k, 0));
                    term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
                }
                term.setCursor(origin.addOffset(this._length - 1, 0));
                term.addChar(62, Toolkit.A_REVERSE, colorpair);
                for (int i = 0; i < visible; ++i) {
                    term.setCursor(origin.addOffset(1 + offset + i, 0));
                    term.addChar(32, Toolkit.A_REVERSE, colorpair);
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (key == 260 && this._orientation == 201 || key == 259 && this._orientation == 200) {
            int newvalue = this._value - this._blockIncrement;
            this.setValue(newvalue);
            AdjustmentEvent ae = new AdjustmentEvent(this, this._value);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ae);
        } else if (key == 261 && this._orientation == 201 || key == 258 && this._orientation == 200) {
            int newvalue = this._value + this._blockIncrement;
            this.setValue(newvalue);
            AdjustmentEvent ae = new AdjustmentEvent(this, this._value);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ae);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        int offset = this._value * (this._length - 2) / this._maximum;
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(1 + offset, 0));
    }

    public void addAdjustmentListener(AdjustmentListener listener_) {
        if (this._adjustmentListeners == null) {
            this._adjustmentListeners = new Vector();
        }
        this._adjustmentListeners.add(listener_);
    }

    public void removeAdjustmentListener(AdjustmentListener listener_) {
        if (this._adjustmentListeners == null) {
            return;
        }
        this._adjustmentListeners.remove(listener_);
    }

    public void processAdjustmentEvent(AdjustmentEvent evt_) {
        if (this._adjustmentListeners != null) {
            Enumeration e = this._adjustmentListeners.elements();
            while (e.hasMoreElements()) {
                AdjustmentListener al = (AdjustmentListener)e.nextElement();
                al.adjustmentValueChanged(evt_);
            }
        }
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JScrollBar origin=" + this._origin + " size=" + this.getSize() + " value=" + this._value + " extent=" + this._extent + " minimum=" + this._minimum + " maximum=" + this._maximum);
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getMinimum() {
        return this._minimum;
    }

    public int getValue() {
        return this._value;
    }

    public int getVisibleAmount() {
        return this._extent;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public int getBlockIncrement() {
        return this._blockIncrement;
    }

    private void setOrientation(int orientation_) {
        if (orientation_ != 200 && orientation_ != 201) {
            throw new IllegalArgumentException("Orientation must be VERTICAL or HORIZONTAL");
        }
        this._orientation = orientation_;
    }
}

