/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.LogThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecuteCommand {
    private boolean gWaitFor = true;
    private boolean gCollectOutput = false;
    private String[] gErrorLogFiles = null;
    private String[] gOutputLogFiles = null;
    private int gOutputType = 0;
    public static final int NORMAL = 1;
    public static final int ERRORS = 2;
    private int gResult = -1;
    private StringBuffer gOutput = new StringBuffer();
    private StringBuffer gErrors = new StringBuffer();
    private StringBuffer gBoth = new StringBuffer();
    private boolean gState = false;
    private String gErrorMessage = null;
    private InputStream gStdin = null;
    private Map<String, String> gEnv = null;
    private String[] gCommand = null;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public void setStdin(InputStream aStdin) {
        this.gStdin = aStdin;
    }

    public InputStream getStdin() {
        return this.gStdin;
    }

    public boolean getCollectOutput() {
        return this.gCollectOutput;
    }

    public void setResult(int aResult) {
        this.gResult = aResult;
    }

    public void setCollectOutput(boolean aOutput) {
        this.gCollectOutput = aOutput;
    }

    public void setOutputType(int aType) {
        this.gOutputType = aType;
    }

    public void setCommand(String[] aArgs) {
        this.gCommand = (String[])aArgs.clone();
    }

    public static String expandCommand(String[] aCmd) {
        StringBuilder theScmd = new StringBuilder();
        for (String theCmdPart : aCmd) {
            theScmd.append(theCmdPart);
            theScmd.append(" ");
        }
        return theScmd.toString().trim();
    }

    public String[] getCommand() {
        return (String[])this.gCommand.clone();
    }

    public void putEnvironmentSetting(String aSetting, String aVal) throws EnhancedException {
        if (this.gEnv == null) {
            this.gEnv = new Hashtable<String, String>();
        }
        if (aSetting == null) {
            throw new EnhancedException("EXECMD_PUT_ENVIR_SET_CANT_BE_NULL", new String[0]);
        }
        if (aVal == null) {
            this.gEnv.remove(aSetting);
        } else {
            this.gEnv.put(aSetting, aVal);
        }
    }

    public String removeEnvironmentSetting(String aSetting) throws EnhancedException {
        if (aSetting == null) {
            throw new EnhancedException("EXE_CMD_CANT_BE_NULL", new String[0]);
        }
        if (this.gEnv == null) {
            return null;
        }
        return this.gEnv.remove(aSetting);
    }

    public void setLogFiles(String[] aLogFiles) {
        this.addLogFiles(3, aLogFiles);
    }

    public void addLogFiles(int aType, String[] aNewFiles) {
        String[] theTmp;
        if (aNewFiles == null) {
            return;
        }
        if ((aType & 1) != 0) {
            if (this.gOutputLogFiles == null) {
                this.gOutputLogFiles = (String[])aNewFiles.clone();
            } else {
                theTmp = this.gOutputLogFiles;
                this.gOutputLogFiles = new String[theTmp.length + aNewFiles.length];
                System.arraycopy(theTmp, 0, this.gOutputLogFiles, 0, theTmp.length);
                System.arraycopy(aNewFiles, 0, this.gOutputLogFiles, theTmp.length, aNewFiles.length);
            }
        }
        if ((aType & 2) != 0) {
            if (this.gErrorLogFiles == null) {
                this.gErrorLogFiles = (String[])aNewFiles.clone();
            } else {
                theTmp = this.gErrorLogFiles;
                this.gErrorLogFiles = new String[theTmp.length + aNewFiles.length];
                System.arraycopy(theTmp, 0, this.gErrorLogFiles, 0, theTmp.length);
                System.arraycopy(aNewFiles, 0, this.gErrorLogFiles, theTmp.length, aNewFiles.length);
            }
        }
    }

    public ExecuteCommand(String aCommand) throws InvalidArgumentException {
        this(aCommand, null);
    }

    public ExecuteCommand(String[] aCommand) throws InvalidArgumentException {
        this("", null);
        this.setCommand(aCommand);
    }

    public ExecuteCommand(String aCommand, InputStream aStdin) throws InvalidArgumentException {
        this(aCommand, aStdin, null, 3);
    }

    public ExecuteCommand(String aCommand, InputStream aStdin, String[] aLogOutputFiles, int aWhich) throws InvalidArgumentException {
        if (aCommand == null) {
            throw new InvalidArgumentException("ILLEGAL_ARGUMENT_NULL", "arg=aCommand");
        }
        this.setStdin(aStdin);
        this.setCollectOutput(true);
        this.setOutputType(aWhich);
        this.setCommand(aCommand.split("\\s+"));
        this.setLogFiles(aLogOutputFiles);
    }

    private static String[] createEnvArray(Map<String, String> aEnv) {
        if (aEnv == null) {
            return null;
        }
        Set<String> theKeys = aEnv.keySet();
        String[] theResult = new String[aEnv.size()];
        int theIndx = 0;
        for (String theNextKey : theKeys) {
            String theNextVal = aEnv.get(theNextKey);
            theResult[theIndx++] = theNextKey + "=" + theNextVal;
        }
        return theResult;
    }

    public void execute() throws EnhancedException {
        try {
            String[] theEnvArray = ExecuteCommand.createEnvArray(this.gEnv);
            if (this.gCommand == null) {
                throw new EnhancedException("CMD_TO_EXECUTE_IS_NULL", new String[0]);
            }
            Process theProcess = Runtime.getRuntime().exec(this.gCommand, theEnvArray);
            if (!this.gWaitFor) {
                this.gState = true;
                this.gResult = 0;
                return;
            }
            if (theProcess != null) {
                LogThread theFeeder = null;
                if (this.gStdin != null) {
                    theFeeder = new LogThread(this.gStdin, theProcess.getOutputStream());
                    theFeeder.setName("Feeder");
                    theFeeder.start();
                }
                if (this.gCollectOutput) {
                    this.readOutput(theProcess);
                } else {
                    this.gResult = theProcess.waitFor();
                }
                if (theFeeder != null) {
                    theFeeder.join();
                }
                theProcess.getInputStream().close();
                theProcess.getOutputStream().close();
                theProcess.getErrorStream().close();
                theProcess.destroy();
                this.gState = true;
            }
        }
        catch (IOException theIoe) {
            throw new EnhancedException("EXECUTECMD_ERR", (Throwable)theIoe, "command=" + Arrays.toString(this.gCommand));
        }
        catch (InterruptedException theIex) {
            throw new EnhancedException("EXEC_CMD_INTERRUPTED", (Throwable)theIex, "command=" + Arrays.toString(this.gCommand));
        }
    }

    public String getErrorMessage() {
        return this.gErrorMessage;
    }

    public boolean getState() {
        return this.gState;
    }

    public void setState(boolean aState) {
        this.gState = aState;
    }

    public int getResult() {
        return this.gResult;
    }

    public void setErrorMessage(String aErrMsg) {
        this.gErrorMessage = aErrMsg;
    }

    public String getOutput() {
        return this.gOutput.toString();
    }

    public String getErrors() {
        return this.gErrors.toString();
    }

    public String getAllOutput() {
        return this.gBoth.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readOutput(Process aProcess) throws EnhancedException {
        OutputStream[] theOuts;
        int theCurrentLog;
        ByteArrayOutputStream theBout = new ByteArrayOutputStream();
        ByteArrayOutputStream theBerr = new ByteArrayOutputStream();
        ByteArrayOutputStream theBboth = new ByteArrayOutputStream();
        DataInputStream theDin = new DataInputStream(aProcess.getInputStream());
        DataInputStream theDerr = new DataInputStream(aProcess.getErrorStream());
        FileOutputStream[] theOutLogs = null;
        OutputStream[] theOutOutputStreams = null;
        FileOutputStream[] theErrorLogs = null;
        OutputStream[] theErrorOutputStreams = null;
        if (this.gOutputLogFiles != null) {
            theOutLogs = new FileOutputStream[this.gOutputLogFiles.length];
            theOutOutputStreams = new DataOutputStream[this.gOutputLogFiles.length];
            try {
                for (theCurrentLog = 0; theCurrentLog < this.gOutputLogFiles.length; ++theCurrentLog) {
                    theOutLogs[theCurrentLog] = new FileOutputStream(this.gOutputLogFiles[theCurrentLog], true);
                    theOutOutputStreams[theCurrentLog] = new DataOutputStream(theOutLogs[theCurrentLog]);
                }
                if ((this.gOutputType & 1) != 0) {
                    this.gOutput.append("---> ").append(this.gOutputLogFiles[0]);
                    this.gBoth.append("---> ").append(this.gOutputLogFiles[0]);
                }
            }
            catch (IOException theIoe) {
                LOGGER.log(Level.FINE, "Cannot create log", theIoe);
                theOutLogs = null;
            }
        }
        if (this.gErrorLogFiles != null) {
            theErrorLogs = new FileOutputStream[this.gErrorLogFiles.length];
            theErrorOutputStreams = new DataOutputStream[this.gErrorLogFiles.length];
            try {
                for (theCurrentLog = 0; theCurrentLog < this.gErrorLogFiles.length; ++theCurrentLog) {
                    theErrorLogs[theCurrentLog] = new FileOutputStream(this.gErrorLogFiles[theCurrentLog], true);
                    theErrorOutputStreams[theCurrentLog] = new DataOutputStream(theErrorLogs[theCurrentLog]);
                }
                if ((this.gOutputType & 1) != 0) {
                    this.gOutput.append("---> ").append(this.gErrorLogFiles[0]);
                    this.gBoth.append("---> ").append(this.gErrorLogFiles[0]);
                }
            }
            catch (IOException theIoe) {
                LOGGER.log(Level.FINE, "Cannot create log", theIoe);
                theErrorLogs = null;
            }
        }
        LogThread theInReader = null;
        LogThread theErrReader = null;
        if ((this.gOutputType & 1) != 0) {
            if (theOutLogs == null) {
                theOuts = new ByteArrayOutputStream[]{theBout, theBboth};
                theInReader = new LogThread((InputStream)theDin, theOuts);
            } else {
                theInReader = new LogThread((InputStream)theDin, theOutOutputStreams);
            }
            theInReader.setName("STDIN Reader");
            theInReader.start();
        }
        if ((this.gOutputType & 2) != 0) {
            if (theErrorLogs == null) {
                theOuts = new ByteArrayOutputStream[]{theBerr, theBboth};
                theErrReader = new LogThread((InputStream)theDerr, theOuts);
            } else {
                theErrReader = new LogThread((InputStream)theDerr, theErrorOutputStreams);
            }
            theErrReader.setName("STDERR Reader");
            theErrReader.start();
        }
        this.gResult = aProcess.waitFor();
        if (theInReader != null) {
            theInReader.join();
        }
        if (theErrReader != null) {
            theErrReader.join();
        }
        theDin.close();
        theDerr.close();
        this.gOutput = new StringBuffer().append(theBout.toString());
        this.gErrors = new StringBuffer().append(theBerr.toString());
        this.gBoth = new StringBuffer().append(theBboth.toString());
        Object var15_20 = null;
        try {
            if (theOutOutputStreams != null) {
                for (OutputStream outputStream : theOutOutputStreams) {
                    ((DataOutputStream)outputStream).flush();
                    ((FilterOutputStream)outputStream).close();
                }
            }
        }
        catch (IOException theEx2) {
            LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
        }
        try {
            if (theErrorOutputStreams != null) {
                for (OutputStream outputStream : theErrorOutputStreams) {
                    ((DataOutputStream)outputStream).flush();
                    ((FilterOutputStream)outputStream).close();
                }
            }
        }
        catch (IOException theEx2) {
            LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
        }
        try {
            if (theOutLogs != null) {
                for (OutputStream outputStream : theOutLogs) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
        }
        catch (IOException theEx2) {
            LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
        }
        try {
            if (theErrorLogs == null) return;
            for (OutputStream outputStream : theErrorLogs) {
                outputStream.flush();
                ((FileOutputStream)outputStream).close();
            }
        }
        catch (IOException theEx2) {
            LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
            return;
        }
        return;
        {
            catch (InterruptedException theIex) {
                throw new EnhancedException("INTERRUPTED_WHEN_READING_OUTPUT", (Throwable)theIex, new String[0]);
            }
            catch (EOFException theEx) {
                Object var15_21 = null;
                try {
                    if (theOutOutputStreams != null) {
                        for (OutputStream outputStream : theOutOutputStreams) {
                            ((DataOutputStream)outputStream).flush();
                            ((FilterOutputStream)outputStream).close();
                        }
                    }
                }
                catch (IOException theEx2) {
                    LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
                }
                try {
                    if (theErrorOutputStreams != null) {
                        for (OutputStream outputStream : theErrorOutputStreams) {
                            ((DataOutputStream)outputStream).flush();
                            ((FilterOutputStream)outputStream).close();
                        }
                    }
                }
                catch (IOException theEx2) {
                    LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
                }
                try {
                    if (theOutLogs != null) {
                        for (OutputStream outputStream : theOutLogs) {
                            outputStream.flush();
                            ((FileOutputStream)outputStream).close();
                        }
                    }
                }
                catch (IOException theEx2) {
                    LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
                }
                try {
                    if (theErrorLogs == null) return;
                    for (OutputStream outputStream : theErrorLogs) {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    return;
                }
                catch (IOException theEx2) {
                    LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
                }
                return;
            }
            catch (IOException theEx) {
                throw new EnhancedException("EXECUTECMD_ERR", (Throwable)theEx, new String[0]);
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            try {
                if (theOutOutputStreams != null) {
                    for (OutputStream outputStream : theOutOutputStreams) {
                        ((DataOutputStream)outputStream).flush();
                        ((FilterOutputStream)outputStream).close();
                    }
                }
            }
            catch (IOException theEx2) {
                LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
            }
            try {
                if (theErrorOutputStreams != null) {
                    for (OutputStream outputStream : theErrorOutputStreams) {
                        ((DataOutputStream)outputStream).flush();
                        ((FilterOutputStream)outputStream).close();
                    }
                }
            }
            catch (IOException theEx2) {
                LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
            }
            try {
                if (theOutLogs != null) {
                    for (OutputStream outputStream : theOutLogs) {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                }
            }
            catch (IOException theEx2) {
                LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
            }
            try {
                if (theErrorLogs == null) throw throwable;
                for (OutputStream outputStream : theErrorLogs) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                throw throwable;
            }
            catch (IOException theEx2) {
                LOGGER.log(Level.FINE, "Cannot close stream", theEx2);
            }
            throw throwable;
        }
    }

    public static String[] executeScript(String[] aCmdStrings) throws IOException {
        Process theProc = Runtime.getRuntime().exec(aCmdStrings);
        return ExecuteCommand.getInputStrings(theProc.getInputStream());
    }

    public static String[] executeScript(String aCmdStrings) throws IOException {
        Process theProc = Runtime.getRuntime().exec(aCmdStrings);
        return ExecuteCommand.getInputStrings(theProc.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getInputStrings(InputStream aInputStream) {
        if (aInputStream == null) {
            return null;
        }
        BufferedReader theIn = null;
        ArrayList<String> theList = new ArrayList<String>();
        try {
            theIn = new BufferedReader(new InputStreamReader(aInputStream));
            String theStr = theIn.readLine();
            while (theStr != null) {
                theList.add(theStr);
                theStr = theIn.readLine();
            }
            if (theList.size() < 1) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = theList.toArray(new String[theList.size()]);
            return stringArray;
        }
        catch (Exception theEx) {
            LOGGER.log(Level.FINEST, "Can't read output from command, continuing.", theEx);
        }
        finally {
            try {
                if (theIn != null) {
                    theIn.close();
                }
            }
            catch (IOException theEx) {
                LOGGER.log(Level.FINEST, "Can't close input stream from command.", theEx);
            }
        }
        return null;
    }

    public static String getStringDelimited(String aInputStr, String aLeftHandDelim, String aRightHandDelim) {
        int theLeftIndex = aInputStr.indexOf(aLeftHandDelim);
        if (theLeftIndex == -1) {
            return "";
        }
        int theRightIndex = aInputStr.indexOf(aRightHandDelim);
        if (theRightIndex == -1) {
            return "";
        }
        int theLeftStart = theLeftIndex + aLeftHandDelim.length();
        if (theLeftStart > theRightIndex) {
            return "";
        }
        if (theRightIndex > aInputStr.length()) {
            return "";
        }
        return aInputStr.substring(theLeftStart, theRightIndex);
    }

    public void setWaitFor(boolean aWaitFor) {
        this.gWaitFor = aWaitFor;
    }
}

