/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CToolkit;
import apple.awt.ContainerModel;
import apple.awt.FlushEvent;
import java.awt.Component;
import java.util.Stack;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class CocoaEvent
extends PeerEvent {
    private static final String PRIORITY_PROCESSING_QUEUES_KEY = "apple.awt.PRIORITY_PROCESSING_QUEUES_KEY";
    protected static int kFlushPriority = 0;
    protected static int kPaintPriority = 1;
    private int fInternalPriority;

    protected CocoaEvent(Object object, Runnable runnable, long l, int n) {
        super(object, runnable, l);
        this.fInternalPriority = n;
    }

    public CocoaEvent(Object object, Runnable runnable) {
        super(object, runnable, 1L);
    }

    public void dispatch() {
        if (this.runnable != null) {
            super.dispatch();
        }
        this.runnable = null;
    }

    protected Component getTarget() {
        return null;
    }

    protected Object getEventTarget() {
        return null;
    }

    static void dispatchAllCocoaEventsForCurrentAppContext() {
        AppContext appContext = AppContext.getAppContext();
        Stack[] stackArray = CocoaEvent.getPriorityProcessingQueues(appContext);
        while (!stackArray[kFlushPriority].isEmpty() || !stackArray[kPaintPriority].isEmpty()) {
            if (!stackArray[kFlushPriority].isEmpty()) {
                ((CocoaEvent)stackArray[kFlushPriority].pop()).dispatch();
                continue;
            }
            if (stackArray[kPaintPriority].isEmpty()) continue;
            ((CocoaEvent)stackArray[kPaintPriority].pop()).dispatch();
        }
    }

    boolean postToQueue() {
        final Component component = this.getTarget();
        try {
            Stack stack = CocoaEvent.getPriorityProcessingQueues(component)[this.fInternalPriority];
            stack.push(this);
            Runnable runnable = new Runnable(){

                public void run() {
                    Stack[] stackArray = CocoaEvent.getPriorityProcessingQueues(component);
                    while (!stackArray[kFlushPriority].isEmpty() || !stackArray[kPaintPriority].isEmpty()) {
                        if (!stackArray[kFlushPriority].isEmpty()) {
                            ((CocoaEvent)stackArray[kFlushPriority].pop()).dispatch();
                            continue;
                        }
                        if (stackArray[kPaintPriority].isEmpty()) continue;
                        ((CocoaEvent)stackArray[kPaintPriority].pop()).dispatch();
                    }
                }
            };
            CToolkit.postEvent(new CocoaEvent(this.getEventTarget(), runnable));
            return true;
        }
        catch (NullPointerException nullPointerException) {
            if (this instanceof FlushEvent) {
                System.err.println("Error : FlushEvent target has no AppContext\n");
                nullPointerException.printStackTrace();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    static void dispatchAlert(ContainerModel containerModel) {
        AppContext appContext = AppContext.getAppContext();
        Stack[] stackArray = CocoaEvent.getPriorityProcessingQueues(appContext);
        Stack<CocoaEvent> stack = new Stack<CocoaEvent>();
        while (!stackArray[kFlushPriority].isEmpty()) {
            CocoaEvent cocoaEvent = (CocoaEvent)stackArray[kFlushPriority].pop();
            if (cocoaEvent instanceof FlushEvent && (containerModel == null || ((FlushEvent)cocoaEvent).fView != containerModel.fNSView)) {
                cocoaEvent.dispatch();
                continue;
            }
            stack.push(cocoaEvent);
        }
        stackArray[CocoaEvent.kFlushPriority] = stack;
    }

    boolean postToAppContext() {
        Component component = this.getTarget();
        final AppContext appContext = AppContext.getAppContext();
        try {
            Stack stack = CocoaEvent.getPriorityProcessingQueues(appContext)[this.fInternalPriority];
            stack.push(this);
            Runnable runnable = new Runnable(){

                public void run() {
                    Stack[] stackArray = CocoaEvent.getPriorityProcessingQueues(appContext);
                    while (!stackArray[kFlushPriority].isEmpty() || !stackArray[kPaintPriority].isEmpty()) {
                        if (!stackArray[kFlushPriority].isEmpty()) {
                            ((CocoaEvent)stackArray[kFlushPriority].pop()).dispatch();
                            continue;
                        }
                        if (stackArray[kPaintPriority].isEmpty()) continue;
                        ((CocoaEvent)stackArray[kPaintPriority].pop()).dispatch();
                    }
                }
            };
            SunToolkit.postEvent(appContext, new CocoaEvent(this.getEventTarget(), runnable));
            return true;
        }
        catch (NullPointerException nullPointerException) {
            if (this instanceof FlushEvent) {
                System.err.println("Error : FlushEvent target has no AppContext\n");
                nullPointerException.printStackTrace();
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static Stack[] getPriorityProcessingQueues(Component component) {
        AppContext appContext = CToolkit.finalTargetToAppContext(component);
        Stack[] stackArray = (Stack[])appContext.get(PRIORITY_PROCESSING_QUEUES_KEY);
        if (stackArray == null) {
            Stack[] stackArray2 = new Stack[]{new Stack(), new Stack()};
            appContext.put(PRIORITY_PROCESSING_QUEUES_KEY, stackArray2);
            stackArray = stackArray2;
        }
        return stackArray;
    }

    public static Stack[] getPriorityProcessingQueues(AppContext appContext) {
        Stack[] stackArray = (Stack[])appContext.get(PRIORITY_PROCESSING_QUEUES_KEY);
        if (stackArray == null) {
            Stack[] stackArray2 = new Stack[]{new Stack(), new Stack()};
            appContext.put(PRIORITY_PROCESSING_QUEUES_KEY, stackArray2);
            stackArray = stackArray2;
        }
        return stackArray;
    }
}

