/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.List;
import java.util.Vector;
import org.openinstaller.provider.conf.apoc.APOCScope;
import org.openinstaller.provider.conf.apoc.APOCScriptHandler;
import org.openinstaller.provider.conf.apoc.APOCSection;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APOCPage {
    private final String gName;
    private String gScope;
    private final String gLabel;
    private String gInlineHelp;
    private String gOnlineHelp;
    private final List<APOCSection> gSections;
    private APOCScriptHandler gScriptHandler;

    public APOCPage(String aName, String aLabel) {
        this.gName = aName;
        this.gLabel = aLabel;
        this.gSections = new Vector<APOCSection>();
    }

    public String getName() {
        return this.gName;
    }

    public String getScope() {
        return this.gScope;
    }

    public APOCPage setScope(String aScope) throws EnhancedException {
        APOCScope theAPOCScope = APOCScope.getScopeForString(aScope);
        this.gScope = theAPOCScope != null ? theAPOCScope.getScopeSpecifier() : null;
        return this;
    }

    public String getLabel() {
        return this.gLabel;
    }

    public String getInlineHelp() {
        return this.gInlineHelp;
    }

    public APOCPage setInlineHelp(String aInlineHelp) {
        this.gInlineHelp = aInlineHelp;
        return this;
    }

    public String getOnlineHelp() {
        return this.gOnlineHelp;
    }

    public APOCPage setOnlineHelp(String aOnlineHelp) {
        this.gOnlineHelp = aOnlineHelp;
        return this;
    }

    public List<APOCSection> getSections() {
        return this.gSections;
    }

    public APOCPage addSection(APOCSection aSection) {
        this.gSections.add(aSection);
        return this;
    }

    public APOCScriptHandler getScriptHandler() {
        return this.gScriptHandler;
    }

    public APOCPage setScriptHandler(APOCScriptHandler aScriptHandler) {
        this.gScriptHandler = aScriptHandler;
        return this;
    }
}

