/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.ComponentDetails;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.JDKSelection.detection.JDKLocator;
import org.openinstaller.util.JDKSelection.utils.applications.JavaUtils;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDetection {
    private List<VersionRange> gListOfJDKRequirements = new ArrayList<VersionRange>();
    private List<VersionRange> gListOfJRERequirements = new ArrayList<VersionRange>();
    private List<ComponentDetails> gComponentDetails = new LinkedList<ComponentDetails>();
    public static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public JavaDetection() {
        this.gListOfJDKRequirements.add(VersionRange.WIDE_RANGE);
        this.gListOfJRERequirements.add(VersionRange.WIDE_RANGE);
    }

    public JavaDetection(String aSpecString) throws EnhancedException {
        try {
            String[] theSpecRanges;
            for (String theSpecRange : theSpecRanges = aSpecString.split(",")) {
                VersionRange[] theVersions;
                if (theSpecRange.startsWith("JDK")) {
                    for (VersionRange theVersionRange : theVersions = VersionRange.decodeVersionRanges((String)theSpecRange.substring(3))) {
                        this.gListOfJDKRequirements.add(theVersionRange);
                    }
                    continue;
                }
                if (theSpecRange.startsWith("JRE")) {
                    for (VersionRange theVersionRange : theVersions = VersionRange.decodeVersionRanges((String)theSpecRange.substring(3))) {
                        this.gListOfJRERequirements.add(theVersionRange);
                    }
                    continue;
                }
                for (VersionRange theVersionRange : theVersions = VersionRange.decodeVersionRanges((String)theSpecRange)) {
                    this.gListOfJDKRequirements.add(theVersionRange);
                    this.gListOfJRERequirements.add(theVersionRange);
                }
            }
        }
        catch (SIMSException theSEx) {
            throw new EnhancedException("INVALID_JAVA_REQUIREMENT_SPECIFICATION", (Throwable)theSEx, new String[]{"spec=" + aSpecString});
        }
    }

    public static boolean isJDK(String aJDKLocation) {
        return JavaUtils.isJdk((File)new File(aJDKLocation));
    }

    public static boolean isJRE(String aJRELocation) {
        return JavaUtils.isJre((File)new File(aJRELocation));
    }

    public List<ComponentDetails> getInstalledJDKDetails() {
        JDKLocator theQuest = new JDKLocator();
        if (this.gComponentDetails.isEmpty()) {
            theQuest.execute();
            for (int theIndex = 0; theIndex < JDKLocator.javaVersions.size(); ++theIndex) {
                String theCandidateVersionString = (String)JDKLocator.javaVersions.get(theIndex);
                if (!this.isAcceptableVersion(theCandidateVersionString, (Boolean)JDKLocator.javaIsJDK.get(theIndex), (Boolean)JDKLocator.javaIsJRE.get(theIndex))) continue;
                this.gComponentDetails.add(new ComponentDetails((File)JDKLocator.javaLocations.get(theIndex), (String)JDKLocator.javaLabels.get(theIndex), theCandidateVersionString));
            }
        }
        return this.gComponentDetails;
    }

    private boolean isAcceptableVersion(String aCandidateVersionString, boolean aJDK, boolean aJRE) {
        try {
            VersionRange theCandidateVersionRange = new VersionRange(new Version(aCandidateVersionString));
            for (VersionRange theRequirementVersionRange : this.gListOfJDKRequirements) {
                if (!aJDK || !theRequirementVersionRange.overlaps(theCandidateVersionRange)) continue;
                return true;
            }
            for (VersionRange theRequirementVersionRange : this.gListOfJRERequirements) {
                if (!aJRE || !theRequirementVersionRange.overlaps(theCandidateVersionRange)) continue;
                return true;
            }
        }
        catch (InvalidArgumentException theEx) {
            LOGGER.log(Level.WARNING, "INVALID_JDK_VERSION_DETECTED", "version=" + aCandidateVersionString);
        }
        return false;
    }

    public boolean isValidDir(String aCandidateDir) {
        File theCandidateDir = new File(aCandidateDir);
        return JavaUtils.isJavaHome((File)theCandidateDir) && this.isAcceptableVersion(JDKLocator.getVersion((File)theCandidateDir), JavaUtils.isJdk((File)theCandidateDir), JavaUtils.isJre((File)theCandidateDir));
    }
}

