/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RPMUtils {
    private static final String OPTION_ALTROOT = "--root";
    public static final String RPM_DB_PATH = "var/lib/rpm";
    public static final String PACKAGE_GROUP_NAME = "sun-sims-package";
    public static final String PRODUCT_GROUP_NAME = "sun-sims-product";
    public static final String PACKAGE_RPM_GROUP_NAME = "System Environment/sun-sims-package";
    public static final String PRODUCT_RPM_GROUP_NAME = "System Environment/sun-sims-product";
    private static final String DESCRIPTION_FIELD_START = "--- BEGIN SIMS ENTRIES ---";
    private static final String DESCRIPTION_FIELD_END = "--- END SIMS ENTRIES ---";
    private static final String LINUX_RPM = "/bin/rpm";
    private static final String LINUX_ALTROOT_OPTION = "--root";
    private static final String LINUX_RPMOPTION = "-q";
    private static final int PKGNAME_MAX = 200;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private RPMUtils() {
    }

    public static void checkUtils() throws SIMSException {
        for (RPMCommand theCmd : RPMCommand.values()) {
            if (new File(theCmd.getPath()).exists()) continue;
            throw new SIMSException("MISSING_RPM_TOOL", "tool=" + theCmd.getPath());
        }
    }

    public static String getRpmName(String aName, URL aSrcURL) throws EnhancedException {
        if (!aName.endsWith(".rpm")) {
            return RPMUtils.queryName(aSrcURL);
        }
        StringBuilder theResult = new StringBuilder(aName);
        theResult.setLength(theResult.length() - ".rpm".length());
        if (theResult.lastIndexOf(".") == -1) {
            return RPMUtils.queryName(aSrcURL);
        }
        theResult.setLength(theResult.lastIndexOf("."));
        if (theResult.lastIndexOf("-") == -1) {
            return RPMUtils.queryName(aSrcURL);
        }
        theResult.setLength(theResult.lastIndexOf("-"));
        if (theResult.lastIndexOf("-") == -1) {
            return RPMUtils.queryName(aSrcURL);
        }
        theResult.setLength(theResult.lastIndexOf("-"));
        return theResult.toString();
    }

    private static String queryName(URL aSrcURL) throws EnhancedException {
        ArrayList<String> theCommandLine = new ArrayList<String>();
        theCommandLine.add(RPMCommand.RPM.getPath());
        theCommandLine.add("-qp");
        theCommandLine.add("--queryformat=%{NAME}\\n");
        if (aSrcURL.getProtocol().equals("file")) {
            theCommandLine.add(aSrcURL.getFile());
        } else {
            theCommandLine.add(aSrcURL.toExternalForm());
        }
        try {
            Process theProcess = Runtime.getRuntime().exec(theCommandLine.toArray(new String[0]));
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            String theLine = theProcessStdin.readLine();
            if (theLine == null) {
                throw new EnhancedException("CANNOT_QUERY_RPM", new String[]{"url=" + aSrcURL.toExternalForm()});
            }
            return theLine.trim();
        }
        catch (IOException theEx) {
            throw new EnhancedException("CANNOT_QUERY_RPM", (Throwable)theEx, new String[]{"url=" + aSrcURL.toExternalForm()});
        }
    }

    public static List<String> getAllPackageNames(String aAltRoot, String aDomain, String aGroup) throws SIMSException {
        ArrayList<String> thePackageNames = new ArrayList<String>();
        try {
            ArrayList<String> theCommandLine = new ArrayList<String>();
            theCommandLine.add(RPMCommand.RPM.getPath());
            theCommandLine.add(LINUX_RPMOPTION);
            if (aGroup == null || "".equals(aGroup)) {
                theCommandLine.add("-a");
            } else {
                theCommandLine.add("--group");
                theCommandLine.add(aGroup);
            }
            theCommandLine.add("--queryformat=%{NAME}\\n");
            if (aAltRoot != null || aDomain != null) {
                theCommandLine.add("--root");
                try {
                    theCommandLine.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CANNOT_GET_ALL_PKGS", "AltRoot=" + aAltRoot, "Domain=" + aDomain, "Group=" + aGroup);
                }
            }
            ProcessBuilder theBuilder = new ProcessBuilder(theCommandLine);
            theBuilder.environment().put("LC_ALL", "C");
            theBuilder.environment().put("LANG", "C");
            Process theProcess = theBuilder.start();
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            String theNextLine = theProcessStdin.readLine();
            while (theNextLine != null) {
                thePackageNames.add(theNextLine);
                theNextLine = theProcessStdin.readLine();
            }
            theProcessStdin.close();
            try {
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    if (!thePackageNames.isEmpty() && ((String)thePackageNames.get(0)).contains("does not contain any packages")) {
                        thePackageNames.clear();
                        return thePackageNames;
                    }
                    throw new SIMSException("SIMS_CMD_FAILED", "exit-value=" + theProcess.exitValue(), "command=" + theCommandLine, "output=" + thePackageNames);
                }
            }
            catch (InterruptedException theEx) {
                LOGGER.log(Level.WARNING, "INTERRUPTED_CMD", new String[]{"command=" + theCommandLine});
            }
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_GET_ALL_PKGS", new String[0]);
        }
        return thePackageNames;
    }

    public static Map<RPMTag, String> getRPMInfo(String aPkgName, String aAltRoot, String aDomain) throws SIMSException {
        HashMap<RPMTag, String> theValues = new HashMap<RPMTag, String>();
        try {
            ArrayList<String> theCommandLine = new ArrayList<String>();
            theCommandLine.add(RPMCommand.RPM.getPath());
            if (aAltRoot != null || aDomain != null) {
                theCommandLine.add("--root");
                try {
                    theCommandLine.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CANNOT_GET_RPM_INFO", "RPMName=" + aPkgName + "root=" + aAltRoot, "domain=" + aDomain);
                }
            }
            theCommandLine.add(LINUX_RPMOPTION);
            StringBuilder theQueryFormat = new StringBuilder("--queryformat=");
            for (RPMTag theTag : RPMTag.values()) {
                theQueryFormat.append(theTag.name());
                theQueryFormat.append("='%{");
                theQueryFormat.append(theTag.name());
                theQueryFormat.append("}'\\n");
            }
            theCommandLine.add(theQueryFormat.toString());
            theCommandLine.add(aPkgName);
            Process theProcess = Runtime.getRuntime().exec(theCommandLine.toArray(new String[0]));
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            Pattern thePattern = Pattern.compile("^\\s*(\\S[^=]*)='(.*)'\\s*$");
            String theNextLine = theProcessStdin.readLine();
            while (theNextLine != null) {
                try {
                    Matcher thePkginfoMatcher = thePattern.matcher(theNextLine);
                    if (thePkginfoMatcher.matches() && thePkginfoMatcher.groupCount() == 2) {
                        String theKey = thePkginfoMatcher.group(1);
                        String theValue = thePkginfoMatcher.group(2);
                        try {
                            theValues.put(RPMTag.valueOf(theKey), theValue);
                        }
                        catch (IllegalArgumentException theEx) {
                            LOGGER.log(Level.FINE, "Unknown parameter (" + theKey + ") found while querying RPM", new String[]{"parameter=" + theKey, "package=" + aPkgName});
                        }
                    } else {
                        LOGGER.log(Level.FINE, "Unrecognized output from RPM command for pkg " + aPkgName + ": \"" + theNextLine + "\"");
                    }
                }
                catch (IllegalStateException theIse) {
                    LOGGER.log(Level.FINE, "matching operation failed while getting rpm info", "package=" + aPkgName);
                }
                theNextLine = theProcessStdin.readLine();
            }
            theProcessStdin.close();
            try {
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    throw new SIMSException("RPM_QUERY_CMD_FAILED", "package=" + aPkgName, "exit-value=" + theProcess.exitValue(), "command=" + theCommandLine);
                }
            }
            catch (InterruptedException theEx) {
                LOGGER.log(Level.WARNING, "INTERRUPTED_CMD", new String[]{"cmd=" + theCommandLine});
            }
            return theValues;
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "cannot get all products", new String[0]);
        }
    }

    public static Map<SIMSRPMTag, String> getSIMSRPMInfo(String aPkgName, String aAltRoot, String aDomain) throws SIMSException {
        HashMap<SIMSRPMTag, String> theValues = new HashMap<SIMSRPMTag, String>();
        try {
            ArrayList<String> theCommandLine = new ArrayList<String>();
            theCommandLine.add(RPMCommand.RPM.getPath());
            if (aAltRoot != null || aDomain != null) {
                theCommandLine.add("--root");
                try {
                    theCommandLine.add(SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath());
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CANNOT_GET_SIMS_RPM_INFO", "RPMName=" + aPkgName + "root=" + aAltRoot, "domain=" + aDomain);
                }
            }
            theCommandLine.add(LINUX_RPMOPTION);
            theCommandLine.add("--queryformat=%{DESCRIPTION}\\n");
            theCommandLine.add(aPkgName);
            Process theProcess = Runtime.getRuntime().exec(theCommandLine.toArray(new String[0]));
            BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            Pattern thePattern = Pattern.compile("^\\s*(\\S[^=]*)=(.*)\\s*$");
            try {
                String theNextLine;
                while ((theNextLine = theProcessStdin.readLine()) != null && !theNextLine.trim().equals(DESCRIPTION_FIELD_START)) {
                }
                if (theNextLine == null) {
                    theProcessStdin.close();
                    return theValues;
                }
                theNextLine = theProcessStdin.readLine();
                while (theNextLine != null && !theNextLine.trim().equals(DESCRIPTION_FIELD_END)) {
                    Matcher thePkginfoMatcher = thePattern.matcher(theNextLine);
                    if (thePkginfoMatcher.matches() && thePkginfoMatcher.groupCount() == 2) {
                        String theKey = thePkginfoMatcher.group(1);
                        String theValue = thePkginfoMatcher.group(2);
                        try {
                            theValues.put(SIMSRPMTag.valueOf(theKey), theValue);
                        }
                        catch (IllegalArgumentException theEx) {
                            LOGGER.log(Level.INFO, "UNKNOWN_PARAM", new String[]{"parameter=" + theKey, "package=" + aPkgName});
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "CORRUPT_ENTRY_IN_RPM_QUERY", new String[]{"package=" + aPkgName, "line=" + theNextLine});
                    }
                    theNextLine = theProcessStdin.readLine();
                }
                theProcessStdin.close();
                if (theNextLine == null) {
                    LOGGER.log(Level.INFO, "INCORRECT_DESC_IN_RPM", "package=" + aPkgName);
                }
            }
            catch (IOException theEx) {
                throw new SIMSException(theEx, "CANNOT_READ_TAG", "package=" + aPkgName);
            }
            try {
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    throw new SIMSException("RPM_CMD_FAILED", "package=" + aPkgName);
                }
            }
            catch (InterruptedException theEx) {
                LOGGER.log(Level.WARNING, "INTERRUPTED_CMD", new String[]{"cmd=" + theCommandLine});
            }
            return theValues;
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_GET_ALL_PRODUCTS", new String[0]);
        }
    }

    public static String createSIMSPkgName(String aPrefix, String aName, Version aVersion, String aInstanceID) {
        String thePostfix;
        try {
            MessageDigest theDigester = MessageDigest.getInstance("MD5");
            theDigester.update(aName.getBytes());
            theDigester.update(Version.encode((Version)aVersion).getBytes());
            theDigester.update(aInstanceID.getBytes());
            byte[] theDigest = theDigester.digest();
            thePostfix = StringUtils.encodeData((byte[])theDigest);
        }
        catch (NoSuchAlgorithmException theEx) {
            LOGGER.log(Level.WARNING, "CANT_CREATE_UNIQUE_PKGNAME", aName);
            thePostfix = aName + " - " + Version.encode((Version)aVersion) + " - " + aInstanceID;
            thePostfix = StringUtils.encodeData((byte[])thePostfix.getBytes());
        }
        StringBuffer theName = new StringBuffer(aPrefix);
        theName.append('-');
        theName.append(thePostfix);
        int theNameLength = theName.length();
        for (int theNameIndex = 0; theNameIndex < theNameLength; ++theNameIndex) {
            char theChar = theName.charAt(theNameIndex);
            if (theChar == '+' || theChar == '-' || Character.isLetterOrDigit(theChar)) continue;
            theName.setCharAt(theNameIndex, '-');
        }
        if (theName.length() > 200) {
            theName.setLength(200);
        }
        return theName.toString();
    }

    public static File createMetaPkg(String aPkgName, ProgressListener aListener, Map<RPMTag, String> aRPMTagMap, Map<SIMSRPMTag, String> aSIMSRPMTagMap, List<Package> aDependList) throws SIMSException {
        ExecuteCommand executeCommand;
        FileWriter theRPMSpecFileOut;
        FileWriter theRPMMacroFileOut;
        FileWriter theRPMRCFileOut;
        File theTempDirFile = TempFileManager.findTempDir(aPkgName + "-metarpm");
        File theRPMRCFile = new File(theTempDirFile, "rpmrc");
        File theRPMMacroFile = new File(theTempDirFile, "rpmmacros");
        File theRPMSpecFile = new File(theTempDirFile, "rpmspec");
        if (aListener != null) {
            aListener.updateProgress(20);
        }
        try {
            if (!theTempDirFile.mkdir()) {
                throw new SIMSException("cannot make temp directory " + theTempDirFile, new String[0]);
            }
            TempFileManager.registerTempFile(theTempDirFile);
            theRPMRCFileOut = new FileWriter(theRPMRCFile);
            theRPMMacroFileOut = new FileWriter(theRPMMacroFile);
            theRPMSpecFileOut = new FileWriter(theRPMSpecFile);
            TempFileManager.registerTempFile(theRPMRCFile);
            TempFileManager.registerTempFile(theRPMMacroFile);
            TempFileManager.registerTempFile(theRPMSpecFile);
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "cannot initialize directories", "directory=" + theTempDirFile.getAbsolutePath(), "rcfile=" + theRPMRCFile.getAbsolutePath(), "macrofile=" + theRPMMacroFile.getAbsolutePath(), "specfile=" + theRPMSpecFile.getAbsolutePath());
        }
        if (aListener != null) {
            aListener.updateProgress(50);
        }
        try {
            String theValue;
            String theKey;
            for (Map.Entry<RPMTag, String> entry : aRPMTagMap.entrySet()) {
                theKey = entry.getKey().name();
                theValue = entry.getValue();
                theRPMSpecFileOut.write(theKey + ":" + theValue + " \n");
            }
            if (aDependList != null && !aDependList.isEmpty()) {
                theRPMSpecFileOut.write("Requires: ");
                for (Package package_ : aDependList) {
                    theRPMSpecFileOut.write(package_.getName() + " = " + package_.getVersion());
                    theRPMSpecFileOut.write(", ");
                }
                theRPMSpecFileOut.write("\n");
            }
            theRPMSpecFileOut.write("%description\n");
            theRPMSpecFileOut.write("---THE BELOW FIELDS ARE NOT DESIGNED FOR HUMAN CONSUMPTION---\n");
            theRPMSpecFileOut.write("---DO NOT MODIFY---\n");
            theRPMSpecFileOut.write("--- BEGIN SIMS ENTRIES ---\n");
            for (Map.Entry entry : aSIMSRPMTagMap.entrySet()) {
                theKey = ((SIMSRPMTag)((Object)entry.getKey())).name();
                theValue = (String)entry.getValue();
                theRPMSpecFileOut.write(theKey + "=" + theValue + " \n");
            }
            theRPMSpecFileOut.write("--- END SIMS ENTRIES ---\n");
            theRPMSpecFileOut.write("%files\n");
            theRPMSpecFileOut.close();
        }
        catch (IOException theIoe) {
            throw new SIMSException(theIoe, "Cannot create rpm spec file", "specfile=" + theRPMSpecFile);
        }
        try {
            theRPMMacroFileOut.write("%_topdir " + theTempDirFile.getAbsolutePath() + "\n");
            theRPMMacroFileOut.write("%_rpmdir " + theTempDirFile.getAbsolutePath() + "\n");
            theRPMMacroFileOut.write("%_build_name_fmt " + aPkgName + ".rpm" + "\n");
            theRPMMacroFileOut.close();
            theRPMRCFileOut.write("include: /usr/lib/rpm/rpmrc\n");
            theRPMRCFileOut.write("macrofiles: /usr/lib/rpm/macros:" + theRPMMacroFile.getAbsolutePath() + "\n");
            theRPMRCFileOut.close();
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "Cannot create RPM RC and Macro file", "macrofile=" + theRPMMacroFile.getAbsolutePath(), "rpmrcfile=" + theRPMRCFile.getAbsolutePath());
        }
        if (aListener != null) {
            aListener.updateProgress(80);
        }
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(RPMCommand.RPMBUILD.getPath());
        theInstallCommand.add("-bb");
        theInstallCommand.add("--rcfile");
        theInstallCommand.add(theRPMRCFile.getAbsolutePath());
        theInstallCommand.add(theRPMSpecFile.getAbsolutePath());
        try {
            executeCommand = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new SIMSException(theEx, "CANNOT_CREATE_META_RPM", new String[0]);
        }
        executeCommand.setCollectOutput(true);
        executeCommand.setOutputType(3);
        File theResultingRPM = new File(theTempDirFile, aPkgName + ".rpm");
        TempFileManager.registerTempFile(theResultingRPM);
        try {
            executeCommand.execute();
        }
        catch (EnhancedException theEE) {
            throw new SIMSException(theEE, "ERROR_EXEC_CMD", "command=" + Arrays.toString(executeCommand.getCommand()));
        }
        int theResult = executeCommand.getResult();
        if (theResult != 0) {
            throw new SIMSException("FAILED_SIMS_META_RPM", "command=" + theInstallCommand.toString(), "exit-code=" + theResult, "output=" + executeCommand.getAllOutput());
        }
        return theResultingRPM;
    }

    public static void installPkg(File aRPMFile, String aRPMName, String aDomain, String aAltRoot) throws SIMSException {
        ExecuteCommand theCmd;
        File theTmp;
        File theAltRPM;
        boolean theAltToolFlag = false;
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(RPMCommand.RPM.getPath());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltRPM = new File(new File(theAltToolPath), RPMCommand.RPM.getPath())).exists()) {
            theInstallCommand.clear();
            theInstallCommand.add(theAltRPM.getAbsolutePath());
            theAltToolFlag = true;
        }
        theInstallCommand.add("-i");
        theInstallCommand.add("--ignoresize");
        theInstallCommand.add("--ignoreos");
        theInstallCommand.add("--justdb");
        theInstallCommand.add("--nodigest");
        theInstallCommand.add("--nodeps");
        theInstallCommand.add("--nosuggest");
        theInstallCommand.add("--noorder");
        theInstallCommand.add("--noscripts");
        theInstallCommand.add("--notriggers");
        theInstallCommand.add("--force");
        try {
            theTmp = File.createTempFile("rpm", "simslock");
            TempFileManager.registerTempFile(theTmp);
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_CREATE_TMPFILE", new String[0]);
        }
        theInstallCommand.add("--define");
        theInstallCommand.add("_rpmlock_path " + theTmp.getAbsolutePath());
        if (aAltRoot != null || aDomain != null) {
            theInstallCommand.add("--define");
            try {
                theInstallCommand.add("_dbpath " + SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath() + "/" + RPM_DB_PATH);
            }
            catch (EnhancedException theEx) {
                throw new SIMSException(theEx, "RPM_INSTALLATION_FAILED", "Name=" + aRPMName, "RPMFile=" + aRPMFile, "AltRoot=" + aAltRoot, "Domain=", aDomain);
            }
        }
        theInstallCommand.add(aRPMFile.getAbsolutePath());
        try {
            theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            TempFileManager.deleteTempFiles();
            throw new SIMSException(theEx, "CANNOT_CREATE_META_RPM", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        LOGGER.fine("SIMS Meta package install command: " + theCmd);
        try {
            if (theAltToolFlag) {
                File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
                File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
                theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
            }
            theCmd.execute();
        }
        catch (EnhancedException theEE) {
            TempFileManager.deleteTempFiles();
            throw new SIMSException(theEE, "RPM_INSTALLATION_FAILED", "command=" + theCmd, "package=" + aRPMName, "output=" + theCmd.getAllOutput());
        }
        TempFileManager.deleteTempFiles();
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            throw new SIMSException("rpm installation of RPM failed.", "command=" + theCmd, "package=" + aRPMName, "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
        }
    }

    public static void removePkg(String aRPMName, String aDomain, String aAltRoot) throws EnhancedException {
        File theTmp;
        File theAltRPM;
        boolean theAltToolFlag = false;
        ArrayList<String> theUninstallCommand = new ArrayList<String>();
        theUninstallCommand.add(RPMCommand.RPM.getPath());
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltRPM = new File(new File(theAltToolPath), RPMCommand.RPM.getPath())).exists()) {
            theUninstallCommand.clear();
            theUninstallCommand.add(theAltRPM.getAbsolutePath());
            theAltToolFlag = true;
        }
        theUninstallCommand.add("-e");
        theUninstallCommand.add("--allmatches");
        theUninstallCommand.add("--nodeps");
        theUninstallCommand.add("--noscripts");
        theUninstallCommand.add("--notriggers");
        theUninstallCommand.add("--justdb");
        try {
            theTmp = File.createTempFile("rpm", "simslock");
            TempFileManager.registerTempFile(theTmp);
        }
        catch (IOException theEx) {
            throw new SIMSException(theEx, "CANNOT_CREATE_TMPFILE", new String[0]);
        }
        theUninstallCommand.add("--define");
        theUninstallCommand.add("_rpmlock_path " + theTmp.getAbsolutePath());
        if (aAltRoot != null || aDomain != null) {
            theUninstallCommand.add("--define");
            theUninstallCommand.add("_dbpath " + SimsUtils.getFinalAltRoot(aAltRoot, aDomain).getAbsolutePath() + "/" + RPM_DB_PATH);
        }
        theUninstallCommand.add(aRPMName);
        ExecuteCommand theCmd = new ExecuteCommand(theUninstallCommand.toArray(new String[0]));
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        if (theAltToolFlag) {
            File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
            File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
            theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
        }
        theCmd.execute();
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            TempFileManager.deleteTempFiles();
            throw new EnhancedException("erase of " + aRPMName + " failed: exit code: " + theResult + " All Output: " + theCmd.getAllOutput(), new String[0]);
        }
        TempFileManager.deleteTempFiles();
    }

    protected static String findProduct(String aName, Version aVersion, String aInstance, String aAltRoot, String aDomain) throws EnhancedException {
        if (aName == null || aVersion == null || aInstance == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"name=" + aName, "version=" + aVersion, "instance=" + aInstance});
        }
        String theEncodedName = RPMUtils.createSIMSPkgName(PRODUCT_GROUP_NAME, aName, aVersion, aInstance);
        Map<SIMSRPMTag, String> theSIMSInfo = RPMUtils.getSIMSRPMInfo(theEncodedName, aAltRoot, aDomain);
        Map<RPMTag, String> theRPMInfo = RPMUtils.getRPMInfo(theEncodedName, aAltRoot, aDomain);
        if (aInstance.equals(theSIMSInfo.get((Object)SIMSRPMTag.SIMS_INSTANCE_ID)) && aVersion.equals((Object)new Version(theRPMInfo.get((Object)RPMTag.VERSION))) && aName.equals(theSIMSInfo.get((Object)SIMSRPMTag.SIMS_PRODUCT_NAME))) {
            return theEncodedName;
        }
        List<String> theCompletePkgList = RPMUtils.getAllPackageNames(aAltRoot, aDomain, PRODUCT_RPM_GROUP_NAME);
        for (String thePkgName : theCompletePkgList) {
            theSIMSInfo = RPMUtils.getSIMSRPMInfo(theEncodedName, aAltRoot, aDomain);
            theRPMInfo = RPMUtils.getRPMInfo(theEncodedName, aAltRoot, aDomain);
            if (!aInstance.equals(theSIMSInfo.get((Object)SIMSRPMTag.SIMS_INSTANCE_ID)) || !aVersion.equals((Object)new Version(theRPMInfo.get((Object)RPMTag.VERSION))) || !aName.equals(theSIMSInfo.get((Object)SIMSRPMTag.SIMS_PRODUCT_NAME))) continue;
            return thePkgName;
        }
        return null;
    }

    public static boolean isLinuxRPMInstalled(String aName, String aInstallHome) throws EnhancedException {
        ExecuteCommand theCmd;
        if (aName == null) {
            throw new IllegalArgumentException("findrpm: name must be non-null");
        }
        ArrayList<String> theCommand = new ArrayList<String>();
        theCommand.add(LINUX_RPM);
        if (aInstallHome != null && !"".equals(aInstallHome)) {
            theCommand.add("--root");
            theCommand.add(aInstallHome);
        }
        theCommand.add(LINUX_RPMOPTION);
        theCommand.add(aName);
        try {
            theCmd = new ExecuteCommand(theCommand.toArray(new String[0]));
            theCmd.execute();
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANT_EXEC_RPM_CMD rpm=" + aName, (Throwable)theEx, new String[0]);
        }
        catch (EnhancedException theEnX) {
            throw new EnhancedException("CANT_EXEC_RPM_CMD command=" + ((Object)theCommand).toString(), (Throwable)theEnX, new String[0]);
        }
        return theCmd.getResult() == 0;
    }

    public static boolean isRPMInstalled(String aName, String aInstallHome) throws EnhancedException {
        ExecuteCommand theCmd;
        if (aName == null) {
            throw new IllegalArgumentException("NO_RPM_NAME_SPECIFIED");
        }
        String theRPM = RPMUtils.getLinuxRPMName(aName);
        ArrayList theCommand = new ArrayList();
        Object theFoundRPMVer = null;
        ArrayList<String> theCommandLine = new ArrayList<String>();
        theCommandLine.add(RPMCommand.RPM.getPath());
        if (aInstallHome != null && !"".equals(aInstallHome)) {
            theCommandLine.add("--root");
            theCommandLine.add(aInstallHome);
        }
        theCommandLine.add(LINUX_RPMOPTION);
        theCommandLine.add(theRPM);
        try {
            LOGGER.finest("Detection Command = " + theCommandLine.toString());
            theCmd = new ExecuteCommand(theCommandLine.toArray(new String[0]));
            theCmd.execute();
        }
        catch (InvalidArgumentException theEx) {
            theEx.addContext("CANT_EXEC_RPM_CMD rpm=" + aName, new String[0]);
            throw theEx;
        }
        catch (EnhancedException theEnX) {
            theEnX.addContext("CANT_EXEC_RPM_CMD command=" + ((Object)theCommand).toString(), new String[0]);
            throw theEnX;
        }
        return theCmd.getResult() == 0;
    }

    public static Version getRPMVersionRelease(String aRPM, String aInstallHome) throws EnhancedException {
        Version theFoundVersion = null;
        String theRPMName = RPMUtils.getLinuxRPMName(aRPM);
        Map<RPMTag, String> theRPMInfoMap = RPMUtils.getRPMInfo(theRPMName, aInstallHome, null);
        if (theRPMInfoMap.containsKey((Object)RPMTag.VERSION)) {
            String theVersion = theRPMInfoMap.get((Object)RPMTag.VERSION).trim();
            LOGGER.finer("@ RPM Version for " + theRPMName + " = " + theVersion);
            String theRelease = null;
            if (theRPMInfoMap.containsKey((Object)RPMTag.RELEASE)) {
                theRelease = theRPMInfoMap.get((Object)RPMTag.RELEASE).trim();
                LOGGER.finer("@ RPM Relase for " + theRPMName + " = " + theRelease);
            }
            theVersion = theVersion + "-" + theRelease;
            theFoundVersion = new Version(theVersion);
        }
        return theFoundVersion;
    }

    public static Version getRPMVersion(String aRPM, String aInstallHome) throws EnhancedException {
        Version theFoundVersion = null;
        String theRPMName = RPMUtils.getLinuxRPMName(aRPM);
        Map<RPMTag, String> theRPMInfoMap = RPMUtils.getRPMInfo(theRPMName, aInstallHome, null);
        if (theRPMInfoMap.containsKey((Object)RPMTag.VERSION)) {
            String theVersion = theRPMInfoMap.get((Object)RPMTag.VERSION).trim();
            LOGGER.finer("@ RPM Version for " + theRPMName + " = " + theVersion);
            theFoundVersion = new Version(theVersion);
        }
        return theFoundVersion;
    }

    public static String getLinuxRPMName(String aName) throws EnhancedException {
        StringBuilder theResult = new StringBuilder(aName);
        if (aName.endsWith(".rpm")) {
            theResult.setLength(theResult.length() - ".rpm".length());
        }
        if (theResult.lastIndexOf(".") != -1) {
            theResult.setLength(theResult.lastIndexOf("."));
        }
        if (theResult.lastIndexOf("-") != -1) {
            theResult.setLength(theResult.lastIndexOf("-"));
        }
        if (theResult.lastIndexOf("-") != -1) {
            theResult.setLength(theResult.lastIndexOf("-"));
        }
        LOGGER.finest(" RPM name for query = " + theResult.toString());
        return theResult.toString();
    }

    public static String formRPMName(String aName, String aVersion) {
        int theIndexOfArch;
        StringBuilder theRPMName = new StringBuilder(aName);
        boolean theEndsWithRPM = false;
        String theArch = null;
        if (aName.endsWith(".rpm")) {
            theEndsWithRPM = true;
            theRPMName.setLength(theRPMName.length() - ".rpm".length());
        }
        if ((theIndexOfArch = theRPMName.lastIndexOf(".")) != -1) {
            theArch = theRPMName.substring(theIndexOfArch);
            theRPMName.setLength(theIndexOfArch);
        }
        if (theRPMName.lastIndexOf("-") != -1) {
            theRPMName.setLength(theRPMName.lastIndexOf("-"));
        }
        if (theRPMName.lastIndexOf("-") != -1) {
            theRPMName.setLength(theRPMName.lastIndexOf("-"));
        }
        theRPMName.append("-");
        theRPMName.append(aVersion);
        LOGGER.finer(" @ The New RPM NAme = " + theRPMName.toString());
        return theRPMName.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RPMCommand {
        RPM("/bin/rpm"),
        RPMBUILD("/usr/bin/rpmbuild");

        private final String gCmd;

        private RPMCommand(String aCmd) {
            this.gCmd = aCmd;
        }

        public String getPath() {
            return this.gCmd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SIMSRPMTag {
        SIMS_PRODUCT_NAME,
        SIMS_INSTANCE_ID,
        SIMS_PRODUCT_BASEDIR,
        SIMS_CONTAINED_PRODUCTS,
        SIMS_REQUIRED_PRODUCTS,
        SIMS_CONTAINED_PACKAGES,
        SIMS_COMPATIBLE_VERSIONS,
        SIMS_BASE_PKG,
        SIMS_BASE_PKG_BASEDIR,
        SIMS_REQUIRED_PACKAGES,
        SIMS_PRODUCT_DESC,
        SIMS_PRODUCT_READABLE_NAME,
        SIMS_RELEASE,
        SIMS_CRITICAL,
        SIMS_BASE_PKG_DESC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RPMTag {
        NAME,
        VERSION,
        RELEASE,
        SUMMARY,
        INSTALLTIME,
        DISTRIBUTION,
        VENDOR,
        LICENSE,
        GROUP,
        OS,
        ARCH,
        PREIN,
        POSTIN,
        PREUN,
        POSTUN,
        PROVIDES,
        REQUIREFLAGS,
        REQUIRENAME,
        REQUIREVERSION,
        CONFLICTFLAGS,
        CONFLICTNAME,
        CONFLICTVERSION,
        INSTALLPREFIX,
        EXCLUDEARCH,
        EXCLUDEOS,
        EXCLUSIVEARCH,
        EXCLUSIVEOS,
        RPMVERSION,
        TRIGGERSCRIPTS;

    }
}

