/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EngineBootstrap
extends URLClassLoader {
    private static boolean gDebug = false;
    private static final boolean IS_WEBSTART = new Boolean(System.getProperty("openinstaller.iswebstart"));
    public static final String INSTALLER_RESOURCES_URL_PROPERTY = "installer.resources.url";
    public static final String DEFAULT_RESOURCES_URL_PROPERTY = "default.resources.url";

    public EngineBootstrap() {
        super(new URL[0]);
    }

    private static String encodeURL(String aRawString) {
        StringBuilder theBuf = new StringBuilder();
        block6: for (int theIndex = 0; theIndex < aRawString.length(); ++theIndex) {
            char theChar = aRawString.charAt(theIndex);
            switch (theChar) {
                case '%': {
                    theBuf.append("%25");
                    continue block6;
                }
                case '?': {
                    theBuf.append("%3F");
                    continue block6;
                }
                case '&': {
                    theBuf.append("%26");
                    continue block6;
                }
                case ' ': {
                    theBuf.append("%20");
                    continue block6;
                }
                default: {
                    theBuf.append(theChar);
                }
            }
        }
        return theBuf.toString();
    }

    public static void main(String[] aArgumentSet) {
        try {
            String theInstallResourceURL;
            StringTokenizer thePathTokenizer;
            EngineBootstrap theBootstrapper = new EngineBootstrap();
            try {
                String theLocationOfDebugJars = System.getenv("install.debug.classpath");
                if (theLocationOfDebugJars != null) {
                    thePathTokenizer = new StringTokenizer(theLocationOfDebugJars, File.pathSeparator);
                    while (thePathTokenizer.hasMoreTokens()) {
                        theBootstrapper.addURL(new File(thePathTokenizer.nextToken()).toURI().toURL());
                    }
                }
            }
            catch (Throwable theThrowable) {
                EngineBootstrap.debug("Could not load optional install.debug.classpath: " + theThrowable.getMessage());
            }
            String theLocationOfEngineJar = System.getProperties().getProperty("install.engine");
            if (theLocationOfEngineJar != null) {
                thePathTokenizer = new StringTokenizer(theLocationOfEngineJar, File.pathSeparator);
                while (thePathTokenizer.hasMoreTokens()) {
                    String theEngineJarPath = thePathTokenizer.nextToken();
                    theBootstrapper.addURLToPath(new File(theEngineJarPath).toURI().toURL());
                }
            }
            if ((theInstallResourceURL = System.getProperties().getProperty(INSTALLER_RESOURCES_URL_PROPERTY)) != null) {
                if (!theInstallResourceURL.endsWith("/")) {
                    theInstallResourceURL = theInstallResourceURL + "/";
                    System.setProperty(INSTALLER_RESOURCES_URL_PROPERTY, theInstallResourceURL);
                }
            } else {
                throw new Exception("No installer.resources.url defined");
            }
            theBootstrapper.addURLToPath(new URL(EngineBootstrap.encodeURL(theInstallResourceURL)).toURI().toURL());
            String theDefaultResourceURL = System.getProperties().getProperty(DEFAULT_RESOURCES_URL_PROPERTY);
            if (theDefaultResourceURL != null) {
                if (!theDefaultResourceURL.endsWith("/")) {
                    theDefaultResourceURL = theDefaultResourceURL + "/";
                    System.setProperty(DEFAULT_RESOURCES_URL_PROPERTY, theDefaultResourceURL);
                }
            } else {
                throw new Exception("No default.resources.url  defined");
            }
            theBootstrapper.addURLToPath(new URL(EngineBootstrap.encodeURL(theDefaultResourceURL)).toURI().toURL());
            Class<?> theOrchestratorClassType = IS_WEBSTART ? Class.forName("org.openinstaller.core.Orchestrator") : Class.forName("org.openinstaller.core.Orchestrator", true, theBootstrapper);
            Constructor<?> theOrchestratorConstructor = theOrchestratorClassType.getConstructor(EngineBootstrap.class);
            Object theOrchestratorInstance = theOrchestratorConstructor.newInstance(theBootstrapper);
            Class[] theStringArrayClassType = new Class[]{new String[0].getClass()};
            Method theOrchestratorMainMethod = theOrchestratorClassType.getMethod("main", theStringArrayClassType);
            theOrchestratorMainMethod.invoke(theOrchestratorInstance, new Object[]{aArgumentSet});
        }
        catch (Exception theEx) {
            theEx.printStackTrace();
            EngineBootstrap.debug(true, "Cannot load engine");
            StringBuffer theArgs = new StringBuffer("ARGS: ").append(Arrays.toString(aArgumentSet).trim());
            EngineBootstrap.debug(true, theArgs.toString());
            EngineBootstrap.debug(true, "Stack:");
            StringWriter theStackWriter = new StringWriter();
            theEx.printStackTrace(new PrintWriter(theStackWriter));
            EngineBootstrap.debug(true, theStackWriter.toString());
            System.exit(2);
        }
    }

    public void addURLToPath(URL aURL) {
        EngineBootstrap.debug("EngineBootstrap.addURLToPath(" + aURL + ")");
        super.addURL(aURL);
    }

    @Override
    protected Class<?> findClass(String aName) throws ClassNotFoundException {
        EngineBootstrap.debug("EngineBootstrap.findClass(" + aName + ")");
        try {
            Class<?> theResult = super.findClass(aName);
            EngineBootstrap.debug("EngineBootstrap.findClass(" + aName + ") result: " + theResult);
            return theResult;
        }
        catch (ClassNotFoundException theEx) {
            EngineBootstrap.debug("EngineBootstrap.findClass(" + aName + ") result: ERROR(" + theEx.getMessage() + ")");
            throw theEx;
        }
    }

    @Override
    public URL findResource(String aName) {
        EngineBootstrap.debug("EngineBootstrap.findResource(" + aName + ")");
        return super.findResource(aName);
    }

    @Override
    public Enumeration<URL> findResources(String aName) throws IOException {
        EngineBootstrap.debug("EngineBootstrap.findResources(" + aName + ")");
        return super.findResources(aName);
    }

    private static void debug(String aStr) {
        EngineBootstrap.debug(false, aStr);
    }

    private static void debug(boolean aForce, String aStr) {
        if (gDebug || aForce) {
            System.err.println(aStr);
        }
    }

    @Override
    public Class<?> loadClass(String aName) throws ClassNotFoundException {
        EngineBootstrap.debug("EngineBootstrap.loadClass(" + aName + ")");
        try {
            Class<?> theResult = super.loadClass(aName);
            EngineBootstrap.debug("EngineBootstrap.loadClass(" + aName + ") result: " + theResult);
            return theResult;
        }
        catch (ClassNotFoundException theEx) {
            EngineBootstrap.debug("EngineBootstrap.loadClass(" + aName + ") result: ERROR");
            throw theEx;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String aName, boolean aResolveFlag) throws ClassNotFoundException {
        EngineBootstrap.debug("EngineBootstrap.loadClass(" + aName + ", " + aResolveFlag + ")");
        return super.loadClass(aName, aResolveFlag);
    }

    @Override
    public URL getResource(String aName) {
        EngineBootstrap.debug("EngineBootstrap.getResource(" + aName + ")");
        return super.getResource(aName);
    }

    @Override
    public Enumeration<URL> getResources(String aName) throws IOException {
        EngineBootstrap.debug("EngineBootstrap.getResources(" + aName + ")");
        return super.getResources(aName);
    }

    @Override
    public InputStream getResourceAsStream(String aName) {
        EngineBootstrap.debug("EngineBootstrap.getResourceAsStream(" + aName + ")");
        return super.getResourceAsStream(aName);
    }
}

