/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemProduct
implements ProductNodeInterface {
    private final String gIdentifier;
    private String gShortDescr;
    private Version gVersion;
    private Version gRelease;
    private Map<Locale, String> gDesc = new HashMap<Locale, String>();
    private String gLocation;
    private final String gInstance;
    private final Set<VersionRange> gCompatibleVersions = new LinkedHashSet<VersionRange>();
    private Object gAppData;
    private Boolean gCritical = Boolean.FALSE;
    private boolean gUpgradeAll = false;
    private Backend.EntityState gState;
    private final Set<Package> gContainedPkgs = new LinkedHashSet<Package>();
    private final Set<SystemProduct> gContainedProds = new LinkedHashSet<SystemProduct>();
    private final Set<SystemProduct> gRequiredProds = new LinkedHashSet<SystemProduct>();

    public boolean isCompatible(SystemProduct aProd) {
        if (aProd == null || !this.gIdentifier.equals(aProd.getName())) {
            return false;
        }
        for (VersionRange theRange : this.gCompatibleVersions) {
            if (!theRange.includesVersion(aProd.getVersion())) continue;
            return true;
        }
        return false;
    }

    public SystemProduct(String aIdentifier, Version aVersion, String aInstance, String aShortDescr) throws InvalidArgumentException {
        if (aIdentifier == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"name=(null)"});
        }
        if (aVersion == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"version=(null)"});
        }
        if (aInstance == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"instance=(null)"});
        }
        this.gIdentifier = aIdentifier;
        this.gShortDescr = aShortDescr;
        this.gVersion = aVersion;
        this.gInstance = aInstance;
        this.gState = Backend.EntityState.NOT_INSTALLED;
    }

    public boolean equals(Object aProd) {
        if (aProd == null) {
            return false;
        }
        if (aProd.getClass() != SystemProduct.class) {
            return false;
        }
        SystemProduct theProd = (SystemProduct)aProd;
        return SystemProduct.theSame(this.gVersion, theProd.gVersion) && SystemProduct.theSame(this.gInstance, theProd.gInstance) && SystemProduct.theSame(this.gIdentifier, theProd.gIdentifier);
    }

    public static String encode(SystemProduct aProduct) {
        return aProduct.getName() + "&" + aProduct.getVersion() + "&" + aProduct.getInstance();
    }

    public SystemProduct(String aSpec) throws SIMSException {
        String[] theSpecElements = aSpec.split("&");
        if (theSpecElements.length != 3) {
            throw new SIMSException("CORRUPTP_PKG_SPEC", "spec=" + aSpec);
        }
        this.gIdentifier = theSpecElements[0];
        this.gVersion = new Version(theSpecElements[1]);
        this.gInstance = theSpecElements[2];
        this.gState = Backend.EntityState.NOT_INSTALLED;
    }

    public int hashCode() {
        return this.gIdentifier.hashCode() + this.gVersion.hashCode() + this.gInstance.hashCode();
    }

    public String toString() {
        return this.getShortDescription();
    }

    protected static boolean theSame(Object aObject, Object aDifferentObject) {
        if (aObject == null && aDifferentObject != null) {
            return false;
        }
        if (aObject != null && aDifferentObject == null) {
            return false;
        }
        return aObject != null && aObject.equals(aDifferentObject) || aDifferentObject != null && aDifferentObject.equals(aObject);
    }

    public void setVersion(Version aVersion) {
        this.gVersion = aVersion;
    }

    public String getVersionStr() {
        return this.getVersion().toString();
    }

    public Version getVersion() {
        return this.gVersion;
    }

    public Set<SystemProduct> getDependencies() {
        LinkedHashSet<SystemProduct> theDependencies = new LinkedHashSet<SystemProduct>();
        theDependencies.addAll(this.gRequiredProds);
        return theDependencies;
    }

    public Set<SystemProduct> getFeatures() {
        return this.getContainedProducts();
    }

    public String getID() {
        return this.gIdentifier;
    }

    public String getName() {
        return this.getID();
    }

    public String getShortDescription() {
        String theResult = this.gShortDescr;
        if (theResult == null || "".equals(theResult)) {
            theResult = this.getDescription();
        }
        return theResult;
    }

    public String getDescription() {
        String theResult = this.getDescription(Locale.getDefault());
        if (theResult == null || "".equals(theResult)) {
            theResult = this.getID();
        }
        return theResult;
    }

    public String getDescription(Locale aLocale) {
        if (this.gDesc.containsKey(aLocale)) {
            return this.gDesc.get(aLocale);
        }
        Locale theLocale = new Locale(aLocale.getLanguage(), aLocale.getCountry());
        if (this.gDesc.containsKey(theLocale)) {
            return this.gDesc.get(theLocale);
        }
        theLocale = new Locale(aLocale.getLanguage());
        if (this.gDesc.containsKey(theLocale)) {
            return this.gDesc.get(theLocale);
        }
        if (this.gDesc.containsKey(null)) {
            return this.gDesc.get(null);
        }
        return "";
    }

    public void setDescription(String aDescription, Locale aLocale) {
        this.gDesc.put(aLocale, aDescription);
    }

    public void setDescription(Map<Locale, String> aDescriptionMap) {
        this.gDesc.putAll(aDescriptionMap);
    }

    public String getLocation() {
        return this.gLocation;
    }

    public void setLocation(String aLocation) {
        this.gLocation = aLocation;
    }

    public String getInstance() {
        return this.gInstance;
    }

    public Set<VersionRange> getCompatibleVersions() {
        return this.gCompatibleVersions;
    }

    public void addCompatibleVersion(VersionRange aCompatibleVersion) {
        this.gCompatibleVersions.add(aCompatibleVersion);
    }

    public Object getAppdata() {
        return this.gAppData;
    }

    public void setAppdata(Object aAppdata) {
        this.gAppData = aAppdata;
    }

    public Backend.EntityState getState() {
        return this.gState;
    }

    public void setState(Backend.EntityState aState) {
        this.gState = aState;
    }

    public Set<Package> getContainedPackages() {
        return this.gContainedPkgs;
    }

    public int getContainedPackageCount() {
        return this.gContainedPkgs.size();
    }

    public void addContainedPackage(Package aContainedPackage) {
        if (this.gContainedPkgs.contains(aContainedPackage)) {
            this.gContainedPkgs.remove(aContainedPackage);
        }
        this.gContainedPkgs.add(aContainedPackage);
    }

    public Set<SystemProduct> getContainedProducts() {
        return this.gContainedProds;
    }

    public int getContainedProductCount() {
        return this.gContainedProds.size();
    }

    public void addContainedProduct(SystemProduct aContainedProduct) throws InvalidArgumentException {
        if (this.equals(aContainedProduct)) {
            throw new InvalidArgumentException("ERROR_PRODUCT_SELF_DEPENDENCE", new String[]{"product=" + this.toString()});
        }
        if (this.gContainedProds.contains(aContainedProduct)) {
            this.gContainedProds.remove(aContainedProduct);
        }
        this.gContainedProds.add(aContainedProduct);
    }

    public Set<SystemProduct> getRequiredProducts() {
        return this.gRequiredProds;
    }

    public int getRequiredProductCount() {
        return this.gRequiredProds.size();
    }

    public void addRequiredProduct(SystemProduct aRequiredProduct) throws InvalidArgumentException {
        if (this.equals(aRequiredProduct)) {
            throw new InvalidArgumentException("ERROR_PRODUCT_SELF_DEPENDENCE", new String[]{"product=" + this.toString()});
        }
        if (this.gRequiredProds.contains(aRequiredProduct)) {
            this.gRequiredProds.remove(aRequiredProduct);
        }
        this.gRequiredProds.add(aRequiredProduct);
    }

    public void setCritical(boolean aCritical) {
        if (aCritical) {
            this.gCritical = aCritical;
        }
    }

    public boolean isCritical() {
        return this.gCritical != null && this.gCritical != false;
    }

    public void setUpgradeAll(boolean aUpgradeAll) {
        this.gUpgradeAll = aUpgradeAll;
    }

    public boolean upgradeAll() {
        return this.gUpgradeAll;
    }

    public Version getRelease() {
        return this.gRelease;
    }

    public void setRelease(Version aRelease) {
        this.gRelease = aRelease;
    }
}

